/************************************
 *  undo.cpp                        *
 *    Undo/redo facility for facade *
 ************************************/
#include <stdlib.h> //aadesche VC7
#include <GL/glut.h>	    /* OpenGl headers	- aadesche			     */
#include <vector>
#include "undo.h"

using std::vector<class T>;

#define KEY_INSERT 0
#define KEY_DELETE 1
#define KEY_REPLACE 2

static std::vector<undoRec*> *actions = new std::vector<undoRec*>;

#ifdef __cplusplus
extern "C" {
#endif

extern int ReadKey(int);
extern int DeleteKey(int);
extern int GetKey(int, float[], float[]);
extern int WriteKey(int);
extern int LookKey(int);
extern void updateGUI(void);
extern void UpdateObject(void);
extern float cpml[MAXPM];
extern float cpmr[MAXPM];

void addAction(int action, int key)
{
	float l[MAXPM];
	float r[MAXPM];

	if (action==KEY_REPLACE || action==KEY_DELETE) { GetKey(LookKey(key),l,r); actions->push_back(new undoRec(l, r, action, key)); }
	else actions->push_back(new undoRec(NULL, NULL, action, key));
}

void undoAction(void)
{
	undoRec* toUndo = actions->back();
	if (!toUndo) return;
	switch (toUndo->action)
	{
	case KEY_INSERT:
	{
		DeleteKey(toUndo->key);
		actions->pop_back();
		ReadKey(toUndo->key);
		UpdateObject();
		updateGUI();
		glutPostRedisplay();
		delete toUndo;
		break;
	}
	case KEY_DELETE:
	case KEY_REPLACE:
	default:
	{
		int i;
		actions->pop_back();
		for (i=0; i<MAXPM; i++)
		{
			cpml[i] = toUndo->oldpmL[i];
			cpmr[i] = toUndo->oldpmR[i];
		}
		WriteKey(toUndo->key);
		ReadKey(toUndo->key);
		UpdateObject();
		updateGUI();
		glutPostRedisplay();
		delete toUndo;
		break;
	}
	}
}
		

#ifdef __cplusplus
}
#endif