/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ApplicationArchiveListener;
import com.installshield.archive.ArchiveBuildInfo;
import com.installshield.archive.ArchiveEntry;
import com.installshield.archive.ArchiveFilter;
import com.installshield.archive.ArchiveResourceWriterFactory;
import com.installshield.archive.ArchiveWriterOutputStream;
import com.installshield.archive.ArchiveWriterRecord;
import com.installshield.archive.IndexedResourceWriter;
import com.installshield.archive.ResourceReader;
import com.installshield.archive.ResourceReaderFactory;
import com.installshield.archive.ResourceWriter;
import com.installshield.archive.ResourceWriterFactory;
import com.installshield.archive.StandardResourceReaderFactory;
import com.installshield.archive.UnknownResourceTypeException;
import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.util.ClassUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.GenericProgress;
import com.installshield.util.LogListener;
import com.installshield.util.URLUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class ArchiveWriter {
    public static final String WRITE_STARTED = "msg1.write.started";
    public static final String WRITE_FIXED_RES_STARTED = "msg1.write.fixed.res.started";
    public static final String WRITE_SPAN_RES_STARTED = "msg1.write.span.res.started";
    public static final String WRITE_FIXED_RES_FINISHED = "msg1.write.fixed.res.finished";
    public static final String WRITE_SPAN_RES_FINISHED = "msg1.write.span.res.finished";
    public static final String WRITE_FINISHED = "msg1.write.finished";
    public static final String PROGRESS = "progress";
    private Vector fixedResources = new Vector();
    private Vector spannableResources = new Vector();
    private ResourceReaderFactory readerFactory;
    private ResourceWriterFactory writerFactory;
    private ArchiveWriterRecord record = null;
    private boolean calculateProgress = true;
    private Hashtable addedPackages = new Hashtable();
    private Vector logListeners = new Vector();
    private boolean canceled = false;

    protected ArchiveWriter() {
    }

    public ArchiveWriter(ResourceReaderFactory resourceReaderFactory, ResourceWriterFactory resourceWriterFactory) throws IOException {
        this.initialize(resourceReaderFactory, resourceWriterFactory);
    }

    public void addApplicationArchiveListener(ApplicationArchiveListener applicationArchiveListener) {
        this.writerFactory.addApplicationArchiveListener(applicationArchiveListener);
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.addElement(logListener);
    }

    public void cancel() {
        this.canceled = true;
    }

    public static ArchiveWriter createArchiveWriter(String string, ArchiveWriterOutputStream archiveWriterOutputStream, String string2) throws IOException {
        return new ArchiveWriter(new StandardResourceReaderFactory(string), new ArchiveResourceWriterFactory(archiveWriterOutputStream, string2));
    }

    public ArchiveBuildInfo getArchiveBuildInfo() {
        return this.writerFactory.getArchiveBuildInfo();
    }

    public boolean getCalculateProgress() {
        return this.calculateProgress;
    }

    public int getCurrentArchiveIndexOffset() throws IOException {
        return this.writerFactory.getCurrentArchiveIndexOffset();
    }

    public ArchiveWriterRecord getRecord() {
        return this.record;
    }

    public ResourceReaderFactory getResourceReaderFactory() {
        return this.readerFactory;
    }

    public String getResourceRoot() {
        return this.writerFactory.getResourceRoot();
    }

    public ResourceWriterFactory getResourceWriterFactory() {
        return this.writerFactory;
    }

    private String getTypeDescription(Object object) {
        if (object instanceof Class) {
            try {
                Method method = ((Class)object).getMethod("getTypeDescription", new Class[0]);
                return (String)method.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        return ClassUtils.createObjectDisplayName(object);
    }

    protected void initialize(ResourceReaderFactory resourceReaderFactory, ResourceWriterFactory resourceWriterFactory) throws IOException {
        if (resourceWriterFactory == null) {
            throw new IllegalArgumentException("writerFactory cannot be null");
        }
        this.writerFactory = resourceWriterFactory;
        if (resourceReaderFactory == null) {
            throw new IllegalArgumentException("readerFactory cannot be null");
        }
        this.readerFactory = resourceReaderFactory;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void logEvent(String string, Object object) {
        int n = 0;
        while (n < this.logListeners.size()) {
            ((LogListener)this.logListeners.elementAt(n)).eventLogged(this, string, object);
            ++n;
        }
    }

    public void putApplicationResource(String string, String string2) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(new URL("ismpfile", "", -1, URLUtils.encode(string))), this.writerFactory.createFileResourceWriter(string2));
    }

    public void putArchive(String string, ArchiveFilter archiveFilter) throws IOException {
        Enumeration enumeration = this.readerFactory.archiveEntries(string, new ManifestArchiveFilter(archiveFilter), this.writerFactory);
        while (enumeration.hasMoreElements()) {
            ArchiveEntry archiveEntry = (ArchiveEntry)enumeration.nextElement();
            if (archiveEntry.getReader() == null) {
                throw new IllegalStateException("entry reader has been set to null");
            }
            if (archiveEntry.getWriter() == null) {
                throw new IllegalStateException("entry writer has been set to null");
            }
            this.putResource(archiveEntry.getReader(), archiveEntry.getWriter());
        }
    }

    public void putClass(String string) throws IOException {
        this.putResource(this.readerFactory.createClassResourceReader(String.valueOf(string.replace('.', '/')) + ".class"), this.writerFactory.createClassWriter(string));
    }

    public void putClassResource(InputStream inputStream, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(inputStream), this.writerFactory.createClassResourceWriter(string));
    }

    public void putClassResource(String string) throws IOException {
        this.putResource(this.readerFactory.createClassResourceReader(string), this.writerFactory.createClassResourceWriter(string));
    }

    public void putDefinition(Object object, Class clazz, String string) throws IOException {
        this.putResource(this.readerFactory.createDefinitionReader(object, clazz), this.writerFactory.createDefinitionWriter(string));
        this.putClassResource(String.valueOf(clazz.getName().replace('.', '/')) + ".qjml");
    }

    public void putDefinition(URL uRL, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(uRL), this.writerFactory.createDefinitionWriter(string));
    }

    public ArchiveIndexEntry putExternalResource(URL uRL, int n, String string, FileAttributes fileAttributes, long l, String string2, byte[] byArray, int n2) throws IOException {
        IndexedResourceWriter indexedResourceWriter = this.writerFactory.createExternalResourceWriter(uRL, n, string, fileAttributes, l, string2, byArray, n2);
        this.putResource(this.readerFactory.createResourceReader(uRL), indexedResourceWriter.getResourceWriter());
        return indexedResourceWriter.getArchiveIndexEntry();
    }

    public ArchiveIndexEntry putIndexedResource(URL uRL, int n, String string, FileAttributes fileAttributes, long l, byte[] byArray) throws IOException {
        IndexedResourceWriter indexedResourceWriter = this.writerFactory.createIndexedResourceWriter(uRL, n, string, fileAttributes, l, byArray);
        this.putResource(this.readerFactory.createResourceReader(uRL), indexedResourceWriter.getResourceWriter());
        return indexedResourceWriter.getArchiveIndexEntry();
    }

    public ArchiveIndexEntry putNormalResource(String string, String string2) throws IOException {
        IndexedResourceWriter indexedResourceWriter = this.writerFactory.createNormalResourceWriter(string2);
        this.putResource(this.readerFactory.createResourceReader(new URL("ismpfile", "", -1, URLUtils.encode(string))), indexedResourceWriter.getResourceWriter());
        return indexedResourceWriter.getArchiveIndexEntry();
    }

    public void putOther(String string, Object object, Object object2) throws UnknownResourceTypeException, IOException {
        this.putResource(this.readerFactory.createOtherReader(string, object), this.writerFactory.createOtherWriter(string, object2));
    }

    public void putPackage(String string) throws IOException {
        this.putPackage(string, false);
    }

    public void putPackage(String string, boolean bl) throws IOException {
        if (!this.addedPackages.containsKey(String.valueOf(string) + bl)) {
            Enumeration enumeration = this.readerFactory.packageResources(string, bl);
            while (enumeration.hasMoreElements()) {
                this.putClassResource((String)enumeration.nextElement());
            }
            this.addedPackages.put(String.valueOf(string) + bl, "");
        }
    }

    private void putResource(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        ResourceStorageInfo resourceStorageInfo = new ResourceStorageInfo(resourceReader, resourceWriter);
        Vector vector = resourceWriter.isSpannable() ? this.spannableResources : this.fixedResources;
        if (vector.contains(resourceStorageInfo)) {
            int n = vector.indexOf(resourceStorageInfo);
            vector.setElementAt(resourceStorageInfo, n);
        } else {
            vector.addElement(resourceStorageInfo);
        }
    }

    public void putResource(InputStream inputStream, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(inputStream), this.writerFactory.createFileResourceWriter(string));
    }

    public void putResource(String string, String string2) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(new URL("ismpfile", "", -1, URLUtils.encode(string))), this.writerFactory.createFileResourceWriter(string2));
    }

    public void putResource(URL uRL, String string) throws IOException {
        this.putResource(this.readerFactory.createResourceReader(uRL), this.writerFactory.createFileResourceWriter(string));
    }

    public void putResourceBundles(String string, Locale[] localeArray) throws IOException {
        boolean bl = false;
        boolean[] blArray = new boolean[localeArray.length];
        try {
            this.putClass(string);
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        int n = 0;
        while (n < localeArray.length) {
            try {
                this.putClass(String.valueOf(string) + "_" + localeArray[n].toString());
                blArray[n] = true;
            }
            catch (IOException iOException) {
                blArray[n] = false;
            }
            ++n;
        }
        String string2 = string.replace('.', '/');
        if (!bl) {
            try {
                this.putClassResource(String.valueOf(string2) + ".properties");
                bl = true;
            }
            catch (IOException iOException) {}
        }
        int n2 = 0;
        while (n2 < localeArray.length) {
            try {
                if (!blArray[n2]) {
                    this.putClassResource(String.valueOf(string2) + "_" + localeArray[n2].toString() + ".properties");
                    blArray[n2] = true;
                }
            }
            catch (IOException iOException) {}
            ++n2;
        }
        if (!bl) {
            throw new IOException("could not find default resource bundle for " + string);
        }
        int n3 = 0;
        while (n3 < blArray.length) {
            if (!blArray[n3]) {
                this.logEvent("wrn", "could not find resource bundle for " + string + " (" + localeArray[n3] + ")");
            }
            ++n3;
        }
    }

    private boolean readerWrittenBy(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        if (this.record == null) {
            return false;
        }
        return this.record.readerWrittenBy(resourceReader, resourceWriter);
    }

    private void recordResourceWrite(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        if (this.record != null) {
            this.record.record(resourceReader, resourceWriter);
        }
    }

    public void removeApplicationArchiveListener(ApplicationArchiveListener applicationArchiveListener) {
        this.writerFactory.removeApplicationArchiveListener(applicationArchiveListener);
    }

    public void removeLogListener(LogListener logListener) {
        this.logListeners.removeElement(logListener);
    }

    private boolean resourceChanged(ResourceReader resourceReader) {
        if (this.record == null) {
            return true;
        }
        Date date = this.record.getDate(resourceReader);
        return date == null || !date.equals(resourceReader.getDate());
    }

    private boolean resourceChanged(ResourceWriter resourceWriter) {
        if (this.record == null) {
            return true;
        }
        Date date = this.record.getDate(resourceWriter);
        return date == null || !date.equals(resourceWriter.getDate());
    }

    public void setCalculateProgress(boolean bl) {
        this.calculateProgress = bl;
    }

    public void setRecord(ArchiveWriterRecord archiveWriterRecord) {
        this.record = archiveWriterRecord;
    }

    public void write() {
        this.logEvent(WRITE_STARTED, "Started writing archive");
        GenericProgress genericProgress = new GenericProgress();
        this.write(this.fixedResources, genericProgress, "installer archive", WRITE_FIXED_RES_STARTED, WRITE_FIXED_RES_FINISHED);
        try {
            this.writerFactory.finishFixedResources();
            this.write(this.spannableResources, genericProgress, "media archive", WRITE_SPAN_RES_STARTED, WRITE_SPAN_RES_FINISHED);
        }
        catch (IOException iOException) {
            this.logEvent("err", iOException.getMessage());
        }
        if (!this.canceled) {
            this.logEvent(WRITE_FINISHED, "Finished writing archive ");
        }
    }

    private void write(Vector vector, GenericProgress genericProgress, String string, String string2, String string3) {
        if (!this.canceled) {
            Object object;
            Object object2;
            byte[] byArray = new byte[5120];
            int n = 0;
            genericProgress.setStatusDescription("Writing " + string + "...");
            Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
            long l = 0L;
            if (this.calculateProgress) {
                Enumeration enumeration = vector.elements();
                while (!this.canceled && enumeration.hasMoreElements()) {
                    ResourceStorageInfo resourceStorageInfo = (ResourceStorageInfo)enumeration.nextElement();
                    object2 = resourceStorageInfo.getResourceReader();
                    if (this.readerWrittenBy((ResourceReader)object2, (ResourceWriter)(object = resourceStorageInfo.getResourceWriter())) && !this.resourceChanged((ResourceReader)object2) && !this.resourceChanged((ResourceWriter)object)) {
                        hashtable.put(object2, "");
                        continue;
                    }
                    try {
                        l += (long)object2.getSize();
                    }
                    catch (IOException iOException) {
                        this.logEvent("wrn", "Error reading size for " + object2 + ": " + iOException);
                    }
                }
            }
            long l2 = 0L;
            object2 = vector.elements();
            while (!this.canceled && object2.hasMoreElements()) {
                object = (ResourceStorageInfo)object2.nextElement();
                ResourceReader resourceReader = ((ResourceStorageInfo)object).getResourceReader();
                if (hashtable.containsKey(resourceReader)) continue;
                ResourceWriter resourceWriter = ((ResourceStorageInfo)object).getResourceWriter();
                try {
                    OutputStream outputStream;
                    InputStream inputStream;
                    block13: {
                        inputStream = resourceReader.open();
                        outputStream = resourceWriter.open();
                        int n2 = 0;
                        if (inputStream != null && outputStream != null) {
                            try {
                                while (!this.canceled && (n = inputStream.read(byArray)) != -1) {
                                    outputStream.write(byArray, 0, n);
                                    if (!this.calculateProgress) continue;
                                    n2 += n;
                                    genericProgress.setPercentComplete(l2 += (long)n, l);
                                    this.logEvent(PROGRESS, genericProgress);
                                }
                            }
                            catch (EOFException eOFException) {
                                if (inputStream.available() <= 0) break block13;
                                throw eOFException;
                            }
                        }
                    }
                    resourceReader.close(inputStream);
                    resourceWriter.close(outputStream);
                    this.recordResourceWrite(resourceReader, resourceWriter);
                }
                catch (IOException iOException) {
                    this.logEvent("wrn", "Error writing " + resourceReader + " to " + resourceWriter + ": " + iOException);
                    if (System.getProperty("is.debug") == null) continue;
                    iOException.printStackTrace();
                }
            }
        }
    }

    private class ManifestArchiveFilter
    implements ArchiveFilter {
        ArchiveFilter filter;

        public ManifestArchiveFilter(ArchiveFilter archiveFilter) {
            this.filter = archiveFilter;
        }

        public boolean filter(ArchiveEntry archiveEntry, ResourceWriterFactory resourceWriterFactory) throws IOException {
            boolean bl = false;
            if (!archiveEntry.getName().toLowerCase().endsWith("manifest.mf")) {
                archiveEntry.setWriter(resourceWriterFactory.createClassResourceWriter(archiveEntry.getName()));
                bl = this.filter.filter(archiveEntry, resourceWriterFactory);
            }
            return bl;
        }
    }

    private class ResourceStorageInfo {
        private ResourceReader reader;
        private ResourceWriter writer;

        public ResourceStorageInfo(ResourceReader resourceReader, ResourceWriter resourceWriter) {
            this.reader = resourceReader;
            this.writer = resourceWriter;
        }

        public boolean equals(Object object) {
            return object instanceof ResourceStorageInfo && ((ResourceStorageInfo)object).reader.equals(this.reader);
        }

        public ResourceReader getResourceReader() {
            return this.reader;
        }

        public ResourceWriter getResourceWriter() {
            return this.writer;
        }

        public int hashCode() {
            return this.reader.hashCode();
        }
    }
}

