/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ResourceReader;
import com.installshield.archive.URLResourceReader;
import com.installshield.archive.ZipEntryResourceReader;
import com.installshield.util.ClassLocator;
import com.installshield.util.URLUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class ClassResourceReader
implements ResourceReader {
    private String resName;
    private ResourceReader reader;

    public ClassResourceReader(String string, ClassLocator classLocator) throws FileNotFoundException {
        String string2 = classLocator.findClassResource(string);
        if (string2 == null) {
            throw new FileNotFoundException("could not find resource " + string);
        }
        int n = string2.indexOf("!/");
        if (n != -1) {
            this.reader = new ZipEntryResourceReader(string2.substring(0, n), string2.substring(n + 2));
        } else {
            try {
                this.reader = new URLResourceReader(new URL("ismpfile", "", -1, URLUtils.encode(string2)));
            }
            catch (MalformedURLException malformedURLException) {
                throw new Error();
            }
        }
        this.resName = string;
    }

    public void close(InputStream inputStream) throws IOException {
        inputStream.close();
    }

    public boolean equals(Object object) {
        return object instanceof ClassResourceReader && ((ClassResourceReader)object).resName.equals(this.resName);
    }

    public Date getDate() {
        return this.reader.getDate();
    }

    public String getId() {
        return this.reader.getId();
    }

    public String getResourceName() {
        return this.resName;
    }

    public int getSize() throws IOException {
        return this.reader.getSize();
    }

    public static String getTypeDescription() {
        return "class definitions";
    }

    public int hashCode() {
        return this.resName.hashCode();
    }

    public InputStream open() throws IOException {
        return this.reader.open();
    }

    public String toString() {
        return "Class Resource Reader (" + this.resName + ")";
    }
}

