/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.extras.wizard.condition;

import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FileExistsCondition
extends WizardBeanCondition {
    private String[] searchDirectories = new String[0];
    private String fileName = "";
    private boolean recursiveSearch;
    private Map dirList;

    public boolean evaluateTrueCondition() {
        this.dirList = new HashMap();
        int n = 0;
        while (n < this.searchDirectories.length) {
            String string = this.getWizardBean().getServices().resolveString(this.searchDirectories[n]);
            this.fileName = this.getWizardBean().getServices().resolveString(this.fileName);
            if (this.fileExists(string, this.fileName, this.recursiveSearch)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean fileExists(String string, String string2, boolean bl) {
        File file = new File(string);
        try {
            string = file.getCanonicalPath().toString();
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.dirList.containsKey(string)) {
            return false;
        }
        this.dirList.put(string, null);
        try {
            FileService fileService = (FileService)this.getWizardBean().getWizard().getServices().getService("fileService");
            this.logEvent(this, "dbg", "Checking " + FileUtils.appendSeparator(string) + string2);
            if (fileService.fileExists(FileUtils.appendSeparator(string) + string2)) {
                return true;
            }
            if (!bl) {
                return false;
            }
            if (!fileService.isDirectory(string)) {
                return false;
            }
            String[] stringArray = fileService.getDirectoryList(string, 1);
            int n = 0;
            while (n < stringArray.length) {
                if (this.fileExists(FileUtils.appendSeparator(string) + stringArray[n], string2, bl)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", "Unable to use FileServuice: " + serviceException.toString());
            return false;
        }
    }

    public String defaultName() {
        return "File Exists Condition";
    }

    public String describe() {
        String string = this.fileName + " must ";
        if (this.getEvaluate() == 2) {
            string = string + "not ";
        }
        string = string + "exist under search directories.";
        return string;
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        if (this.fileName.equals("")) {
            wizardBuilderSupport.logEvent(this, "err", "File Name property can not be null");
            wizardBuilderSupport.setBuildCanceled(true);
        }
        if (this.searchDirectories.length == 0) {
            wizardBuilderSupport.logEvent(this, "err", "Search Directories property can not be null");
            wizardBuilderSupport.setBuildCanceled(true);
        }
        wizardBuilderSupport.putRequiredService("fileService");
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String[] getSearchDirectories() {
        return this.searchDirectories;
    }

    public void setSearchDirectories(String[] stringArray) {
        this.searchDirectories = stringArray;
    }

    public boolean getRecursiveSearch() {
        return this.recursiveSearch;
    }

    public void setRecursiveSearch(boolean bl) {
        this.recursiveSearch = bl;
    }
}

