/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

class AWTIconBase
extends Panel
implements AdjustmentListener {
    private String OSName;
    protected Scrollbar vs;
    protected Scrollbar hs;
    protected int m_nVScrollbarWidth = 15;
    protected int m_nHScrollbarHeight = 15;
    protected transient Image offscreen = null;
    protected int m_nTopRow = 0;
    protected int m_nLeftCol = 0;
    protected boolean m_bAlwaysShowScrollbar = false;
    protected boolean m_bDoubleBuffering = true;

    public AWTIconBase() {
        this(false);
        this.setLayout(null);
    }

    public AWTIconBase(boolean bl) {
        this.m_bAlwaysShowScrollbar = bl;
        this.vs = new Scrollbar(1);
        this.hs = new Scrollbar(0);
        this.vs.addAdjustmentListener(this);
        this.hs.addAdjustmentListener(this);
        this.setLayout(null);
        this.add(this.vs);
        this.add(this.hs);
        this.enableEvents(4L);
        this.enableEvents(16L);
        this.enableEvents(8L);
        this.enableEvents(256L);
        this.enableEvents(32L);
        this.OSName = System.getProperty("os.name");
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getID() == 601) {
            if (adjustmentEvent.getSource() instanceof Scrollbar && ((Scrollbar)adjustmentEvent.getSource()).getOrientation() == 1) {
                int n = this.getVScrollbar().getValue();
                if (this.onTopRowChange(n)) {
                    this.m_nTopRow = n;
                    this.onTopRowChanged(n);
                }
            } else {
                int n = this.getHScrollbar().getValue();
                if (this.onLeftColChange(n)) {
                    this.m_nLeftCol = n;
                    this.onLeftColChanged(n);
                }
            }
        }
    }

    public synchronized void doLayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Scrollbar scrollbar = this.getVScrollbar();
        Scrollbar scrollbar2 = this.getHScrollbar();
        if (this.m_bAlwaysShowScrollbar || this.getMaxTopRow() != 0) {
            scrollbar2.setBounds(0, n2 - this.m_nHScrollbarHeight, n - this.m_nVScrollbarWidth, this.m_nHScrollbarHeight);
        } else {
            scrollbar2.setBounds(0, n2 - this.m_nHScrollbarHeight, n, this.m_nHScrollbarHeight);
        }
        if (this.m_bAlwaysShowScrollbar || this.getMaxLeftCol() != 0) {
            scrollbar.setBounds(n - this.m_nVScrollbarWidth, 0, this.m_nVScrollbarWidth, n2 - this.m_nHScrollbarHeight);
        } else {
            scrollbar.setBounds(n - this.m_nVScrollbarWidth, 0, this.m_nVScrollbarWidth, n2);
        }
    }

    protected void draw(Graphics graphics) {
    }

    public boolean getAlwaysShowScrollbars() {
        return this.m_bAlwaysShowScrollbar;
    }

    public Scrollbar getHScrollbar() {
        return this.hs;
    }

    public int getHScrollbarHeight() {
        return this.m_nHScrollbarHeight;
    }

    protected int getMaxLeftCol() {
        return 0;
    }

    protected int getMaxTopRow() {
        return 0;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 80);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            return dimension;
        }
        return this.getMinimumSize();
    }

    public Scrollbar getVScrollbar() {
        return this.vs;
    }

    public int getVScrollbarWidth() {
        return this.m_nVScrollbarWidth;
    }

    public void hideHScrollbar() {
        this.getHScrollbar().setVisible(false);
    }

    public void hideScrollbar() {
        this.hideVScrollbar();
        this.hideHScrollbar();
    }

    public void hideVScrollbar() {
        this.getVScrollbar().setVisible(false);
    }

    public boolean isDoubleBuffering(boolean bl) {
        return this.m_bDoubleBuffering;
    }

    protected boolean onLeftColChange(int n) {
        return true;
    }

    protected void onLeftColChanged(int n) {
        this.repaint();
    }

    protected boolean onTopRowChange(int n) {
        return true;
    }

    protected void onTopRowChanged(int n) {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.m_bDoubleBuffering && this.validateImage()) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = graphics.getClipBounds();
            Graphics graphics2 = this.offscreen.getGraphics();
            if (rectangle != null) {
                graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics2.setFont(graphics.getFont());
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
            graphics2.setColor(graphics.getColor());
            this.draw(graphics2);
            graphics.drawImage(this.offscreen, 0, 0, this);
            graphics2.dispose();
        } else {
            this.draw(graphics);
        }
    }

    public void repaint() {
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = dimension.width;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.update(graphics, 0, 0, n2, n);
            graphics.dispose();
        }
    }

    public void setAlwaysShowScrollbars(boolean bl) {
        this.m_bAlwaysShowScrollbar = bl;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        this.updateScrollbar();
    }

    public void setDoubleBuffering(boolean bl) {
        this.m_bDoubleBuffering = bl;
    }

    public void setHScrollbarHeight(int n) {
        if (n > 0) {
            this.m_nHScrollbarHeight = n;
            this.doLayout();
        }
    }

    public void setVScrollbarWidth(int n) {
        if (n > 0) {
            this.m_nVScrollbarWidth = n;
            this.doLayout();
        }
    }

    public void showHScrollbar() {
        this.getHScrollbar().setVisible(true);
    }

    public void showVScrollbar() {
        this.getVScrollbar().setVisible(true);
    }

    public void update() {
        Dimension dimension = this.getSize();
        int n = dimension.height;
        int n2 = dimension.width;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.update(graphics, 0, 0, n2, n);
            graphics.dispose();
        }
    }

    public void update(Graphics graphics) {
        if (this.m_bDoubleBuffering) {
            this.paint(graphics);
        } else {
            super.update(graphics);
        }
    }

    public void update(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.clipRect(n, n2, n3, n4);
        this.paint(graphics);
    }

    protected void updateScrollbar() {
        int n;
        int n2 = this.getMaxTopRow();
        int n3 = this.getMaxLeftCol();
        Scrollbar scrollbar = this.getVScrollbar();
        Scrollbar scrollbar2 = this.getHScrollbar();
        if (n2 == 0) {
            this.m_nTopRow = 0;
            if (this.m_bAlwaysShowScrollbar) {
                scrollbar.setEnabled(false);
            } else {
                scrollbar.setVisible(false);
            }
        }
        if ((n = n2 / 10) < 5) {
            n = 5;
        }
        scrollbar.setValues(scrollbar.getValue(), 1, 0, n2);
        scrollbar.setBlockIncrement(n);
        scrollbar.setUnitIncrement(1);
        if (n2 > 0) {
            scrollbar.setVisible(true);
        }
        if (n3 == 0) {
            this.m_nLeftCol = 0;
            if (this.m_bAlwaysShowScrollbar) {
                scrollbar2.setEnabled(false);
            } else {
                scrollbar2.setVisible(false);
            }
        }
        if ((n = n3 / 10) < 5) {
            n = 5;
        }
        scrollbar2.setValues(scrollbar2.getValue(), 1, 0, n3);
        scrollbar2.setBlockIncrement(n);
        scrollbar2.setUnitIncrement(1);
        if (n3 > 0) {
            scrollbar2.setVisible(true);
        }
        this.doLayout();
        this.update();
    }

    protected boolean validateImage() {
        try {
            Dimension dimension = this.getSize();
            if (this.offscreen == null || this.offscreen.getWidth(this) != dimension.width || this.offscreen.getHeight(this) != dimension.height) {
                if (dimension.width > 0 && dimension.height > 0) {
                    this.offscreen = this.createImage(dimension.width, dimension.height);
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

