/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.commandline;

import com.installshield.qjml.QJML;
import com.installshield.qjml.QJMLException;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.OptionsTemplateEntry;
import com.installshield.wizard.StandardWizardTreeIterator;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBuilderSupport;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public class GenerateOptionsTemplate
extends CommandLineBean {
    private static final int LINE_WIDTH = 80;
    private static final int INDENT_WIDTH = 3;
    private boolean errorFormatting = false;
    static /* synthetic */ Class class$com$installshield$wizard$commandline$GenerateOptionsTemplate$OptionsTextParser;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putClass((class$com$installshield$wizard$commandline$GenerateOptionsTemplate$OptionsTextParser != null ? class$com$installshield$wizard$commandline$GenerateOptionsTemplate$OptionsTextParser : (class$com$installshield$wizard$commandline$GenerateOptionsTemplate$OptionsTextParser = GenerateOptionsTemplate.class$("com.installshield.wizard.commandline.GenerateOptionsTemplate$OptionsTextParser"))).getName());
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void createOptionsFile(String string, int n, Wizard wizard) {
        try {
            this.errorFormatting = false;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(fileOutputStream), true);
            this.printRule(printWriter);
            this.printComment(printWriter);
            if (n == 1) {
                this.printComment(printWriter, this.resolve("templateTitle"));
            } else {
                this.printComment(printWriter, this.resolve("recordTitle"));
            }
            this.printComment(printWriter);
            this.printComment(printWriter, this.resolve("wizardName", new String[]{wizard.getName()}));
            this.printComment(printWriter, this.resolve("wizardSource", new String[]{this.getWizardSource(wizard)}));
            this.printComment(printWriter, this.resolve("createdOn", new String[]{new Date().toString()}));
            this.printComment(printWriter, this.resolve("createdBy", new String[]{this.resolve("fileCreator")}));
            this.printComment(printWriter);
            if (n == 1) {
                this.printComment(printWriter, this.parseOptionsText(this.resolve("templateInstructions", new String[]{wizard.getName()})));
            } else {
                this.printComment(printWriter, this.parseOptionsText(this.resolve("recordInstructions", new String[]{wizard.getName(), string})));
            }
            this.printComment(printWriter);
            this.printRule(printWriter);
            StandardWizardTreeIterator standardWizardTreeIterator = new StandardWizardTreeIterator(wizard.getWizardTree());
            WizardBean wizardBean = standardWizardTreeIterator.getNext(standardWizardTreeIterator.begin());
            boolean bl = false;
            while (wizardBean != standardWizardTreeIterator.end()) {
                if (wizardBean.isActive()) {
                    OptionsTemplateEntry[] optionsTemplateEntryArray = wizardBean.getOptionsTemplateEntries(n);
                    int n2 = 0;
                    while (optionsTemplateEntryArray != null && n2 < optionsTemplateEntryArray.length) {
                        printWriter.println();
                        printWriter.println();
                        this.printRule(printWriter);
                        this.printComment(printWriter);
                        this.printComment(printWriter, this.parseOptionsText(optionsTemplateEntryArray[n2].getTitle()));
                        this.printComment(printWriter);
                        this.printComment(printWriter, this.parseOptionsText(optionsTemplateEntryArray[n2].getDocumentation()));
                        this.printComment(printWriter);
                        printWriter.println();
                        printWriter.println();
                        if (n == 1) {
                            printWriter.println("### " + optionsTemplateEntryArray[n2].getOption());
                        } else {
                            printWriter.println(optionsTemplateEntryArray[n2].getOption());
                        }
                        bl = true;
                        ++n2;
                    }
                }
                wizardBean = standardWizardTreeIterator.getNext(wizardBean);
            }
            if (!bl) {
                printWriter.println();
                printWriter.println();
                this.printRule(printWriter);
                this.printComment(printWriter);
                this.printComment(printWriter, this.parseOptionsText(this.resolve("noModifiableOptions")));
                this.printComment(printWriter);
            }
            System.out.print("Options file " + string + " was successfully created");
            if (this.errorFormatting) {
                System.out.print(", however one or more entries were not formatted properly");
            }
            System.out.println();
        }
        catch (IOException iOException) {
            wizard.getServices().logEvent(this, "err", iOException);
        }
    }

    private String escapeEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c != '&' || n + 4 <= string.length() && string.substring(n, n + 4).equalsIgnoreCase("&lt;") || n + 5 <= string.length() && string.substring(n, n + 5).equalsIgnoreCase("&amp;"))) {
                stringBuffer.append("&amp;");
            } else if (!(c != '<' || n + 4 <= string.length() && string.substring(n, n + 4).equalsIgnoreCase("<p/>") || n + 6 <= string.length() && string.substring(n, n + 6).equalsIgnoreCase("<enum>") || n + 7 <= string.length() && string.substring(n, n + 7).equalsIgnoreCase("</enum>") || n + 7 <= string.length() && string.substring(n, n + 7).equalsIgnoreCase("<value>") || n + 8 <= string.length() && string.substring(n, n + 8).equalsIgnoreCase("</value>") || n + 8 <= string.length() && string.substring(n, n + 8).equalsIgnoreCase("<indent>") || n + 9 <= string.length() && string.substring(n, n + 9).equalsIgnoreCase("</indent>"))) {
                stringBuffer.append("&lt;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean execute(Wizard wizard, String[] stringArray) {
        if (stringArray.length != 1) {
            wizard.setExitCode(1001);
            System.err.println("Invalid command line option: options-template requires a file name");
            return false;
        }
        this.createOptionsFile(stringArray[0], 1, wizard);
        return false;
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("options-template");
    }

    private String getWizardSource(Wizard wizard) {
        return FileUtils.getName(wizard.getHome());
    }

    private String[] parseLines(String string, int n) {
        Object object;
        if (n <= 0) {
            throw new Error();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t");
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            n3 = stringBuffer.length() > 0 ? 1 : 0;
            object = stringTokenizer.nextToken();
            if (n2 + object.length() + n3 > n) {
                if (stringBuffer.length() > 0) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                Object object2 = object;
                while (object2.length() > n) {
                    vector.addElement(object2.substring(0, n));
                    object2 = object2.substring(n);
                }
                stringBuffer.append((String)object2);
                n2 = object2.length();
                continue;
            }
            if (n3 > 0) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append((String)object);
            n2 += object.length();
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private String[] parseOptionsText(String string) {
        try {
            Parser parser = QJML.getParser();
            OptionsTextParser optionsTextParser = new OptionsTextParser();
            parser.setDocumentHandler(optionsTextParser);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"" + System.getProperty("file.encoding") + "\"?>");
            stringBuffer.append("<root>");
            stringBuffer.append(this.escapeEntities(string));
            stringBuffer.append("</root>");
            byte[] byArray = stringBuffer.toString().getBytes();
            parser.parse(new InputSource(new ByteArrayInputStream(byArray)));
            return optionsTextParser.getText();
        }
        catch (QJMLException qJMLException) {
            throw new Error();
        }
        catch (Exception exception) {
            System.err.println("Error formatting options file entry (starting with \"" + string.substring(0, Math.min(20, string.length())) + "...\"): " + exception.getMessage());
            this.errorFormatting = true;
            return this.parseLines(string, 78);
        }
    }

    private void printComment(PrintWriter printWriter) {
        printWriter.println("#");
    }

    private void printComment(PrintWriter printWriter, String string) {
        printWriter.println("# " + string);
    }

    private void printComment(PrintWriter printWriter, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.printComment(printWriter, stringArray[n]);
            ++n;
        }
    }

    private void printRule(PrintWriter printWriter) {
        int n = 0;
        while (n < 80) {
            printWriter.print('#');
            ++n;
        }
        printWriter.println();
    }

    private String resolve(String string) {
        return LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "OptionsTemplate." + string);
    }

    private String resolve(String string, String[] stringArray) {
        return LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "OptionsTemplate." + string, stringArray);
    }

    private class OptionsTextParser
    extends HandlerBase {
        private Stack elements = new Stack();
        private int type;
        private Vector strings = new Vector();
        private Vector values = new Vector();
        private StringBuffer cdata = new StringBuffer();

        OptionsTextParser() {
        }

        public void characters(char[] cArray, int n, int n2) {
            this.cdata.append(new String(cArray, n, n2));
        }

        public void endElement(String string) {
            this.printCData();
            if (string.equals("enum")) {
                String[] stringArray;
                int n;
                this.strings.addElement("");
                Vector<Object> vector = new Vector<Object>();
                Vector<String> vector2 = new Vector<String>();
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.values.size()) {
                    String string2 = this.values.elementAt(n3).toString();
                    n = string2.indexOf(58);
                    if (n != -1) {
                        stringArray = string2.substring(0, n);
                        n2 = Math.max(n2, stringArray.length());
                        vector.addElement(stringArray);
                        String string3 = string2.substring(n + 1);
                        vector2.addElement(string3);
                    } else {
                        vector.addElement("");
                        vector2.addElement(string2);
                    }
                    ++n3;
                }
                int n4 = 71 - n2;
                n = 0;
                while (n < vector.size()) {
                    stringArray = GenerateOptionsTemplate.this.parseLines(vector2.elementAt(n).toString(), n4);
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        int n6;
                        StringBuffer stringBuffer = new StringBuffer();
                        if (n5 == 0) {
                            n6 = 0;
                            while (n6 < 3) {
                                stringBuffer.append(' ');
                                ++n6;
                            }
                            String string4 = vector.elementAt(n).toString();
                            stringBuffer.append(string4);
                            int n7 = string4.length();
                            while (n7 < n2) {
                                stringBuffer.append(' ');
                                ++n7;
                            }
                            stringBuffer.append(" - ");
                        } else {
                            n6 = 0;
                            while (n6 < n2 + 3 + 3) {
                                stringBuffer.append(' ');
                                ++n6;
                            }
                        }
                        stringBuffer.append(stringArray[n5]);
                        this.strings.addElement(stringBuffer.toString());
                        ++n5;
                    }
                    ++n;
                }
            }
            this.elements.pop();
        }

        String[] getText() {
            Object[] objectArray = new String[this.strings.size()];
            this.strings.copyInto(objectArray);
            return objectArray;
        }

        private void printCData() {
            if (this.cdata.length() > 0) {
                String string = this.cdata.toString();
                this.cdata.setLength(0);
                if (this.elements.peek().equals("indent")) {
                    if (this.strings.size() > 0) {
                        this.strings.addElement("");
                    }
                    String[] stringArray = GenerateOptionsTemplate.this.parseLines(string, 72);
                    int n = 0;
                    while (n < stringArray.length) {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n2 = 0;
                        while (n2 < 3) {
                            stringBuffer.append(' ');
                            ++n2;
                        }
                        stringBuffer.append(stringArray[n]);
                        this.strings.addElement(stringBuffer.toString());
                        ++n;
                    }
                } else if (this.elements.peek().equals("value")) {
                    this.values.addElement(string);
                } else {
                    if (this.strings.size() > 0) {
                        this.strings.addElement("");
                    }
                    String[] stringArray = GenerateOptionsTemplate.this.parseLines(string, 78);
                    int n = 0;
                    while (n < stringArray.length) {
                        this.strings.addElement(stringArray[n]);
                        ++n;
                    }
                }
            }
            this.cdata.setLength(0);
        }

        public void startElement(String string, AttributeList attributeList) {
            this.printCData();
            this.elements.push(string);
        }
    }
}

