/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.console;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.util.TTYTable;
import java.util.Vector;

public class ConsoleChoice {
    public static final int YES = 1;
    public static final int NO = 2;
    private boolean multiSelect = false;
    private String[] options;
    private String[] optionDescriptions;
    private int optionsIndent = 0;
    private int[] selected = new int[0];
    private boolean initialized = false;
    private boolean canContinue = true;
    private int[] required = new int[0];
    private String caption = LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.caption");

    public ConsoleChoice() {
        this(new String[0]);
    }

    public ConsoleChoice(String[] stringArray) {
        this(stringArray, false);
    }

    public ConsoleChoice(String[] stringArray, boolean bl) {
        this(stringArray, bl, new int[0]);
    }

    public ConsoleChoice(String[] stringArray, boolean bl, int[] nArray) {
        this.options = stringArray;
        this.optionDescriptions = new String[stringArray.length];
        this.multiSelect = bl;
        this.selected = nArray;
    }

    public boolean canContinue() {
        return this.canContinue;
    }

    public static int confirm(TTYDisplay tTYDisplay, String string, int n) {
        tTYDisplay.printLine();
        tTYDisplay.printLine(string);
        tTYDisplay.printLine();
        String string2 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "yes");
        String string3 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "no");
        String string4 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ttyDisplayTwoOptions", new String[]{"1", string2, "2", string3});
        return tTYDisplay.promptInt(string4, n == 1 ? 1 : 2, 1, 2) == 1 ? 1 : 2;
    }

    private boolean confirmRequired(TTYDisplay tTYDisplay) {
        int n = 0;
        while (n < this.required.length) {
            if (this.required[n] >= 0 && this.required[n] < this.options.length && !this.isSelected(this.required[n])) {
                tTYDisplay.printLine();
                tTYDisplay.printLine(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.couldNotUnselect"));
                return false;
            }
            ++n;
        }
        return true;
    }

    public void consoleInteraction(TTYDisplay tTYDisplay) {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            if (bl) {
                tTYDisplay.printLine();
            }
            bl = true;
            TTYTable tTYTable = this.createTable();
            tTYDisplay.printTable(tTYTable);
            tTYDisplay.printLine();
            int n = tTYDisplay.promptInt(this.caption, 0, 0, this.options.length);
            tTYDisplay.printLine();
            if (n == 0) {
                bl2 = this.confirmRequired(tTYDisplay) && this.canContinue;
                continue;
            }
            if (this.deselectingRequired(n - 1)) {
                tTYDisplay.printLine();
                tTYDisplay.printLine(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.couldNotUnselect"));
                continue;
            }
            this.updateSelected(n - 1);
            if (this.multiSelect || !tTYDisplay.isAccessibilityEnabled()) continue;
            String string = this.getSelectedIndex() >= 0 ? LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.currentChoice", new String[]{this.options[this.getSelectedIndex()]}) : LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.currentChoiceEmpty");
            boolean bl3 = bl2 = tTYDisplay.promptInt(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.confirmChoice"), 0, 0, 1, string) == 0;
        }
    }

    private TTYTable createTable() {
        TTYTable tTYTable = new TTYTable();
        tTYTable.setIndent(this.optionsIndent);
        int n = 0;
        while (n < this.options.length) {
            tTYTable.addRow(new String[]{this.isSelected(n) ? "[X]" : "[ ]", String.valueOf(n + 1), "-", this.options[n]});
            if (this.optionDescriptions[n] != null) {
                if (this.optionDescriptions[n].trim().length() > 0 || n < this.options.length - 1) {
                    tTYTable.addRow(new String[]{"", "", "", this.optionDescriptions[n]});
                }
                if (this.optionDescriptions[n].trim().length() > 0 && n < this.options.length - 1) {
                    tTYTable.addRow(new String[]{""});
                }
            }
            ++n;
        }
        tTYTable.setColWeight(3, 1);
        return tTYTable;
    }

    private boolean deselectingRequired(int n) {
        if (this.multiSelect) {
            return this.isRequired(n) && this.isSelected(n);
        }
        return this.required.length > 0 && this.required[0] != n && this.isSelected(this.required[0]);
    }

    public String getCaption() {
        return this.caption;
    }

    private int getItemIndex(String string) {
        int n = 0;
        while (n < this.options.length) {
            if (string.equals(this.options[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String[] getOptionDescriptions() {
        return this.optionDescriptions;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getOptionsIndent() {
        return this.optionsIndent;
    }

    public int[] getRequired() {
        return this.required;
    }

    public int[] getSelected() {
        return this.selected;
    }

    public int getSelectedIndex() {
        int[] nArray = this.getSelected();
        if (nArray.length > 0) {
            return nArray[0];
        }
        return -1;
    }

    public String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (this.options.length > 0 && n != -1) {
            return this.options[n];
        }
        return null;
    }

    public String[] getSelectedItems() {
        int[] nArray = this.getSelected();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.options[nArray[n]];
            ++n;
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelected();
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.options[n];
            ++n;
        }
        return objectArray;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    private boolean isRequired(int n) {
        int n2 = 0;
        while (n2 < this.required.length) {
            if (this.required[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSelected(int n) {
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (n == this.selected[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public void setContinue(boolean bl) {
        this.canContinue = bl;
    }

    public void setMultiSelect(boolean bl) {
        if (this.required.length <= 1) {
            this.multiSelect = bl;
        }
        if (!bl && this.required.length > 1) {
            throw new Error();
        }
    }

    public void setOptionDescriptions(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("optionDescriptions cannot be null");
        }
        if (stringArray.length != this.options.length) {
            throw new IllegalArgumentException("optionDescriptions must be the same size as options");
        }
        this.optionDescriptions = stringArray;
    }

    public void setOptions(String[] stringArray) {
        this.options = stringArray;
        this.optionDescriptions = new String[stringArray.length];
    }

    public void setOptionsIndent(int n) {
        this.optionsIndent = n;
    }

    public void setRequired(int[] nArray) {
        this.required = nArray;
        if (nArray.length > 1) {
            this.multiSelect = true;
        }
    }

    public void setSelected(int n) {
        this.setSelected(new int[]{n});
    }

    public void setSelected(int n, boolean bl) {
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl2 = bl;
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] != n || bl) {
                vector.addElement(new Integer(this.selected[n2]));
                if (this.selected[n2] == n) {
                    bl2 = false;
                }
            }
            ++n2;
        }
        if (bl2) {
            vector.addElement(new Integer(n));
        }
        int[] nArray = this.selected;
        synchronized (nArray) {
            this.selected = new int[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                this.selected[n3] = (Integer)vector.elementAt(n3);
                ++n3;
            }
        }
    }

    public void setSelected(int[] nArray) {
        this.selected = this.multiSelect || nArray.length == 0 ? nArray : new int[]{nArray[0]};
    }

    private void updateSelected(int n) {
        int n2;
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = false;
        if (this.multiSelect) {
            n2 = 0;
            while (n2 < this.selected.length) {
                if (this.selected[n2] == n) {
                    bl = true;
                } else {
                    vector.addElement(new Integer(this.selected[n2]));
                }
                ++n2;
            }
        }
        if (!bl) {
            vector.addElement(new Integer(n));
        }
        this.selected = new int[vector.size()];
        n2 = 0;
        while (n2 < vector.size()) {
            this.selected[n2] = (Integer)vector.elementAt(n2);
            ++n2;
        }
    }
}

