/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.install;

import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;
import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleCommandOption
extends CommandLineBean {
    public CommandLineOption getOption() {
        return new CommandLineOption("wizardlocale");
    }

    public boolean execute(Wizard wizard, String[] stringArray) {
        Locale locale = stringArray.length > 0 ? this.parseLocaleString(stringArray[0]) : new Locale("", "");
        Locale[] localeArray = this.getSupportedLocales(wizard);
        for (int i = 0; i < localeArray.length; ++i) {
            if (!locale.equals(localeArray[i])) continue;
            wizard.setDefaultLocale(locale.toString());
            wizard.setLocaleSelectOption(4);
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(wizard.getAvailableLocales(), ",");
        int n = stringTokenizer.countTokens();
        Locale[] localeArray2 = new Locale[n];
        for (int i = 0; i < n; ++i) {
            localeArray2[i] = this.parseLocaleString(stringTokenizer.nextToken());
        }
        if (n > 1) {
            wizard.setLocaleSelectOption(3);
        } else {
            wizard.setDefaultLocale(localeArray2[0].toString());
            wizard.setLocaleSelectOption(4);
        }
        return true;
    }

    private Locale[] getSupportedLocales(Wizard wizard) {
        StringTokenizer stringTokenizer = new StringTokenizer(wizard.getAvailableLocales(), ",");
        int n = stringTokenizer.countTokens();
        Locale[] localeArray = new Locale[n];
        for (int i = 0; i < n; ++i) {
            localeArray[i] = this.parseLocaleString(stringTokenizer.nextToken());
        }
        return localeArray;
    }

    private Locale parseLocaleString(String string) {
        Locale locale;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        String string2 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            locale = new Locale(string2, string3);
        } else {
            locale = new Locale(string2);
        }
        return locale;
    }

    public boolean getEarlyExecution() {
        return true;
    }
}

