/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.install;

import com.installshield.wizard.WizardAction;
import com.sas.tools.install.MyPair;
import com.sas.tools.install.MyReader;
import com.sas.tools.install.MyWriter;
import java.io.IOException;

public class MyKey
extends WizardAction {
    MyKey myParent;
    String myName;
    MyKey[] myChildren;
    MyPair[] myPairs;
    int myNumChildren;
    int myMaxChildren;
    int myNumPairs;
    int myMaxPairs;
    static final int kInitialArraySize = 0;
    static final int kIncrementArraySize = 10;

    static String ITRfilename() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "C:\\Program Files\\SAS\\Install\\ITR.dat";
        }
        return "/opt/SAS/Install/ITR.dat";
    }

    static String DetermineRoot(String string) {
        String string2 = "HKEY_LOCAL_MACHINE";
        return string != null && string.length() > 1 ? string : string2;
    }

    MyKey(String string, MyKey myKey) {
        this.myName = string;
        this.myParent = myKey;
        this.myMaxChildren = 0;
        this.myNumChildren = 0;
        this.myChildren = new MyKey[this.myMaxChildren];
        this.myMaxPairs = 0;
        this.myNumPairs = 0;
        this.myPairs = new MyPair[this.myMaxPairs];
    }

    void ReadFromFile(String string) {
        try {
            MyReader myReader = new MyReader(string);
            this.ReadFromFile(myReader);
            myReader.Close();
        }
        catch (IOException iOException) {}
    }

    void WriteToFile(String string) {
        try {
            MyWriter myWriter = new MyWriter(string);
            this.WriteToFile(myWriter);
            myWriter.Close();
        }
        catch (IOException iOException) {}
    }

    boolean CreateKey(String string) {
        return this.FindOrCreateKey(string) != null;
    }

    boolean DeleteKey(String string) {
        MyKey myKey = this.FindKey(string);
        if (myKey == null) {
            return false;
        }
        return myKey.myParent.BasicDeleteKey(myKey);
    }

    boolean DeleteValue(String string, String string2) {
        MyKey myKey = this.FindKey(string);
        if (myKey == null) {
            return false;
        }
        return myKey.BasicDeletePair(string2);
    }

    String GetKeyValue(String string, String string2) {
        MyKey myKey = this.FindKey(string);
        if (myKey == null) {
            return null;
        }
        MyPair myPair = myKey.FindPair(string2);
        if (myPair == null) {
            return null;
        }
        return myPair.right;
    }

    boolean KeyExist(String string) {
        return this.FindKey(string) != null;
    }

    String QueryKey(String string, int n) {
        return null;
    }

    boolean SetKeyValue(String string, String string2, String string3) {
        MyKey myKey = this.FindOrCreateKey(string);
        MyPair myPair = myKey.FindOrCreatePair(string2);
        return myPair.SetValue(string3);
    }

    private void ReadFromFile(MyReader myReader) throws IOException {
        String string;
        String string2 = null;
        while ((string = myReader.GetLine()) != null) {
            int n = string.length();
            if (n < 1) continue;
            if (string.charAt(0) == '[') {
                if (n <= 2) continue;
                string2 = string.substring(1, n - 1);
                this.CreateKey(string2);
                continue;
            }
            if (string2 == null || string.charAt(0) != '\"' || string.charAt(n - 1) != '\"') continue;
            int n2 = string.indexOf(34, 1);
            int n3 = string.indexOf(34, n2 + 1);
            if (n2 <= 0 || n3 <= n2) continue;
            String string3 = string.substring(1, n2);
            String string4 = string.substring(n3 + 1, n - 1);
            this.SetKeyValue(string2, string3, string4);
        }
    }

    private void WriteToFile(MyWriter myWriter) throws IOException {
        int n = 0;
        while (n < this.myNumPairs) {
            myWriter.out("\"" + this.myPairs[n].left + "\"");
            myWriter.out("=");
            myWriter.out("\"" + this.myPairs[n].right + "\"");
            myWriter.outln();
            ++n;
        }
        myWriter.outln();
        int n2 = 0;
        while (n2 < this.myNumChildren) {
            myWriter.out("[");
            this.myChildren[n2].WriteKeyName(myWriter);
            myWriter.outln("]");
            this.myChildren[n2].WriteToFile(myWriter);
            ++n2;
        }
    }

    private boolean WriteKeyName(MyWriter myWriter) throws IOException {
        if (this.myParent != null && this.myParent.WriteKeyName(myWriter)) {
            myWriter.out("/");
        }
        if (this.myName == null) {
            return false;
        }
        myWriter.out(this.myName);
        return true;
    }

    private MyKey FindOrCreateKey(String string) {
        return this.BasicFindKey(string, true);
    }

    private MyKey FindKey(String string) {
        return this.BasicFindKey(string, false);
    }

    private MyPair FindOrCreatePair(String string) {
        return this.BasicFindPair(string, true);
    }

    private MyPair FindPair(String string) {
        return this.BasicFindPair(string, false);
    }

    private MyKey BasicFindKey(String string, boolean bl) {
        if (!bl && this.myNumChildren == 0) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(47);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        int n2 = 0;
        while (n2 < this.myNumChildren) {
            if (this.myChildren[n2].myName.equals(string2)) {
                if (string3 == null) {
                    return this.myChildren[n2];
                }
                return this.myChildren[n2].BasicFindKey(string3, bl);
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        return this.BasicAddKey(string2, string3);
    }

    private MyKey BasicAddKey(String string, String string2) {
        MyKey[] myKeyArray;
        if (this.myNumChildren >= this.myMaxChildren) {
            this.myMaxChildren += 10;
            myKeyArray = new MyKey[this.myMaxChildren];
            int n = 0;
            while (n < this.myNumChildren) {
                myKeyArray[n] = this.myChildren[n];
                ++n;
            }
            this.myChildren = myKeyArray;
        }
        myKeyArray = new MyKey(string, this);
        this.myChildren[this.myNumChildren++] = myKeyArray;
        if (string2 == null) {
            return myKeyArray;
        }
        return super.BasicFindKey(string2, true);
    }

    private boolean BasicDeleteKey(MyKey myKey) {
        int n = 0;
        while (n < this.myNumChildren) {
            if (this.myChildren[n] == myKey) {
                int n2 = n + 1;
                while (n2 < this.myNumChildren) {
                    this.myChildren[n2 - 1] = this.myChildren[n2];
                    ++n2;
                }
                --this.myNumChildren;
                return true;
            }
            ++n;
        }
        return false;
    }

    private MyPair BasicFindPair(String string, boolean bl) {
        int n = 0;
        while (n < this.myNumPairs) {
            if (this.myPairs[n].left.equals(string)) {
                return this.myPairs[n];
            }
            ++n;
        }
        if (!bl) {
            return null;
        }
        return this.BasicAddPair(string, "");
    }

    private MyPair BasicAddPair(String string, String string2) {
        MyPair myPair = new MyPair(string, string2);
        if (this.myNumPairs >= this.myMaxPairs) {
            this.myMaxPairs += 10;
            MyPair[] myPairArray = new MyPair[this.myMaxPairs];
            int n = 0;
            while (n < this.myNumPairs) {
                myPairArray[n] = this.myPairs[n];
                ++n;
            }
            this.myPairs = myPairArray;
        }
        this.myPairs[this.myNumPairs++] = myPair;
        return myPair;
    }

    private boolean BasicDeletePair(String string) {
        int n = 0;
        while (n < this.myNumPairs) {
            if (this.myPairs[n].left.equals(string)) {
                int n2 = n + 1;
                while (n2 < this.myNumPairs) {
                    this.myPairs[n2 - 1] = this.myPairs[n2];
                    ++n2;
                }
                --this.myNumPairs;
                return true;
            }
            ++n;
        }
        return false;
    }
}

