/*
 * Decompiled with CFR 0.152.
 */
package main;

import de.sciss.net.OSCMessage;
import java.net.URL;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import main.MusicMaker;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public class Main
extends Application
implements MusebotAssistant.Responder {
    static AudioContext ac;
    MusebotAssistant musebot;
    Envelope masterGainEnvelope;
    Gain masterGain;
    Text text;
    MusicMaker musicMaker;
    static boolean debugMode;

    public static void main(String[] args) {
        ac = new AudioContext(new AudioServerIO.Jack("ArtBlakeyBot"));
        ac.start();
        if (args.length > 0 && args[0].equals("debugMode")) {
            debugMode = true;
            System.out.println("Running in debug mode: listening on port 7474");
        }
        try {
            System.out.println("Waiting...");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Launching");
        Main.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        this.musebot = new MusebotAssistant(debugMode);
        this.masterGainEnvelope = new Envelope(ac, 1.0f);
        this.masterGain = new Gain(ac, 2, this.masterGainEnvelope);
        Main.ac.out.addInput(this.masterGain);
        this.musicMaker = new MusicMaker(this);
        this.musebot.respondWith(this);
        System.out.println(".....");
        GridPane root = (GridPane)FXMLLoader.load((URL)this.getClass().getResource("gui.fxml"));
        this.text = new Text("Starting");
        System.out.println("ArtBlakeyBot is running.");
        root.getChildren().add((Object)this.text);
        Scene scene = new Scene((Parent)root, 300.0, 250.0);
        stage.setTitle("ArtBlakeyBot!");
        stage.setScene(scene);
        stage.show();
        stage.centerOnScreen();
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                System.exit(0);
            }
        });
    }

    @Override
    public void incoming(OSCMessage msg) {
        this.musicMaker.incoming(msg);
    }

    @Override
    public void time(final float tempo, final int tickCount) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Main.this.text != null) {
                    Main.this.text.setText("Time: " + tickCount + " (Tempo=" + tempo + ")");
                }
            }
        });
        if (tickCount % 4 == 0) {
            this.musicMaker.sixteenthBeat(tempo, tickCount / 4);
        }
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(level, time);
    }

    @Override
    public void kill() {
        this.masterGainEnvelope.clear();
        this.masterGainEnvelope.addSegment(0.0f, 5000.0f, new Bead(){

            @Override
            public void messageReceived(Bead m) {
                System.exit(0);
            }
        });
        this.masterGainEnvelope.lock(true);
    }

    static {
        debugMode = false;
    }
}

