/*
 * Decompiled with CFR 0.152.
 */
package main;

import de.sciss.net.OSCMessage;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import main.Main;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Compressor;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Mult;
import net.beadsproject.beads.ugens.Reverb;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.WavePlayer;

public class MusicMaker {
    String[] sampleNames = new String[]{"hhc", "hho", "bd", "snare2", "halfhat", "snare3", "rim", "clap", "ride", "crash"};
    Main main;
    Map<Integer, Event> sequence;
    Random rng;
    Mult mult;
    Compressor cp;
    Reverb reverb;
    Gain multinput;
    List<Integer> densityHistory = new ArrayList<Integer>();
    List<Integer> syncoHistory = new ArrayList<Integer>();
    int currentDensityLevel;
    int previousDensityLevel = this.currentDensityLevel = 1;
    int futureDensityLevel = 0;
    int currentSyncoLevel;
    int previousSyncoLevel = this.currentSyncoLevel = 4;
    int futureSyncoLevel = 0;
    boolean fill = false;
    int[] transitionMap = new int[100];
    Map<String, Float> densityExpectations;
    Map<String, Integer> endVotes;

    public MusicMaker(Main main) {
        this.main = main;
        this.rng = new Random();
        this.rng.setSeed(2L);
        this.densityExpectations = new Hashtable<String, Float>();
        this.endVotes = new Hashtable<String, Integer>();
        this.buildNeighbourhoodMap();
        this.sequence = new Hashtable<Integer, Event>();
        this.generateNewSequenceMajor(this.currentDensityLevel, this.currentSyncoLevel);
        SampleManager.setVerbose(true);
        for (String sampleName : this.sampleNames) {
            SampleManager.sample(sampleName, "data/audio/drums3/" + sampleName + ".aif");
        }
        this.multinput = new Gain(Main.ac, 1, 1.0f);
        WavePlayer wp = new WavePlayer(Main.ac, 400.0f, Buffer.SQUARE);
        Gain g2 = new Gain(Main.ac, 1, 0.03f);
        g2.addInput(wp);
        this.mult = new Mult(Main.ac, this.multinput, (UGen)g2);
        this.cp = new Compressor(Main.ac);
        this.cp.setRatio(5.0f);
        this.cp.setAttack(0.0f);
        this.cp.setThreshold(0.4f);
        this.reverb = new Reverb(Main.ac, 2);
        this.reverb.setSize(0.8f);
        Gain rgain = new Gain(Main.ac, 2, 0.7f);
        rgain.addDependent(this.reverb);
        this.cp.addInput(rgain);
        this.cp.addInput(this.mult);
        Gain overallGain = new Gain(Main.ac, 2, 2.0f);
        overallGain.addInput(this.cp);
        main.masterGain.addInput(overallGain);
    }

    public void buildPermutationMap() {
        int i;
        LinkedList<Integer> numbers = new LinkedList<Integer>();
        for (i = 0; i < this.transitionMap.length; ++i) {
            numbers.add(i);
        }
        for (i = 0; i < this.transitionMap.length; ++i) {
            int nextIndex = this.rng.nextInt(numbers.size());
            this.transitionMap[i] = (Integer)numbers.remove(nextIndex);
        }
    }

    public void buildRandomMap() {
        for (int i = 0; i < this.transitionMap.length; ++i) {
            this.transitionMap[i] = this.rng.nextInt(this.transitionMap.length);
        }
    }

    public void buildNeighbourhoodMap() {
        this.densityHistory.clear();
        this.syncoHistory.clear();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                int destIndex;
                int index = this.xyToIndex(x, y);
                if (this.rng.nextFloat() < 0.1f) {
                    this.transitionMap[index] = this.rng.nextInt(100);
                    continue;
                }
                int destx = 0;
                int desty = 0;
                do {
                    int dest = this.rng.nextInt(8);
                    switch (dest) {
                        case 0: {
                            destx = x - 1;
                            desty = y - 1;
                            break;
                        }
                        case 1: {
                            destx = x - 1;
                            desty = y;
                            break;
                        }
                        case 2: {
                            destx = x - 1;
                            desty = y + 1;
                            break;
                        }
                        case 3: {
                            destx = x;
                            desty = y - 1;
                            break;
                        }
                        case 4: {
                            destx = x;
                            desty = y + 1;
                            break;
                        }
                        case 5: {
                            destx = x + 1;
                            desty = y - 1;
                            break;
                        }
                        case 6: {
                            destx = x + 1;
                            desty = y;
                            break;
                        }
                        case 7: {
                            destx = x + 1;
                            desty = y + 1;
                        }
                    }
                } while (destx < 0 || destx >= 10 || desty < 0 || desty >= 10);
                this.transitionMap[index] = destIndex = this.xyToIndex(destx, desty);
            }
        }
        for (int i = 0; i < 5; ++i) {
            this.transitionMap[this.rng.nextInt((int)100)] = this.rng.nextInt(100);
        }
        System.out.println("***Rebuilt transition map!***");
    }

    public int xyToIndex(int x, int y) {
        return x * 10 + y;
    }

    public int indexToX(int index) {
        return index / 10;
    }

    public int indexToY(int index) {
        return index % 10;
    }

    public void sixteenthBeat(float tempo, int i) {
        Hit h;
        Event e = this.sequence.get(i % 64);
        if (e != null) {
            this.play(tempo, e);
        }
        if (i % 64 == 28) {
            this.sendNewIntention();
        }
        if (i % 64 == 32) {
            this.calcNewDensityDictated();
        }
        if (i % 64 == 48) {
            if (this.futureChangeAmount() > 4.0f) {
                h = new Hit();
                h.sample = "ride";
                h.vel = 1.0f;
                this.playHit(h);
                this.fill = true;
                System.out.println("UHHH! FUNKY DRUM FILL!");
                this.generateNewSequenceMajor(this.rng.nextInt(3) + 7, this.currentSyncoLevel);
            }
            this.checkEnd();
        }
        if (i % 64 == 60) {
            this.previousDensityLevel = this.currentDensityLevel;
            this.currentDensityLevel = this.futureDensityLevel;
            this.previousSyncoLevel = this.currentSyncoLevel;
            this.currentSyncoLevel = this.futureSyncoLevel;
            if (!this.fill && this.lastChangeAmount() < 3.0f && this.rng.nextFloat() < 0.4f) {
                System.out.println("Current pattern too damn good! Keep it rolling.");
            } else {
                System.out.println("Time for change! Creating new pattern.");
                this.generateNewSequenceMajor(this.currentDensityLevel, this.currentSyncoLevel);
            }
        }
        if (i % 64 == 0) {
            if (this.fill) {
                h = new Hit();
                h.sample = "crash";
                h.vel = 1.0f;
                this.playHit(h);
            }
            this.fill = false;
        }
        if (i % 512 == 0) {
            this.buildNeighbourhoodMap();
        }
    }

    float distance(float x1, float x2, float y1, float y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    float lastChangeAmount() {
        return this.distance(this.previousSyncoLevel, this.currentSyncoLevel, this.previousDensityLevel, this.currentDensityLevel);
    }

    float futureChangeAmount() {
        return this.distance(this.currentSyncoLevel, this.futureSyncoLevel, this.currentDensityLevel, this.futureDensityLevel);
    }

    public void checkEnd() {
        int count = 0;
        for (int val : this.endVotes.values()) {
            count += val;
        }
        if (count >= 3) {
            System.out.println("!!!!!!ENDING!!!!!!!");
            this.main.kill();
        }
    }

    public void generateNewSequenceMajor(int densityLevel, int syncoLevel) {
        this.rng.setSeed(this.xyToIndex(densityLevel, syncoLevel) / 4);
        ArrayList<Event> coreEvents = new ArrayList<Event>();
        for (int i = 0; i < 8; ++i) {
            int numHitsOnThisEvent;
            Hit h;
            Event e = new Event();
            coreEvents.add(e);
            if (i == 0 && (float)densityLevel / 10.0f > 0.3f) {
                h = new Hit();
                h.sample = "bd";
                h.vel = (float)Math.pow(this.rng.nextFloat(), 1.0f - (float)densityLevel / 15.0f);
                e.hits.add(h);
            }
            if (i == 8 && (float)densityLevel / 10.0f > 0.5f) {
                h = new Hit();
                h.sample = this.rng.nextBoolean() ? "snare3" : "snare2";
                h.vel = this.rng.nextFloat();
                e.hits.add(h);
            }
            int n = numHitsOnThisEvent = this.rng.nextFloat() < (float)densityLevel / 10.0f ? this.rng.nextInt(densityLevel / 3 + 1) + 1 : 0;
            if (this.rng.nextFloat() < (float)densityLevel / 10.0f) {
                h = new Hit();
                h.sample = "hhc";
                h.vel = 0.1f;
                e.hits.add(h);
            }
            for (int j = 0; j < numHitsOnThisEvent; ++j) {
                h = new Hit();
                int randomSample = 0;
                randomSample = i == 0 ? (int)(this.rng.nextFloat() * this.rng.nextFloat() * (float)(this.sampleNames.length - 1) + 1.0f) : (int)(this.rng.nextFloat() * this.rng.nextFloat() * (float)this.sampleNames.length);
                h.sample = this.sampleNames[randomSample];
                float levelRange = i % 2 == 1 ? (float)syncoLevel / 10.0f : 1.0f - (float)syncoLevel / 10.0f;
                h.vel = this.rng.nextFloat() * levelRange * levelRange;
                e.hits.add(h);
            }
        }
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        ArrayList<Integer> starts = new ArrayList<Integer>();
        for (int i = 0; i < 24; ++i) {
            int select;
            int nextLen = 4;
            int start = 0;
            if (this.rng.nextFloat() < (float)syncoLevel) {
                select = this.rng.nextInt(3);
                switch (select) {
                    case 0: {
                        nextLen = 1;
                        break;
                    }
                    case 1: {
                        nextLen = 3;
                        break;
                    }
                    case 2: {
                        nextLen = 5;
                    }
                }
                if (this.rng.nextFloat() < 0.3f) {
                    start = 1 + this.rng.nextInt(4) * 2;
                }
            } else {
                select = this.rng.nextInt(3);
                switch (select) {
                    case 0: {
                        nextLen = 2;
                        break;
                    }
                    case 1: {
                        nextLen = 4;
                        break;
                    }
                    case 2: {
                        nextLen = 6;
                    }
                }
                if (this.rng.nextFloat() < 0.3f) {
                    start = this.rng.nextInt(4) * 2;
                }
            }
            if (this.rng.nextFloat() > (float)densityLevel / 10.0f) {
                nextLen *= 2;
            }
            lengths.add(nextLen);
            starts.add(start);
        }
        this.sequence.clear();
        int count = 0;
        for (int i = 0; i < lengths.size(); ++i) {
            int len = (Integer)lengths.get(i);
            int start = (Integer)starts.get(i);
            for (int j = 0; j < len; ++j) {
                Event e = (Event)coreEvents.get((j + start) % coreEvents.size());
                if (e != null) {
                    for (Hit hit : e.hits) {
                    }
                }
                this.sequence.put(count, e);
                ++count;
            }
        }
    }

    public void sendNewIntention() {
        int index = this.xyToIndex(this.currentDensityLevel, this.currentSyncoLevel);
        int newIndex = this.transitionMap[index];
        int newDensityInt = this.indexToX(newIndex);
        float newDensityFloat = (float)newDensityInt / 10.0f;
        System.out.println("Sending new density intention = " + newDensityFloat + " (index=" + index + ")");
        this.main.musebot.send("/broadcast/density_change", this.main.musebot.getClientID(), Float.valueOf(newDensityFloat));
        if (newDensityFloat < 0.1f) {
            this.main.musebot.send("/broadcast/end", this.main.musebot.getClientID(), Float.valueOf(1.0f));
        } else {
            this.main.musebot.send("/broadcast/end", this.main.musebot.getClientID(), Float.valueOf(0.0f));
        }
        this.main.musebot.send("/broadcast/density", this.main.musebot.getClientID(), Float.valueOf((float)this.currentDensityLevel / 10.0f));
    }

    public void play(float tempo, Event e) {
        for (Hit h : e.hits) {
            this.playHit(h);
        }
    }

    public void playHit(Hit h) {
        Sample s = SampleManager.sample(h.sample);
        if (s == null) {
            return;
        }
        SamplePlayer sp = new SamplePlayer(Main.ac, s);
        if (this.fill) {
            sp.getRateUGen().setValue(2.0f);
        } else {
            sp.getRateUGen().setValue(1.0f);
        }
        Gain g = new Gain(Main.ac, 1, this.scale(h.vel, 0.0f, 1.0f, 0.2f, 0.7f));
        g.addInput(sp);
        sp.setEndListener(new KillTrigger(g));
        this.cp.addInput(g);
        this.multinput.addInput(g);
        this.reverb.addInput(g);
    }

    float scale(float val, float inlow, float inhigh, float outlow, float outhigh) {
        return outlow + (outhigh - outlow) * (val - inlow) / (inhigh - inlow);
    }

    public void incoming(OSCMessage msg) {
        if (msg.getName().equals("/broadcast/density_change")) {
            String sender = (String)msg.getArg(0);
            float densityRequest = ((Float)msg.getArg(1)).floatValue();
            System.out.println("Received density change message from:    " + sender + "\t (" + densityRequest + ")");
            this.densityExpectations.put(sender, Float.valueOf(densityRequest));
        } else if (msg.getName().equals("/broadcast/end")) {
            float choice;
            String sender = (String)msg.getArg(0);
            try {
                choice = ((Float)msg.getArg(1)).floatValue();
            }
            catch (Exception e) {
                choice = ((Integer)msg.getArg(1)).intValue();
            }
            System.out.println("Received end request message from:       " + sender + "\t (" + choice + ")");
            this.endVotes.put(sender, (int)choice);
        }
    }

    public void calcNewDensityDictated() {
        this.futureSyncoLevel = this.indexToY(this.transitionMap[this.xyToIndex(this.currentDensityLevel, this.currentSyncoLevel)]);
        if (this.densityExpectations.size() > 0) {
            float actualDensity = 0.0f;
            int count = 0;
            for (float f : this.densityExpectations.values()) {
                actualDensity += f;
                ++count;
            }
            this.futureDensityLevel = (int)((actualDensity /= (float)count) * 10.0f);
        }
        if (this.rng.nextFloat() < 0.1f) {
            do {
                this.currentDensityLevel += this.rng.nextBoolean() ? 1 : -1;
            } while (this.currentDensityLevel < 0 || this.currentDensityLevel >= 10);
        }
        this.densityHistory.add(this.currentDensityLevel);
        System.out.println("Calculated new planned density level           =   " + this.futureDensityLevel);
        this.syncoHistory.add(this.currentSyncoLevel);
        System.out.println("Calculated new planned synco level             =   " + this.futureSyncoLevel);
        this.printPictureOfState();
    }

    void printPictureOfState() {
        int i;
        System.out.println();
        for (i = 0; i < 10; ++i) {
            int j;
            System.out.print(i + "|");
            for (j = 0; j < 10; ++j) {
                if (i == this.currentDensityLevel && j == this.currentSyncoLevel) {
                    System.out.print(" *");
                    continue;
                }
                boolean match = false;
                for (int k = 0; k < this.densityHistory.size(); ++k) {
                    if (i != this.densityHistory.get(k) || j != this.syncoHistory.get(k)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    System.out.print(" .");
                    continue;
                }
                System.out.print("  ");
            }
            System.out.print("   |   ");
            for (j = 0; j < 10; ++j) {
                int val = this.transitionMap[this.xyToIndex(i, j)];
                String valStr = val < 10 ? "0" + val + " " : val + " ";
                System.out.print(valStr);
            }
            System.out.println();
        }
        System.out.print("  ");
        for (i = 0; i < 10; ++i) {
            System.out.print(" " + i);
        }
        System.out.println();
        System.out.println();
    }

    public class Hit {
        String sample;
        float vel;
    }

    public class Event {
        ArrayList<Hit> hits = new ArrayList();
    }
}

