/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.TimeStamp;

public class FFT
extends FeatureExtractor<float[][], float[]> {
    protected float[] fftReal;
    protected float[] fftImag;
    private float[] dataCopy = null;

    public FFT() {
        this.features = new float[2][];
    }

    @Override
    public void process(TimeStamp timeStamp, TimeStamp timeStamp2, float[] fArray) {
        if (this.dataCopy == null || this.dataCopy.length != fArray.length) {
            this.dataCopy = new float[fArray.length];
        }
        System.arraycopy(fArray, 0, this.dataCopy, 0, fArray.length);
        FFT.fft(this.dataCopy, this.dataCopy.length, true);
        this.numFeatures = this.dataCopy.length;
        this.fftReal = FFT.calculateReal(this.dataCopy, this.dataCopy.length);
        this.fftImag = FFT.calculateImaginary(this.dataCopy, this.dataCopy.length);
        ((float[][])this.features)[0] = this.fftReal;
        ((float[][])this.features)[1] = this.fftImag;
        this.forward(timeStamp, timeStamp2);
    }

    public static float binFrequency(float f, int n, float f2) {
        return f2 * f / (float)n;
    }

    public static float binNumber(float f, int n, float f2) {
        return (float)n * f2 / f;
    }

    public static float nyquist(float f) {
        return f / 2.0f;
    }

    protected static float[] calculateReal(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        fArray2[0] = fArray[0];
        fArray2[fArray2.length / 2] = fArray[1];
        int n2 = 1;
        for (int i = fArray2.length - 1; n2 < i; ++n2, --i) {
            fArray2[i] = fArray2[n2] = fArray[2 * n2];
        }
        return fArray2;
    }

    protected static float[] calculateImaginary(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        int n2 = 1;
        for (int i = fArray2.length - 1; n2 < i; ++n2, --i) {
            fArray2[i] = fArray[2 * n2 + 1];
            fArray2[n2] = -fArray2[i];
        }
        return fArray2;
    }

    protected static void fft(float[] fArray, int n, boolean bl) {
        float f;
        float f2 = 0.5f;
        double d = Math.PI / (double)(n >> 1);
        if (bl) {
            f = -0.5f;
            FFT.four1(fArray, n >> 1, true);
        } else {
            f = 0.5f;
            d = -d;
        }
        double d2 = Math.sin(0.5 * d);
        double d3 = -2.0 * d2 * d2;
        double d4 = Math.sin(d);
        double d5 = 1.0 + d3;
        double d6 = d4;
        int n2 = n + 3;
        int n3 = n >> 2;
        for (int i = 2; i <= n3; ++i) {
            int n4 = i + i - 1;
            int n5 = 1 + n4;
            int n6 = n2 - n5;
            int n7 = 1 + n6;
            float f3 = f2 * (fArray[--n5] - fArray[--n7]);
            float f4 = -f * (fArray[n5] + fArray[n7]);
            float f5 = f2 * (fArray[--n4] + fArray[--n6]);
            float f6 = f * (fArray[n4] - fArray[n6]);
            fArray[n4] = (float)((double)f5 + d5 * (double)f4 - d6 * (double)f6);
            fArray[n5] = (float)((double)f3 + d5 * (double)f6 + d6 * (double)f4);
            fArray[n6] = (float)((double)f5 - d5 * (double)f4 + d6 * (double)f6);
            fArray[n7] = (float)((double)(-f3) + d5 * (double)f6 + d6 * (double)f4);
            d2 = d5;
            d5 = d2 * d3 - d6 * d4 + d5;
            d6 = d6 * d3 + d2 * d4 + d6;
        }
        if (bl) {
            float f7 = fArray[0];
            fArray[0] = fArray[0] + fArray[1];
            fArray[1] = f7 - fArray[1];
        } else {
            float f8 = fArray[0];
            fArray[0] = f2 * (f8 + fArray[1]);
            fArray[1] = f2 * (f8 - fArray[1]);
            FFT.four1(fArray, n >> 1, false);
        }
    }

    private static void four1(float[] fArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = n << 1;
        int n5 = 1;
        for (n3 = 1; n3 < n4; n3 += 2) {
            if (n5 > n3) {
                float f = fArray[n5 - 1];
                fArray[n5 - 1] = fArray[n3 - 1];
                fArray[n3 - 1] = f;
                f = fArray[n5];
                fArray[n5] = fArray[n3];
                fArray[n3] = f;
            }
            for (n2 = n4 >> 1; n2 >= 2 && n5 > n2; n5 -= n2, n2 >>= 1) {
            }
            n5 += n2;
        }
        int n6 = 2;
        while (n4 > n6) {
            int n7 = n6 << 1;
            double d = 6.28318530717959 / (double)n6;
            if (!bl) {
                d = -d;
            }
            double d2 = Math.sin(0.5 * d);
            double d3 = -2.0 * d2 * d2;
            double d4 = Math.sin(d);
            double d5 = 1.0;
            double d6 = 0.0;
            for (n3 = 1; n3 < n6; n3 += 2) {
                for (n5 = n3; n5 <= n4; n5 += n7) {
                    n2 = n5 + n6;
                    float f = (float)(d5 * (double)fArray[n2 - 1] - d6 * (double)fArray[n2]);
                    float f2 = (float)(d5 * (double)fArray[n2] + d6 * (double)fArray[n2 - 1]);
                    fArray[n2 - 1] = fArray[n5 - 1] - f;
                    fArray[n2] = fArray[n5] - f2;
                    int n8 = n5 - 1;
                    fArray[n8] = fArray[n8] + f;
                    int n9 = n5;
                    fArray[n9] = fArray[n9] + f2;
                }
                d2 = d5;
                d5 = d2 * d3 - d6 * d4 + d5;
                d6 = d6 * d3 + d2 * d4 + d6;
            }
            n6 = n7;
        }
    }
}

