/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import java.util.ArrayList;
import net.beadsproject.beads.core.Bead;

public class BeadArray
extends Bead {
    private ArrayList<Bead> beads = new ArrayList();
    private boolean forwardKillCommand = false;
    private boolean forwardPauseCommand = false;

    public void add(Bead bead) {
        this.beads.add(bead);
    }

    public void remove(Bead bead) {
        this.beads.remove(bead);
    }

    public Bead get(int n) {
        return this.beads.get(n);
    }

    public void clear() {
        this.beads.clear();
    }

    public int size() {
        return this.beads.size();
    }

    public ArrayList<Bead> getBeads() {
        return this.beads;
    }

    @Override
    public void messageReceived(Bead bead) {
        BeadArray beadArray = this.clone();
        for (int i = 0; i < beadArray.size(); ++i) {
            Bead bead2 = beadArray.get(i);
            if (bead2.isDeleted()) {
                this.remove(bead2);
                continue;
            }
            bead2.message(bead);
        }
    }

    public BeadArray clone() {
        BeadArray beadArray = new BeadArray();
        for (int i = 0; i < this.beads.size(); ++i) {
            beadArray.add(this.beads.get(i));
        }
        return beadArray;
    }

    public boolean doesForwardKillCommand() {
        return this.forwardKillCommand;
    }

    public void setForwardKillCommand(boolean bl) {
        this.forwardKillCommand = bl;
    }

    public boolean doesForwardPauseCommand() {
        return this.forwardPauseCommand;
    }

    public void setForwardPauseCommand(boolean bl) {
        this.forwardPauseCommand = bl;
    }

    @Override
    public void kill() {
        super.kill();
        if (this.forwardKillCommand) {
            BeadArray beadArray = this.clone();
            for (Bead bead : beadArray.beads) {
                if (bead.isDeleted()) {
                    this.remove(bead);
                    continue;
                }
                bead.kill();
            }
        }
    }

    @Override
    public void pause(boolean bl) {
        super.pause(bl);
        if (this.forwardPauseCommand) {
            BeadArray beadArray = this.clone();
            for (Bead bead : beadArray.beads) {
                if (bead.isDeleted()) {
                    this.remove(bead);
                    continue;
                }
                bead.pause(bl);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.forwardPauseCommand) {
            BeadArray beadArray = this.clone();
            for (Bead bead : beadArray.beads) {
                if (bead.isDeleted()) {
                    this.remove(bead);
                    continue;
                }
                bead.start();
            }
        }
    }
}

