/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

import java.io.Serializable;
import java.util.Hashtable;
import net.beadsproject.beads.data.buffers.NoiseBuffer;
import net.beadsproject.beads.data.buffers.SawBuffer;
import net.beadsproject.beads.data.buffers.SineBuffer;
import net.beadsproject.beads.data.buffers.SquareBuffer;
import net.beadsproject.beads.data.buffers.TriangleBuffer;

public class Buffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Hashtable<String, Buffer> staticBufs = new Hashtable();
    public static final Buffer SINE = new SineBuffer().getDefault();
    public static final Buffer SAW = new SawBuffer().getDefault();
    public static final Buffer SQUARE = new SquareBuffer().getDefault();
    public static final Buffer TRIANGLE = new TriangleBuffer().getDefault();
    public static final Buffer NOISE = new NoiseBuffer().getDefault();
    public final float[] buf;

    public Buffer(int n) {
        this.buf = new float[n];
    }

    public float getValueFraction(float f) {
        float f2 = f * (float)this.buf.length;
        int n = (int)f2;
        float f3 = f2 - (float)n;
        int n2 = (n + 1) % this.buf.length;
        return (1.0f - f3) * this.getValueIndex(n) + f3 * this.getValueIndex(n2);
    }

    public float getValueFractionNoInterp(float f) {
        return this.getValueIndex((int)(f * (float)this.buf.length));
    }

    public float getValueIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.buf.length) {
            n = this.buf.length - 1;
        }
        return this.buf[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.buf.length; ++i) {
            stringBuffer.append(this.buf[i] + " ");
        }
        return stringBuffer.toString();
    }
}

