/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

import java.io.IOException;
import java.util.Arrays;
import net.beadsproject.beads.data.SampleAudioFormat;
import net.beadsproject.beads.data.audiofile.AudioFileReader;
import net.beadsproject.beads.data.audiofile.AudioFileType;
import net.beadsproject.beads.data.audiofile.AudioFileWriter;

public class Sample {
    private float sampleRate;
    private int nChannels;
    private long nFrames;
    private String simpleName;
    private String filename = null;
    private float[][] theSampleData;
    private float[] current;
    private float[] next;
    private Class<? extends AudioFileReader> audioFileReaderClass = null;
    private Class<? extends AudioFileWriter> audioFileWriterClass = null;
    private static Class<? extends AudioFileReader> defaultAudioFileReaderClass;
    private static Class<? extends AudioFileWriter> defaultAudioFileWriterClass;

    public Sample(double d) {
        this(d, 2, 44100.0f);
    }

    public Sample(double d, int n) {
        this(d, n, 44100.0f);
    }

    public Sample(double d, int n, float f) {
        this.nChannels = n;
        this.sampleRate = f;
        this.current = new float[n];
        this.next = new float[n];
        this.nFrames = (long)this.msToSamples(d);
        this.theSampleData = new float[n][(int)this.nFrames];
        d = 1000.0f * (float)this.nFrames / this.sampleRate;
    }

    public Sample(String string) throws IOException {
        this.loadAudioFile(string);
        this.filename = string;
    }

    public Class<? extends AudioFileReader> getAudioFileReaderClass() {
        return this.audioFileReaderClass;
    }

    public Class<? extends AudioFileWriter> getAudioFileWriterClass() {
        return this.audioFileWriterClass;
    }

    public void setAudioFileReaderClass(Class<? extends AudioFileReader> clazz) {
        this.audioFileReaderClass = clazz;
    }

    public void setAudioFileWriterClass(Class<? extends AudioFileWriter> clazz) {
        this.audioFileWriterClass = clazz;
    }

    public void getFrame(int n, float[] fArray) {
        if (n < 0 || (long)n >= this.nFrames) {
            return;
        }
        for (int i = 0; i < this.nChannels; ++i) {
            fArray[i] = this.theSampleData[i][n];
        }
    }

    public void getFrameNoInterp(double d, float[] fArray) {
        double d2 = this.msToSamples(d);
        int n = (int)Math.floor(d2);
        this.getFrame(n, fArray);
    }

    public void getFrameLinear(double d, float[] fArray) {
        double d2 = this.msToSamples(d);
        int n = (int)Math.floor(d2);
        if (n > 0 && (long)n < this.nFrames) {
            double d3 = d2 - (double)n;
            if ((long)n == this.nFrames - 1L) {
                this.getFrame(n, fArray);
            } else {
                this.getFrame(n, this.current);
                this.getFrame(n + 1, this.next);
                for (int i = 0; i < this.nChannels; ++i) {
                    fArray[i] = (float)((1.0 - d3) * (double)this.current[i] + d3 * (double)this.next[i]);
                }
            }
        } else {
            for (int i = 0; i < this.nChannels; ++i) {
                fArray[i] = 0.0f;
            }
        }
    }

    public void getFrameCubic(double d, float[] fArray) {
        double d2 = this.msToSamples(d);
        for (int i = 0; i < this.nChannels; ++i) {
            int n = (int)Math.floor(d2);
            float f = (float)(d2 - (double)n);
            if (n >= 0 && (long)n < this.nFrames - 1L) {
                float f2;
                float f3;
                float f4;
                if (--n < 0) {
                    this.getFrame(0, this.current);
                    f4 = this.current[i];
                    n = 0;
                } else {
                    this.getFrame(n++, this.current);
                    f4 = this.current[i];
                }
                this.getFrame(n++, this.current);
                float f5 = this.current[i];
                if ((long)n >= this.nFrames) {
                    this.getFrame((int)this.nFrames - 1, this.current);
                    f3 = this.current[i];
                } else {
                    this.getFrame(n++, this.current);
                    f3 = this.current[i];
                }
                if ((long)n >= this.nFrames) {
                    this.getFrame((int)this.nFrames - 1, this.current);
                    f2 = this.current[i];
                } else {
                    this.getFrame(n++, this.current);
                    f2 = this.current[i];
                }
                float f6 = f * f;
                float f7 = f2 - f3 - f4 + f5;
                float f8 = f4 - f5 - f7;
                float f9 = f3 - f4;
                float f10 = f5;
                fArray[i] = f7 * f * f6 + f8 * f6 + f9 * f + f10;
                continue;
            }
            fArray[i] = 0.0f;
        }
    }

    public void getFrames(int n, float[][] fArray) {
        if ((long)n >= this.nFrames) {
            return;
        }
        int n2 = Math.min(fArray[0].length, (int)(this.nFrames - (long)n));
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(this.theSampleData[i], n, fArray[i], 0, n2);
        }
    }

    public void clear() {
        for (int i = 0; i < this.nChannels; ++i) {
            Arrays.fill(this.theSampleData[i], 0.0f);
        }
    }

    public void putFrame(int n, float[] fArray) {
        for (int i = 0; i < this.nChannels; ++i) {
            this.theSampleData[i][n] = fArray[i];
        }
    }

    public void putFrames(int n, float[][] fArray) {
        int n2 = Math.min(fArray[0].length, (int)(this.nFrames - (long)n));
        if (n < 0) {
            return;
        }
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(fArray[i], 0, this.theSampleData[i], n, n2);
        }
    }

    public void putFrames(int n, float[][] fArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        n3 = Math.min(n3, (int)(this.nFrames - (long)n));
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(fArray[i], n2, this.theSampleData[i], n, n3);
        }
    }

    public void write(String string) throws IOException {
        this.write(string, AudioFileType.WAV);
    }

    public void write(String string, AudioFileType audioFileType) throws IOException {
        this.write(string, audioFileType, new SampleAudioFormat(this.sampleRate, 16, this.nChannels));
    }

    public void write(String string, AudioFileType audioFileType, SampleAudioFormat sampleAudioFormat) throws IOException {
        Class<AudioFileWriter> clazz;
        Class<? extends AudioFileWriter> clazz2 = clazz = this.audioFileWriterClass == null ? defaultAudioFileWriterClass : this.audioFileWriterClass;
        if (audioFileType == AudioFileType.WAV) {
            try {
                clazz = Class.forName("net.beadsproject.beads.data.audiofile.WavFileReaderWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            throw new IOException("Sample: No AudioFile Class has been set and the default JavaSoundAudioFile Class cannot be found. Aborting write(). You may need to link to beads-io.jar.");
        }
        try {
            AudioFileWriter audioFileWriter = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            audioFileWriter.writeAudioFile(this.theSampleData, string, audioFileType, sampleAudioFormat);
        }
        catch (Exception exception) {
            throw new IOException("Sample: Unable to create or use the AudioFileWriter class.", exception);
        }
    }

    public void resize(long l) {
        int n = (int)Math.min(l, this.nFrames);
        float[][] fArray = this.theSampleData;
        this.theSampleData = new float[this.nChannels][(int)l];
        for (int i = 0; i < this.nChannels; ++i) {
            System.arraycopy(fArray[i], 0, this.theSampleData[i], 0, n);
        }
        this.nFrames = l;
    }

    public void resizeWithZeros(long l) {
        this.nFrames = l;
    }

    public double msToSamples(double d) {
        return d * (double)this.sampleRate / 1000.0;
    }

    public double samplesToMs(double d) {
        return d / (double)this.sampleRate * 1000.0;
    }

    public String toString() {
        return this.getFileName();
    }

    public String getFileName() {
        if (this.filename == null) {
            return null;
        }
        return this.filename;
    }

    public String getSimpleName() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        String string = this.getFileName();
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray[stringArray.length - 1];
    }

    public void setSimpleName(String string) {
        this.simpleName = string;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getNumChannels() {
        return this.nChannels;
    }

    public long getNumFrames() {
        return this.nFrames;
    }

    public double getLength() {
        return 1000.0f * (float)this.nFrames / this.sampleRate;
    }

    private void loadAudioFile(String string) throws IOException {
        AudioFileReader audioFileReader;
        Class<AudioFileReader> clazz;
        Class<? extends AudioFileReader> clazz2 = clazz = this.audioFileReaderClass == null ? defaultAudioFileReaderClass : this.audioFileReaderClass;
        if (string.endsWith(".wav") || string.endsWith(".WAV")) {
            try {
                clazz = Class.forName("net.beadsproject.beads.data.audiofile.WavFileReaderWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            audioFileReader = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IOException("Sample: No AudioFileReader Class has been set and the default JavaSoundAudioFile Class cannot be found. Aborting write(). You may need to link to beads-io.jar.");
        }
        try {
            this.theSampleData = audioFileReader.readAudioFile(string);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        this.sampleRate = audioFileReader.getSampleAudioFormat().sampleRate;
        this.nChannels = this.theSampleData.length;
        this.nFrames = this.theSampleData[0].length;
        this.current = new float[this.nChannels];
        this.next = new float[this.nChannels];
    }

    static {
        try {
            defaultAudioFileReaderClass = Class.forName("net.beadsproject.beads.data.audiofile.JavaSoundAudioFile");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                defaultAudioFileReaderClass = Class.forName("net.beadsproject.beads.data.audiofile.WavFileReaderWriter");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                defaultAudioFileReaderClass = null;
            }
        }
        try {
            defaultAudioFileWriterClass = Class.forName("net.beadsproject.beads.data.audiofile.JavaSoundAudioFile");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                defaultAudioFileWriterClass = Class.forName("net.beadsproject.beads.data.audiofile.WavFileReaderWriter");
            }
            catch (ClassNotFoundException classNotFoundException3) {
                defaultAudioFileReaderClass = null;
            }
        }
    }
}

