/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.BeadArray;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.events.IntegerBead;
import net.beadsproject.beads.ugens.Clicker;
import net.beadsproject.beads.ugens.Static;

public class Clock
extends UGen
implements IntegerBead {
    private UGen intervalEnvelope;
    private double point;
    private long count;
    private int ticksPerBeat;
    private BeadArray listeners;
    private boolean click;
    private float clickStrength;
    private double[] subticks;

    public Clock(AudioContext audioContext) {
        this(audioContext, 1000.0f);
    }

    public Clock(AudioContext audioContext, float f) {
        this(audioContext, new Static(audioContext, f));
        this.ticksPerBeat = 16;
    }

    public Clock(AudioContext audioContext, UGen uGen) {
        super(audioContext, 0, 0);
        this.intervalEnvelope = uGen;
        this.listeners = new BeadArray();
        this.reset();
        this.ticksPerBeat = 16;
        this.clickStrength = 0.1f;
        this.subticks = new double[audioContext.getBufferSize()];
    }

    public boolean isClicking() {
        return this.click;
    }

    public void setClick(boolean bl) {
        this.click = bl;
    }

    public void addMessageListener(Bead bead) {
        this.listeners.add(bead);
    }

    public void removeMessageListener(Bead bead) {
        this.listeners.remove(bead);
    }

    public void reset() {
        this.point = 0.0;
        this.count = -1L;
    }

    public long getCount() {
        return (int)Math.floor(this.point);
    }

    public void setIntervalEnvelope(UGen uGen) {
        this.intervalEnvelope = uGen;
    }

    public UGen getIntervalEnvelope() {
        return this.intervalEnvelope;
    }

    public UGen getIntervalUGen() {
        return this.intervalEnvelope;
    }

    public float getTempo() {
        return 60000.0f / Math.abs(this.intervalEnvelope.getValue());
    }

    @Override
    public void calculateBuffer() {
        this.intervalEnvelope.update();
        for (int i = 0; i < this.bufferSize; ++i) {
            boolean bl;
            this.subticks[i] = this.point;
            double d = this.intervalEnvelope.getValueDouble(0, i);
            double d2 = Math.max(1.0, Math.abs(d) / (double)this.ticksPerBeat);
            boolean bl2 = bl = d < 0.0;
            if (bl) {
                d2 *= -1.0;
            }
            this.point += 1.0 / this.context.msToSamples(d2);
            while (!bl && this.point >= (double)(this.count + 1L)) {
                this.tick();
                this.count = (long)((double)this.count + Math.signum(d));
            }
            while (bl && this.point <= (double)this.count) {
                this.tick();
                this.count = (long)((double)this.count + Math.signum(d));
            }
        }
    }

    private void tick() {
        if (this.click && this.isBeat()) {
            this.context.out.addInput(new Clicker(this.context, this.clickStrength));
        }
        this.listeners.message(this);
    }

    @Override
    public int getInt() {
        return (int)this.getCount();
    }

    public int getTicksPerBeat() {
        return this.ticksPerBeat;
    }

    public void setTicksPerBeat(int n) {
        this.ticksPerBeat = Math.max(1, n);
    }

    public boolean isBeat() {
        return this.getCount() % (long)this.ticksPerBeat == 0L;
    }

    public boolean isBeat(int n) {
        return this.isBeat() && this.getBeatCount() % n == 0;
    }

    public int getBeatCount() {
        return (int)(this.getCount() / (long)this.ticksPerBeat);
    }

    public double getSubTickAtIndex(int n) {
        return this.subticks[n];
    }

    public double getSubTickNow() {
        return this.point;
    }

    public void clearMessageListeners() {
        this.listeners.clear();
    }
}

