/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.Arrays;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.ugens.IIRFilter;
import net.beadsproject.beads.ugens.Static;

public class CombFilter
extends IIRFilter {
    private float a = 1.0f;
    private float g = 0.2f;
    private float h = 0.2f;
    private int maxDelay = 1;
    private int delay = 1;
    private int ind = 0;
    private UGen aUGen;
    private UGen gUGen;
    private UGen hUGen;
    private UGen delayUGen;
    private boolean isAStatic;
    private boolean isGStatic;
    private boolean isHStatic;
    private boolean isDelayStatic;
    private boolean areAllStatic;
    private float[] xn;
    private float[] yn;
    private int bufLen = 1;

    public CombFilter(AudioContext audioContext, int n) {
        super(audioContext, 1, 1);
        this.maxDelay = Math.max(n, 1);
        this.bufLen = this.maxDelay + 1;
        this.yn = new float[this.bufLen];
        this.xn = new float[this.bufLen];
        this.setA(this.a).setG(this.g).setH(this.h).setDelay(1);
    }

    private void checkStaticStatus() {
        this.areAllStatic = this.isAStatic && this.isGStatic && this.isGStatic && this.isDelayStatic;
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufIn[0];
        float[] fArray2 = this.bufOut[0];
        if (this.areAllStatic) {
            for (int i = 0; i < this.bufferSize; ++i) {
                int n = (this.ind + this.bufLen - this.delay) % this.bufLen;
                this.xn[this.ind] = fArray[i];
                fArray2[i] = this.yn[this.ind] = this.a * this.xn[this.ind] + this.g * this.xn[n] - this.h * this.yn[n];
                this.ind = (this.ind + 1) % this.bufLen;
            }
        } else {
            this.aUGen.update();
            this.gUGen.update();
            this.hUGen.update();
            this.delayUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                this.a = this.aUGen.getValue(0, i);
                this.g = this.gUGen.getValue(0, i);
                this.h = this.hUGen.getValue(0, i);
                this.delay = (int)this.delayUGen.getValue(0, i);
                if (this.delay < 1) {
                    this.delay = 1;
                } else if (this.delay >= this.maxDelay) {
                    this.delay = this.maxDelay;
                }
                int n = (this.ind + this.bufLen - this.delay) % this.bufLen;
                this.xn[this.ind] = fArray[i];
                fArray2[i] = this.yn[this.ind] = this.a * this.xn[this.ind] + this.g * this.xn[n] - this.h * this.yn[n];
                this.ind = (this.ind + 1) % this.bufLen;
            }
        }
    }

    public void reset() {
        Arrays.fill(this.yn, 0.0f);
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public int getDelay() {
        return this.delay;
    }

    public CombFilter setDelay(int n) {
        this.delay = n < 1 ? 1 : (n >= this.maxDelay ? this.maxDelay : n);
        if (this.isDelayStatic) {
            this.delayUGen.setValue(n);
        } else {
            this.delayUGen = new Static(this.context, (float)n);
            this.isDelayStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setDelay(UGen uGen) {
        if (uGen == null) {
            this.setDelay(this.delay);
        } else {
            this.delayUGen = uGen;
            uGen.update();
            this.delay = (int)uGen.getValue();
            this.isDelayStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getDelayUGen() {
        if (this.isDelayStatic) {
            return null;
        }
        return this.delayUGen;
    }

    public float getG() {
        return this.g;
    }

    public CombFilter setG(float f) {
        this.g = f;
        if (this.isGStatic) {
            this.gUGen.setValue(f);
        } else {
            this.gUGen = new Static(this.context, f);
            this.isGStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setG(UGen uGen) {
        if (uGen == null) {
            this.setG(this.g);
        } else {
            this.gUGen = uGen;
            uGen.update();
            this.g = uGen.getValue();
            this.isGStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getGUGen() {
        if (this.isGStatic) {
            return null;
        }
        return this.gUGen;
    }

    public float getH() {
        return this.h;
    }

    public CombFilter setH(float f) {
        this.h = f;
        if (this.isHStatic) {
            this.hUGen.setValue(f);
        } else {
            this.hUGen = new Static(this.context, f);
            this.isHStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setH(UGen uGen) {
        if (uGen == null) {
            this.setH(this.h);
        } else {
            this.aUGen = uGen;
            uGen.update();
            this.h = uGen.getValue();
            this.isHStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getHUGen() {
        if (this.isHStatic) {
            return null;
        }
        return this.hUGen;
    }

    public float getA() {
        return this.a;
    }

    public CombFilter setA(float f) {
        this.a = f;
        if (this.isAStatic) {
            this.aUGen.setValue(f);
        } else {
            this.aUGen = new Static(this.context, f);
            this.isAStatic = true;
            this.checkStaticStatus();
        }
        return this;
    }

    public CombFilter setA(UGen uGen) {
        if (uGen == null) {
            this.setA(this.a);
        } else {
            this.aUGen = uGen;
            uGen.update();
            this.a = uGen.getValue();
            this.isAStatic = false;
            this.areAllStatic = false;
        }
        return this;
    }

    public UGen getAUGen() {
        if (this.isAStatic) {
            return null;
        }
        return this.aUGen;
    }

    public CombFilter setParams(int n, float f, float f2, float f3) {
        this.setA(f);
        this.setG(f2);
        this.setH(f3);
        this.setDelay(n);
        return this;
    }

    public CombFilter setParams(UGen uGen, UGen uGen2, UGen uGen3, UGen uGen4) {
        this.setDelay(uGen);
        this.setA(uGen2);
        this.setG(uGen3);
        this.setH(uGen4);
        return this;
    }

    public CombFilter setParams(DataBead dataBead) {
        if (dataBead != null) {
            Object object = dataBead.get("a");
            if (object != null) {
                if (object instanceof UGen) {
                    this.setA((UGen)object);
                } else {
                    this.setA(dataBead.getFloat("a", this.a));
                }
            }
            if ((object = dataBead.get("g")) != null) {
                if (object instanceof UGen) {
                    this.setG((UGen)object);
                } else {
                    this.setG(dataBead.getFloat("g", this.g));
                }
            }
            if ((object = dataBead.get("h")) != null) {
                if (object instanceof UGen) {
                    this.setH((UGen)object);
                } else {
                    this.setH(dataBead.getFloat("h", this.h));
                }
            }
            if ((object = dataBead.get("delay")) != null) {
                if (object instanceof UGen) {
                    this.setDelay((UGen)object);
                } else {
                    this.setDelay((int)dataBead.getFloat("delay", this.delay));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.setParams((DataBead)bead);
        }
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isAStatic) {
            dataBead.put("a", (Object)Float.valueOf(this.a));
        } else {
            dataBead.put("a", (Object)this.aUGen);
        }
        if (this.isGStatic) {
            dataBead.put("g", (Object)Float.valueOf(this.g));
        } else {
            dataBead.put("g", (Object)this.gUGen);
        }
        if (this.isHStatic) {
            dataBead.put("h", (Object)Float.valueOf(this.h));
        } else {
            dataBead.put("h", (Object)this.hUGen);
        }
        if (this.isDelayStatic) {
            dataBead.put("delay", (Object)this.delay);
        } else {
            dataBead.put("delay", (Object)this.delayUGen);
        }
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("a", (Object)Float.valueOf(this.a));
        dataBead.put("g", (Object)Float.valueOf(this.g));
        dataBead.put("h", (Object)Float.valueOf(this.h));
        dataBead.put("delay", (Object)this.delay);
        return dataBead;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float f) {
        float[] fArray = new float[this.delay + 1];
        float[] fArray2 = new float[this.delay + 1];
        fArray[0] = this.a;
        fArray[this.delay] = this.g;
        fArray2[0] = 1.0f;
        fArray2[this.delay] = this.h;
        return CombFilter.calculateFilterResponse(fArray, fArray2, f, this.context.getSampleRate());
    }
}

