/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.ugens.Static;

public class CrossFade
extends UGen {
    private UGen incoming;
    private UGen outgoing;
    private double crossfadeTimeSamps;
    private long currentTimeSamps;
    private float incomingLevel;
    private float outgoingLevel;
    private boolean pauseAfterComplete;

    public CrossFade(AudioContext audioContext, int n) {
        super(audioContext, n);
        this.incoming = new Static(audioContext, 0.0f);
        this.pauseAfterComplete = false;
    }

    public CrossFade(AudioContext audioContext, UGen uGen) {
        super(audioContext, uGen.getOuts());
        this.incoming = uGen;
        this.pauseAfterComplete = false;
    }

    public void fadeTo(UGen uGen, float f) {
        if (this.incoming != uGen) {
            this.outgoing = this.incoming;
            this.incoming = uGen;
            if (this.incoming == null) {
                this.incoming = new Static(this.context, 0.0f);
            }
            this.crossfadeTimeSamps = this.context.msToSamples(f);
            this.currentTimeSamps = 0L;
        }
    }

    public boolean doesPauseAfterComplete() {
        return this.pauseAfterComplete;
    }

    public void setPauseAfterComplete(boolean bl) {
        this.pauseAfterComplete = bl;
    }

    @Override
    public void calculateBuffer() {
        this.incoming.update();
        if (this.outgoing != null) {
            this.outgoing.update();
        }
        for (int i = 0; i < this.bufferSize; ++i) {
            int n;
            if ((double)this.currentTimeSamps >= this.crossfadeTimeSamps) {
                for (n = 0; n < this.outs; ++n) {
                    this.bufOut[n][i] = this.incoming.getValue(n, i);
                }
                continue;
            }
            this.incomingLevel = (float)((double)this.currentTimeSamps / this.crossfadeTimeSamps);
            this.outgoingLevel = 1.0f - this.incomingLevel;
            for (n = 0; n < this.outs; ++n) {
                this.bufOut[n][i] = this.incomingLevel * this.incoming.getValue(n, i) + this.outgoingLevel * this.outgoing.getValue(n, i);
            }
            ++this.currentTimeSamps;
        }
        if ((double)this.currentTimeSamps >= this.crossfadeTimeSamps && this.pauseAfterComplete && this.outgoing != null) {
            this.outgoing.pause(true);
            this.outgoing = null;
        }
    }
}

