/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class CrossoverFilter
extends UGen
implements DataBeadReceiver {
    private float a0;
    private float a1;
    private float a2;
    private float lb0;
    private float lb1;
    private float k;
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    private float sr = 41000.0f;
    private float freq = 120.0f;
    private float pi_sr;
    private UGen freqUGen;
    private float x1 = 0.0f;
    private float x2 = 0.0f;
    private float ly0 = 0.0f;
    private float ly1 = 0.0f;
    private float ly2 = 0.0f;
    private float lz1 = 0.0f;
    private float lz2 = 0.0f;
    private float hy0 = 0.0f;
    private float hy1 = 0.0f;
    private float hy2 = 0.0f;
    private float hz1 = 0.0f;
    private float hz2 = 0.0f;
    private float[][] xms;
    private float[][] lyms;
    private float[][] lzms;
    private float[][] hyms;
    private float[][] hzms;
    private int channels;

    public CrossoverFilter(AudioContext audioContext) {
        this(audioContext, 1, 800.0f);
    }

    public CrossoverFilter(AudioContext audioContext, int n) {
        this(audioContext, n, 800.0f);
    }

    public CrossoverFilter(AudioContext audioContext, int n, float f) {
        super(audioContext, n, n * 2);
        this.channels = n;
        if (n > 1) {
            this.xms = new float[n][3];
            this.lyms = new float[n][3];
            this.lzms = new float[n][3];
            this.hyms = new float[n][3];
            this.hzms = new float[n][3];
        }
        this.sr = audioContext.getSampleRate();
        this.pi_sr = (float)(Math.PI / (double)this.sr);
        this.setFrequency(f);
    }

    @Override
    public void calculateBuffer() {
        if (this.freqUGen != null) {
            this.freqUGen.update();
            this.freq = this.freqUGen.getValue();
            this.calcVals();
        }
        if (this.channels > 1) {
            for (int i = 0; i < this.channels; ++i) {
                float[] fArray = this.bufIn[i];
                float[] fArray2 = this.bufOut[i * 2];
                float[] fArray3 = this.bufOut[i * 2 + 1];
                float[] fArray4 = this.lyms[i];
                float[] fArray5 = this.lzms[i];
                float[] fArray6 = this.hyms[i];
                float[] fArray7 = this.hzms[i];
                float[] fArray8 = this.xms[i];
                for (int j = 0; j < this.bufferSize; ++j) {
                    fArray4[0] = (this.lb0 * (fArray[j] + fArray8[2]) + this.lb1 * fArray8[1] - this.a1 * fArray4[1] - this.a2 * fArray4[2]) / this.a0;
                    fArray2[j] = (this.lb0 * (fArray4[0] + fArray4[2]) + this.lb1 * fArray4[1] - this.a1 * fArray5[1] - this.a2 * fArray5[2]) / this.a0;
                    fArray6[0] = (fArray[j] - 2.0f * fArray8[1] + fArray8[2] - this.a1 * fArray6[1] - this.a2 * fArray6[2]) / this.a0;
                    fArray3[j] = (fArray6[0] - 2.0f * fArray6[1] + fArray6[2] - this.a1 * fArray7[1] - this.a2 * fArray7[2]) / this.a0;
                    fArray8[2] = fArray8[1];
                    fArray8[1] = fArray[j];
                    fArray4[2] = fArray4[1];
                    fArray4[1] = fArray4[0];
                    fArray5[2] = fArray5[1];
                    fArray5[1] = fArray2[j];
                    fArray6[2] = fArray6[1];
                    fArray6[1] = fArray6[0];
                    fArray7[2] = fArray7[1];
                    fArray7[1] = fArray3[j];
                }
            }
        } else {
            float[] fArray = this.bufIn[0];
            float[] fArray9 = this.bufOut[0];
            float[] fArray10 = this.bufOut[1];
            for (int i = 0; i < this.bufferSize; ++i) {
                this.ly0 = (this.lb0 * (fArray[i] + this.x2) + this.lb1 * this.x1 - this.a1 * this.ly1 - this.a2 * this.ly2) / this.a0;
                fArray9[i] = (this.lb0 * (this.ly0 + this.ly2) + this.lb1 * this.ly1 - this.a1 * this.lz1 - this.a2 * this.lz2) / this.a0;
                this.hy0 = (fArray[i] - 2.0f * this.x1 + this.x2 - this.a1 * this.hy1 - this.a2 * this.hy2) / this.a0;
                fArray10[i] = (this.hy0 - 2.0f * this.hy1 + this.hy2 - this.a1 * this.hz1 - this.a2 * this.hz2) / this.a0;
                this.x2 = this.x1;
                this.x1 = fArray[i];
                this.ly2 = this.ly1;
                this.ly1 = this.ly0;
                this.lz2 = this.lz1;
                this.lz1 = fArray9[i];
                this.hy2 = this.hy1;
                this.hy1 = this.hy0;
                this.hz2 = this.hz1;
                this.hz1 = fArray10[i];
            }
        }
    }

    private final void calcVals() {
        this.k = (float)Math.tan(this.freq * this.pi_sr);
        this.lb0 = this.k * this.k;
        this.lb1 = 2.0f * this.lb0;
        this.a0 = this.lb0 + SQRT2 * this.k + 1.0f;
        this.a1 = 2.0f * (this.lb0 - 1.0f);
        this.a2 = this.lb0 - SQRT2 * this.k + 1.0f;
    }

    public void reset() {
        this.hy1 = 0.0f;
        this.hy2 = 0.0f;
        this.hz1 = 0.0f;
        this.hz2 = 0.0f;
        this.ly1 = 0.0f;
        this.ly2 = 0.0f;
        this.lz1 = 0.0f;
        this.lz2 = 0.0f;
    }

    public float getFrequency() {
        return this.freq;
    }

    public CrossoverFilter setFrequency(float f) {
        this.freq = f;
        this.freqUGen = null;
        this.calcVals();
        return this;
    }

    public CrossoverFilter setFrequency(UGen uGen) {
        if (uGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = uGen;
            uGen.update();
            this.freq = uGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public UGen getFrequencyUGen() {
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public CrossoverFilter setFreq(float f) {
        return this.setFrequency(f);
    }

    @Deprecated
    public CrossoverFilter setFreq(UGen uGen) {
        return this.setFrequency(uGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public int getChannels() {
        return this.channels;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        UGen uGen = dataBead.getUGen("frequency");
        if (uGen == null) {
            this.setFrequency(dataBead.getFloat("frequency", this.freq));
        } else {
            this.setFrequency(uGen);
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.sendData((DataBead)bead);
        }
    }

    public CrossoverFilter drawFromLowOutput(UGen uGen) {
        for (int i = 0; i < uGen.getIns() && i < this.channels; ++i) {
            uGen.addInput(i, this, i * 2);
        }
        return this;
    }

    public CrossoverFilter drawFromLowOutput(int n, UGen uGen, int n2) {
        uGen.addInput(n2, this, n * 2);
        return this;
    }

    public CrossoverFilter drawFromHighOutput(UGen uGen) {
        for (int i = 0; i < uGen.getIns() && i < this.channels; ++i) {
            uGen.addInput(i, this, i * 2 + 1);
        }
        return this;
    }

    public CrossoverFilter drawFromHighOutput(int n, UGen uGen, int n2) {
        uGen.addInput(n2, this, n * 2 + 1);
        return this;
    }
}

