/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.LinkedList;
import java.util.List;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;

public class Envelope
extends UGen {
    private LinkedList<Segment> segments = new LinkedList();
    private float currentStartValue = 0.0f;
    private float currentValue = 0.0f;
    private int currentTime;
    private Segment currentSegment = null;
    private boolean lock = false;
    private boolean unchanged = false;
    protected float[] myBufOut;

    public Envelope(AudioContext audioContext) {
        super(audioContext, 1);
        this.outputInitializationRegime = UGen.OutputInitializationRegime.RETAIN;
        this.outputPauseRegime = UGen.OutputPauseRegime.RETAIN;
        this.myBufOut = new float[this.bufferSize];
        this.bufOut[0] = this.myBufOut;
    }

    public Envelope(AudioContext audioContext, float f) {
        this(audioContext);
        this.setValue(f);
    }

    public Envelope lock(boolean bl) {
        this.lock = bl;
        return this;
    }

    public boolean isLocked() {
        return this.lock;
    }

    public synchronized Envelope addSegment(float f, float f2, float f3) {
        if (!(this.lock || Float.isNaN(f) || Float.isInfinite(f))) {
            this.segments.add(new Segment(f, f2, f3, null));
            this.unchanged = false;
        }
        return this;
    }

    public synchronized Envelope addSegment(float f, float f2, float f3, Bead bead) {
        if (!(this.lock || Float.isNaN(f) || Float.isInfinite(f))) {
            this.segments.add(new Segment(f, f2, f3, bead));
            this.unchanged = false;
        }
        return this;
    }

    public Envelope addSegment(float f, float f2) {
        return this.addSegment(f, f2, 1.0f, null);
    }

    public Envelope addSegment(float f, float f2, Bead bead) {
        return this.addSegment(f, f2, 1.0f, bead);
    }

    public Envelope addSegments(List<Segment> list) {
        if (!this.lock) {
            for (Segment segment : list) {
                if (Float.isNaN(segment.endValue) || Float.isInfinite(segment.endValue)) continue;
                list.add(segment);
                this.unchanged = false;
            }
        }
        return this;
    }

    @Override
    public void setValue(float f) {
        if (!this.lock) {
            this.clear();
            this.addSegment(f, 0.0f);
            this.currentValue = f;
        }
    }

    public synchronized Envelope clear() {
        if (!this.lock) {
            this.segments = new LinkedList();
            this.currentSegment = null;
        }
        return this;
    }

    private synchronized void getNextSegment() {
        if (this.currentSegment != null) {
            this.currentValue = this.currentStartValue = this.currentSegment.endValue;
            if (this.currentSegment.trigger != null) {
                this.currentSegment.trigger.message(this);
            }
        } else {
            this.currentStartValue = this.currentValue;
        }
        this.currentSegment = this.segments.pollFirst();
        this.currentTime = 0;
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public synchronized void calculateBuffer() {
        if (!this.unchanged) {
            boolean bl = false;
            for (int i = 0; i < this.bufferSize; ++i) {
                if (this.currentSegment == null) {
                    this.getNextSegment();
                } else if (this.currentSegment.duration == 0L) {
                    this.getNextSegment();
                    bl = true;
                } else {
                    bl = true;
                    float f = this.currentSegment.curvature != 1.0f ? (float)Math.pow((double)this.currentTime / (double)this.currentSegment.duration, this.currentSegment.curvature) : (float)this.currentTime / (float)this.currentSegment.duration;
                    this.currentValue = (1.0f - f) * this.currentStartValue + f * this.currentSegment.endValue;
                    ++this.currentTime;
                    if ((long)this.currentTime > this.currentSegment.duration) {
                        this.getNextSegment();
                    }
                }
                this.myBufOut[i] = this.currentValue;
            }
            if (!bl) {
                this.unchanged = true;
            }
        }
    }

    @Override
    public float getValue(int n, int n2) {
        if (this.unchanged) {
            return this.currentValue;
        }
        return this.myBufOut[n2];
    }

    public class Segment {
        float endValue;
        long duration;
        float curvature;
        Bead trigger;

        public Segment(float f, float f2, float f3, Bead bead) {
            this.endValue = f;
            this.duration = (int)Envelope.this.context.msToSamples(f2);
            this.curvature = Math.abs(f3);
            this.trigger = bead;
        }
    }
}

