/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.LinkedList;
import java.util.Queue;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class PolyLimit
extends UGen {
    private int maxInputs;
    private boolean steal = true;
    private Queue<UGen> existingInputs;

    public PolyLimit(AudioContext audioContext, int n, int n2) {
        super(audioContext, n, n);
        this.setMaxInputs(n2);
        this.existingInputs = new LinkedList<UGen>();
    }

    @Override
    public void addInput(UGen uGen) {
        if (this.existingInputs.contains(uGen)) {
            this.existingInputs.remove(uGen);
            this.existingInputs.add(uGen);
        } else if (this.steal) {
            if (this.existingInputs.size() >= this.maxInputs) {
                UGen uGen2 = this.existingInputs.poll();
                this.removeAllConnections(uGen2);
            }
            this.existingInputs.add(uGen);
            super.addInput(uGen);
        } else {
            LinkedList<UGen> linkedList = new LinkedList<UGen>();
            linkedList.addAll(this.existingInputs);
            for (UGen uGen3 : linkedList) {
                if (!uGen3.isDeleted()) continue;
                this.existingInputs.remove(uGen3);
            }
            if (this.existingInputs.size() < this.maxInputs) {
                this.existingInputs.add(uGen);
                super.addInput(uGen);
            }
        }
    }

    @Override
    public void removeAllConnections(UGen uGen) {
        super.removeAllConnections(uGen);
        this.existingInputs.remove(uGen);
    }

    public int getMaxInputs() {
        return this.maxInputs;
    }

    public void setMaxInputs(int n) {
        this.maxInputs = n;
    }

    public boolean isSteal() {
        return this.steal;
    }

    public void setSteal(boolean bl) {
        this.steal = bl;
    }

    @Override
    public void calculateBuffer() {
        for (int i = 0; i < this.ins; ++i) {
            this.bufOut[i] = this.bufIn[i];
        }
    }
}

