/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class RMS
extends UGen {
    private float[] rmsMem;
    private float sum = 0.0f;
    private float channelScale;
    private float memScale;
    private int channels;
    private int index = 0;
    private int memorySize;

    public RMS(AudioContext audioContext, int n, int n2) {
        super(audioContext, n, 1);
        this.channels = n;
        this.channelScale = 1.0f / (float)n;
        this.rmsMem = new float[n2];
        this.memorySize = n2;
        this.memScale = 1.0f / (float)n2;
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufOut[0];
        for (int i = 0; i < this.bufferSize; ++i) {
            float f = 0.0f;
            for (int j = 0; j < this.channels; ++j) {
                float f2 = this.bufIn[j][i];
                f += f2 * f2;
            }
            this.sum -= this.rmsMem[this.index];
            this.rmsMem[this.index] = f * this.channelScale;
            this.sum += this.rmsMem[this.index];
            if (this.sum < 0.0f) {
                this.sum = 0.0f;
            }
            this.index = (this.index + 1) % this.memorySize;
            fArray[i] = (float)Math.sqrt(this.sum * this.memScale);
        }
    }

    public int getChannels() {
        return this.channels;
    }

    public int getMemorySize() {
        return this.memorySize;
    }
}

