/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class RandomPWM
extends UGen
implements DataBeadReceiver {
    public static final Mode ALTERNATING = Mode.ALTERNATING;
    public static final Mode NOISE = Mode.NOISE;
    public static final Mode PULSING = Mode.PULSING;
    public static final Mode SAW = Mode.SAW;
    public static final Mode RAMPED_NOISE = Mode.RAMPED_NOISE;
    public static final Mode NOISE_ENVELOPE = Mode.NOISE_ENVELOPE;
    protected Mode mode = ALTERNATING;
    protected float targetVal = 0.0f;
    protected float baseVal = 0.0f;
    protected float valDiff = 0.0f;
    protected float count = 0.0f;
    protected float pulseLen = 0.0f;
    protected float minLength = 10.0f;
    protected float maxLength = 100.0f;
    protected float lengthExponent = 1.0f;
    protected float lengthDiff = 0.0f;

    public RandomPWM(AudioContext audioContext, Mode mode, float f, float f2) {
        this(audioContext, mode, f, f2, 1.0f);
    }

    public RandomPWM(AudioContext audioContext, Mode mode, float f, float f2, float f3) {
        super(audioContext, 0, 1);
        this.setParams(mode, f, f2, f3);
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufOut[0];
        if (this.mode == PULSING) {
            for (int i = 0; i < fArray.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = this.targetVal > 0.0f ? 0.0f : 1.0f;
                    this.valDiff = this.targetVal - this.baseVal;
                }
                fArray[i] = this.targetVal;
                this.count -= 1.0f;
            }
        } else if (this.mode == ALTERNATING) {
            for (int i = 0; i < fArray.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = this.targetVal > 0.0f ? -1.0f : 1.0f;
                    this.valDiff = this.targetVal - this.baseVal;
                }
                fArray[i] = this.targetVal;
                this.count -= 1.0f;
            }
        } else if (this.mode == SAW) {
            for (int i = 0; i < fArray.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = this.targetVal > 0.0f ? -1.0f : 1.0f;
                    this.valDiff = this.targetVal - this.baseVal;
                }
                fArray[i] = this.targetVal - this.count / this.pulseLen * this.valDiff;
                this.count -= 1.0f;
            }
        } else if (this.mode == RAMPED_NOISE) {
            for (int i = 0; i < fArray.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = (float)(Math.random() * 2.0 - 1.0);
                    this.valDiff = this.targetVal - this.baseVal;
                }
                fArray[i] = this.targetVal - this.count / this.pulseLen * this.valDiff;
                this.count -= 1.0f;
            }
        } else if (this.mode == NOISE_ENVELOPE) {
            for (int i = 0; i < fArray.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = (float)Math.random();
                    this.valDiff = this.targetVal - this.baseVal;
                }
                fArray[i] = this.targetVal - this.count / this.pulseLen * this.valDiff;
                this.count -= 1.0f;
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                if (this.count <= 0.0f) {
                    this.calcVals();
                    this.targetVal = (float)(Math.random() * 2.0 - 1.0);
                    this.valDiff = this.targetVal - this.baseVal;
                }
                fArray[i] = this.targetVal;
                this.count -= 1.0f;
            }
        }
    }

    protected void calcVals() {
        float f = (float)Math.pow(Math.random(), this.lengthExponent) * this.lengthDiff + this.minLength;
        this.count += f;
        this.pulseLen = this.count;
        this.baseVal = this.targetVal;
    }

    public RandomPWM setParams(Mode mode, float f, float f2, float f3) {
        this.setParams(f, f2, f3);
        this.setMode(mode);
        return this;
    }

    public RandomPWM setParams(float f, float f2, float f3) {
        this.setLengthExponent(f3);
        this.minLength = Math.max(f, 1.0f);
        this.maxLength = Math.max(this.minLength, f2);
        this.lengthDiff = this.maxLength - this.minLength;
        return this;
    }

    public RandomPWM setMinLength(float f) {
        this.setParams(f, this.maxLength, this.lengthExponent);
        return this;
    }

    public float getMinLength() {
        return this.minLength;
    }

    public RandomPWM setMaxLength(float f) {
        this.setParams(this.minLength, f, this.lengthExponent);
        return this;
    }

    public float getMaxLength() {
        return this.maxLength;
    }

    public RandomPWM setLengthExponent(float f) {
        float f2;
        this.lengthExponent = f;
        if (f2 < 0.001f) {
            this.lengthExponent = 0.001f;
        }
        return this;
    }

    public float getLengthExponent() {
        return this.lengthExponent;
    }

    public RandomPWM setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        if (dataBead != null) {
            Object object = dataBead.get("mode");
            Mode mode = this.mode;
            if (object instanceof Mode) {
                mode = (Mode)((Object)object);
            }
            this.setParams(mode, dataBead.getFloat("minLength", this.minLength), dataBead.getFloat("maxLength", this.maxLength), dataBead.getFloat("lengthExponent", this.lengthExponent));
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.sendData((DataBead)bead);
        }
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("mode", (Object)this.mode);
        dataBead.put("minLength", (Object)Float.valueOf(this.minLength));
        dataBead.put("maxLength", (Object)Float.valueOf(this.maxLength));
        dataBead.put("lengthExponent", (Object)Float.valueOf(this.lengthExponent));
        return dataBead;
    }

    public static enum Mode {
        ALTERNATING,
        NOISE,
        PULSING,
        SAW,
        RAMPED_NOISE,
        NOISE_ENVELOPE;

    }
}

