/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Sample;

public class RecordToSample
extends UGen {
    private Sample sample = null;
    private long position;
    private long framesWritten;
    private Mode mode = Mode.FINITE;
    private double doubleUpTime = 0.0;
    private double constantResizeLength = 10000.0;
    private long doubleUpFrame;
    private long constantResizeLengthInFrames;

    public RecordToSample(AudioContext audioContext, Sample sample) {
        this(audioContext, sample, Mode.FINITE);
    }

    public RecordToSample(AudioContext audioContext, Sample sample, Mode mode) {
        this(audioContext, sample.getNumChannels());
        this.mode = mode;
        this.setSample(sample);
    }

    public RecordToSample(AudioContext audioContext, int n) {
        super(audioContext, n, 0);
    }

    public Sample getSample() {
        return this.sample;
    }

    public void setSample(Sample sample) {
        this.sample = sample;
        this.framesWritten = 0L;
        this.position = 0L;
        this.doubleUpFrame = (long)sample.msToSamples(this.doubleUpTime);
        this.constantResizeLengthInFrames = (long)sample.msToSamples(this.constantResizeLength);
    }

    public void reset() {
        this.position = 0L;
    }

    public void clip() {
        this.sample.resize(this.framesWritten);
    }

    public void setPosition(double d) {
        this.framesWritten = this.position = (long)this.sample.msToSamples(d);
    }

    @Override
    public void calculateBuffer() {
        if (this.sample != null) {
            long l = this.sample.getNumFrames();
            if (this.position + (long)this.bufferSize >= l) {
                switch (this.mode) {
                    case FINITE: {
                        this.sample.putFrames((int)this.position, this.bufIn, 0, (int)(l - this.position));
                        this.framesWritten = Math.max(this.framesWritten, l);
                        this.kill();
                        break;
                    }
                    case LOOPING: {
                        int n = (int)(l - this.position);
                        int n2 = this.bufferSize - n;
                        this.sample.putFrames((int)this.position, this.bufIn, 0, n);
                        this.sample.putFrames(0, this.bufIn, n, n2);
                        this.position += (long)this.bufferSize;
                        this.position %= l;
                        this.framesWritten = Math.max(this.framesWritten, l);
                        break;
                    }
                    case INFINITE: {
                        try {
                            if (this.position < this.doubleUpFrame) {
                                this.sample.resize(l * 2L);
                            } else {
                                this.sample.resize(l + this.constantResizeLengthInFrames);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.sample.putFrames((int)this.position, this.bufIn);
                        this.position += (long)this.bufferSize;
                        this.framesWritten = Math.max(this.framesWritten, this.position);
                    }
                }
            } else {
                this.sample.putFrames((int)this.position, this.bufIn);
                this.position += (long)this.bufferSize;
                this.framesWritten = Math.max(this.framesWritten, this.position);
            }
        }
    }

    public double getPosition() {
        return this.context.samplesToMs(this.position);
    }

    public long getNumFramesRecorded() {
        return this.framesWritten;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setResizingParameters(double d, double d2) {
        this.doubleUpTime = d;
        this.constantResizeLength = d2;
        this.doubleUpFrame = (long)this.sample.msToSamples(this.doubleUpTime);
        this.constantResizeLengthInFrames = (long)this.sample.msToSamples(this.constantResizeLength);
    }

    public boolean isLoopRecord() {
        return this.mode == Mode.LOOPING;
    }

    public void setLoopRecord(boolean bl) {
        this.mode = Mode.LOOPING;
    }

    public static enum Mode {
        FINITE,
        LOOPING,
        INFINITE;

    }
}

