/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.AudioUtils;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.ugens.Static;

public class SamplePlayer
extends UGen {
    public static final float ADAPTIVE_INTERP_LOW_THRESH = 0.5f;
    public static final float ADAPTIVE_INTERP_HIGH_THRESH = 2.5f;
    protected Sample sample;
    protected double position;
    protected UGen positionEnvelope;
    protected UGen rateEnvelope;
    protected double positionIncrement;
    protected boolean forwards;
    protected EnvelopeType envelopeType;
    protected InterpolationType interpolationType;
    protected UGen loopStartEnvelope;
    protected UGen loopEndEnvelope;
    protected LoopType loopType;
    protected float loopCrossFade;
    protected boolean startLoop;
    protected boolean killOnEnd;
    protected float rate;
    protected float loopStart;
    protected float loopEnd;
    protected float[] frame;
    private Bead endListener;

    public SamplePlayer(AudioContext audioContext, int n) {
        super(audioContext, n);
        this.rateEnvelope = new Static(audioContext, 1.0f);
        this.positionEnvelope = null;
        this.envelopeType = EnvelopeType.FINE;
        this.interpolationType = InterpolationType.ADAPTIVE;
        this.loopType = LoopType.NO_LOOP_FORWARDS;
        this.forwards = true;
        this.killOnEnd = true;
        this.loopStartEnvelope = new Static(audioContext, 0.0f);
        this.loopEndEnvelope = new Static(audioContext, 0.0f);
        this.positionIncrement = audioContext.samplesToMs(1.0);
    }

    public SamplePlayer(AudioContext audioContext, Sample sample) {
        this(audioContext, sample.getNumChannels());
        this.setSample(sample);
        this.loopEndEnvelope.setValue((float)sample.getLength());
    }

    public void setSample(Sample sample) {
        this.sample = sample;
        this.frame = new float[sample.getNumChannels()];
    }

    public void setBuffer(Sample sample) {
        this.setSample(sample);
    }

    public Sample getSample() {
        return this.sample;
    }

    public Sample getBuffer() {
        return this.sample;
    }

    public void setToEnd() {
        this.position = this.sample.getLength();
    }

    public boolean inLoop() {
        return this.position < (double)Math.max(this.loopStart, this.loopEnd) && this.position > (double)Math.min(this.loopStart, this.loopEnd);
    }

    public void setToLoopStart() {
        this.position = Math.min(this.loopStart, this.loopEnd);
        this.forwards = this.rate > 0.0f;
    }

    public void start(float f) {
        this.position = f;
        this.start();
    }

    public void reset() {
        this.position = 0.0;
        this.forwards = true;
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double d) {
        this.position = d;
    }

    @Deprecated
    public UGen getPositionEnvelope() {
        return this.positionEnvelope;
    }

    public UGen getPositionUGen() {
        return this.positionEnvelope;
    }

    @Deprecated
    public void setPositionEnvelope(UGen uGen) {
        this.positionEnvelope = uGen;
    }

    public void setPosition(UGen uGen) {
        this.positionEnvelope = uGen;
    }

    @Deprecated
    public UGen getRateEnvelope() {
        return this.rateEnvelope;
    }

    public UGen getRateUGen() {
        return this.rateEnvelope;
    }

    @Deprecated
    public void setRateEnvelope(UGen uGen) {
        this.rateEnvelope = uGen;
    }

    public void setRate(UGen uGen) {
        this.rateEnvelope = uGen;
    }

    @Deprecated
    public UGen getPitchEnvelope() {
        return this.rateEnvelope;
    }

    public UGen getPitchUGen() {
        return this.rateEnvelope;
    }

    @Deprecated
    public void setPitchEnvelope(UGen uGen) {
        this.rateEnvelope = uGen;
    }

    public void setPitch(UGen uGen) {
        this.rateEnvelope = uGen;
    }

    public EnvelopeType getEnvelopeType() {
        return this.envelopeType;
    }

    public void setEnvelopeType(EnvelopeType envelopeType) {
        this.envelopeType = envelopeType;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public void setInterpolationType(InterpolationType interpolationType) {
        this.interpolationType = interpolationType;
    }

    @Deprecated
    public UGen getLoopEndEnvelope() {
        return this.loopEndEnvelope;
    }

    public UGen getLoopEndUGen() {
        return this.loopEndEnvelope;
    }

    @Deprecated
    public void setLoopEndEnvelope(UGen uGen) {
        this.loopEndEnvelope = uGen;
    }

    public void setLoopEnd(UGen uGen) {
        this.loopEndEnvelope = uGen;
    }

    @Deprecated
    public UGen getLoopStartEnvelope() {
        return this.loopStartEnvelope;
    }

    public UGen getLoopStartUGen() {
        return this.loopStartEnvelope;
    }

    @Deprecated
    public void setLoopStartEnvelope(UGen uGen) {
        this.loopStartEnvelope = uGen;
    }

    public void setLoopStart(UGen uGen) {
        this.loopStartEnvelope = uGen;
    }

    public void setLoopPointsFraction(float f, float f2) {
        this.loopStartEnvelope = new Static(this.context, f * (float)this.sample.getLength());
        this.loopEndEnvelope = new Static(this.context, f2 * (float)this.sample.getLength());
    }

    public LoopType getLoopType() {
        return this.loopType;
    }

    public void setLoopType(LoopType loopType) {
        this.loopType = loopType;
        if (loopType != LoopType.LOOP_ALTERNATING) {
            this.forwards = loopType == LoopType.LOOP_FORWARDS || loopType == LoopType.NO_LOOP_FORWARDS;
        }
    }

    public float getSampleRate() {
        return this.sample.getSampleRate();
    }

    @Override
    public void calculateBuffer() {
        block25: {
            block26: {
                block27: {
                    if (this.sample == null) break block25;
                    if (this.positionEnvelope != null) {
                        this.positionEnvelope.update();
                    } else {
                        this.rateEnvelope.update();
                        this.loopStartEnvelope.update();
                        this.loopEndEnvelope.update();
                    }
                    if (this.envelopeType != EnvelopeType.COARSE) break block26;
                    if (this.positionEnvelope == null) break block27;
                    float f = this.positionEnvelope.getValue(0, 0);
                    float f2 = this.positionEnvelope.getValue(0, this.bufferSize - 1);
                    long l = (long)this.sample.msToSamples(f);
                    long l2 = (long)this.sample.msToSamples(f2);
                    long l3 = 1L + Math.abs(l2 - l);
                    if (l2 >= l) {
                        float[][] fArray = new float[this.getOuts()][(int)l3];
                        this.sample.getFrames((int)l, fArray);
                        AudioUtils.stretchBuffer(fArray, this.bufOut);
                    } else {
                        float[][] fArray = new float[this.getOuts()][(int)l3];
                        this.sample.getFrames((int)l2, fArray);
                        AudioUtils.reverseBuffer(fArray);
                        AudioUtils.stretchBuffer(fArray, this.bufOut);
                    }
                    this.position = f2;
                    break block25;
                }
                this.rate = this.rateEnvelope.getValue(0, 0);
                switch (this.loopType) {
                    case NO_LOOP_FORWARDS: 
                    case NO_LOOP_BACKWARDS: {
                        boolean bl;
                        double d = this.loopType == LoopType.NO_LOOP_FORWARDS ? (double)this.rate : (double)(-this.rate);
                        long l = (long)(Math.abs(this.rate) * (float)this.bufferSize);
                        double d2 = this.sample.samplesToMs(l);
                        if (d >= 0.0) {
                            bl = true;
                            if (d2 + this.position > this.sample.getLength()) {
                                l = (long)this.sample.msToSamples(this.sample.getLength() - this.position);
                            }
                        } else {
                            bl = false;
                            if (this.position - d2 < 0.0) {
                                l = (long)this.sample.msToSamples(this.position);
                            }
                        }
                        if (l <= 0L) {
                            return;
                        }
                        float[][] fArray = new float[this.outs][(int)l];
                        if (bl) {
                            this.sample.getFrames((int)this.sample.msToSamples(this.position), fArray);
                            this.position += d2;
                        } else {
                            this.sample.getFrames((int)(this.sample.msToSamples(this.position) - (double)l), fArray);
                            AudioUtils.reverseBuffer(fArray);
                            this.position -= d2;
                        }
                        AudioUtils.stretchBuffer(fArray, this.bufOut);
                        if (this.position > this.sample.getLength() || this.position < 0.0) {
                            this.atEnd();
                            break;
                        }
                        break block25;
                    }
                    default: {
                        System.out.println("COARSE looping is not implemented yet. Killing SamplePlayer...");
                        this.kill();
                        break;
                    }
                }
                break block25;
            }
            for (int i = 0; i < this.bufferSize; ++i) {
                switch (this.interpolationType) {
                    case ADAPTIVE: {
                        if (this.rate > 2.5f) {
                            this.sample.getFrameNoInterp(this.position, this.frame);
                            break;
                        }
                        if (this.rate > 0.5f) {
                            this.sample.getFrameLinear(this.position, this.frame);
                            break;
                        }
                        this.sample.getFrameCubic(this.position, this.frame);
                        break;
                    }
                    case LINEAR: {
                        this.sample.getFrameLinear(this.position, this.frame);
                        break;
                    }
                    case CUBIC: {
                        this.sample.getFrameCubic(this.position, this.frame);
                        break;
                    }
                    case NONE: {
                        this.sample.getFrameNoInterp(this.position, this.frame);
                    }
                }
                for (int j = 0; j < this.outs; ++j) {
                    this.bufOut[j][i] = this.frame[j % this.sample.getNumChannels()];
                }
                this.calculateNextPosition(i);
            }
        }
    }

    public void setKillOnEnd(boolean bl) {
        this.killOnEnd = bl;
    }

    public boolean getKillOnEnd() {
        return this.killOnEnd;
    }

    private void atEnd() {
        if (this.endListener != null) {
            this.endListener.message(this);
        }
        if (this.killOnEnd) {
            this.kill();
        }
    }

    public void setEndListener(Bead bead) {
        this.endListener = bead;
    }

    public Bead getEndListener() {
        return this.endListener;
    }

    public void reTrigger() {
        this.reset();
        this.pause(false);
    }

    protected void calculateNextPosition(int n) {
        if (this.positionEnvelope != null) {
            this.position = this.positionEnvelope.getValueDouble(0, n);
        } else {
            this.rate = this.rateEnvelope.getValue(0, n);
            switch (this.loopType) {
                case NO_LOOP_FORWARDS: {
                    this.position += this.positionIncrement * (double)this.rate;
                    if (!(this.position > this.sample.getLength()) && !(this.position < 0.0)) break;
                    this.atEnd();
                    break;
                }
                case NO_LOOP_BACKWARDS: {
                    this.position -= this.positionIncrement * (double)this.rate;
                    if (!(this.position > this.sample.getLength()) && !(this.position < 0.0)) break;
                    this.atEnd();
                    break;
                }
                case LOOP_FORWARDS: {
                    this.loopStart = this.loopStartEnvelope.getValue(0, n);
                    this.loopEnd = this.loopEndEnvelope.getValue(0, n);
                    this.position += this.positionIncrement * (double)this.rate;
                    if (this.rate > 0.0f && this.position > (double)Math.max(this.loopStart, this.loopEnd)) {
                        this.position = Math.min(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(this.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    this.position = Math.max(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_BACKWARDS: {
                    this.loopStart = this.loopStartEnvelope.getValue(0, n);
                    this.loopEnd = this.loopEndEnvelope.getValue(0, n);
                    this.position -= this.positionIncrement * (double)this.rate;
                    if (this.rate > 0.0f && this.position < (double)Math.min(this.loopStart, this.loopEnd)) {
                        this.position = Math.max(this.loopStart, this.loopEnd);
                        break;
                    }
                    if (!(this.rate < 0.0f) || !(this.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                    this.position = Math.min(this.loopStart, this.loopEnd);
                    break;
                }
                case LOOP_ALTERNATING: {
                    this.loopStart = this.loopStartEnvelope.getValue(0, n);
                    this.loopEnd = this.loopEndEnvelope.getValue(0, n);
                    this.position += this.forwards ? this.positionIncrement * (double)this.rate : -this.positionIncrement * (double)this.rate;
                    if (this.forwards ^ this.rate < 0.0f) {
                        if (!(this.position > (double)Math.max(this.loopStart, this.loopEnd))) break;
                        this.forwards = this.rate < 0.0f;
                        this.position = (double)(2.0f * Math.max(this.loopStart, this.loopEnd)) - this.position;
                        break;
                    }
                    if (!(this.position < (double)Math.min(this.loopStart, this.loopEnd))) break;
                    this.forwards = this.rate > 0.0f;
                    this.position = (double)(2.0f * Math.min(this.loopStart, this.loopEnd)) - this.position;
                }
            }
        }
    }

    public static enum EnvelopeType {
        COARSE,
        FINE;

    }

    public static enum LoopType {
        NO_LOOP_FORWARDS,
        NO_LOOP_BACKWARDS,
        LOOP_FORWARDS,
        LOOP_BACKWARDS,
        LOOP_ALTERNATING;

    }

    public static enum InterpolationType {
        NONE,
        LINEAR,
        CUBIC,
        ADAPTIVE;

    }
}

