/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.ugens.Glide;

public class Spatial
extends UGen {
    private int dimensions;
    private float[][] speakerPositions;
    private float sphereDiameter;
    private Map<UGen, Location> sources;
    private List<UGen> deadSources;
    private float curve;

    public Spatial(AudioContext audioContext, int n) {
        this(audioContext, n, (float)Math.sqrt(n));
    }

    public Spatial(AudioContext audioContext, int n, float f) {
        super(audioContext, (int)Math.pow(2.0, n));
        this.dimensions = n;
        switch (n) {
            case 1: {
                this.setSpeakerPositions(new float[][]{{0.0f}, {1.0f}});
                break;
            }
            case 2: {
                this.setSpeakerPositions(new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}});
                break;
            }
            case 3: {
                this.setSpeakerPositions(new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}});
                break;
            }
            default: {
                new IllegalArgumentException("Error, that's a stupid number of dimensions: " + n + "!").printStackTrace();
            }
        }
        this.setSphereDiameter(f);
        this.setup();
    }

    public Spatial(AudioContext audioContext, int n, float[][] fArray) {
        this(audioContext, n, fArray, (float)Math.sqrt(n));
    }

    public Spatial(AudioContext audioContext, int n, float[][] fArray, float f) {
        super(audioContext, fArray.length);
        this.dimensions = n;
        this.setSpeakerPositions(fArray);
        this.setSphereDiameter(f);
        this.setup();
    }

    private void setup() {
        this.outputInitializationRegime = UGen.OutputInitializationRegime.ZERO;
        this.sources = Collections.synchronizedMap(new Hashtable());
        this.deadSources = new ArrayList<UGen>();
        this.curve = 3.0f;
    }

    public void setSphereDiameter(float f) {
        this.sphereDiameter = f;
    }

    public static float[][] speakerPositionsFromFile(String string, int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            Scanner scanner = new Scanner(fileInputStream);
            LinkedList<Float> linkedList = new LinkedList<Float>();
            while (scanner.hasNext()) {
                linkedList.add(Float.valueOf(scanner.nextFloat()));
            }
            System.out.print("Spatial: Loaded speaker positions from " + string + " ");
            float[][] fArray = new float[linkedList.size() / n][n];
            for (int i = 0; i < fArray.length; ++i) {
                System.out.print("[");
                for (int j = 0; j < n; ++j) {
                    fArray[i][j] = ((Float)linkedList.poll()).floatValue();
                    System.out.print(fArray[i][j] + " ");
                }
                System.out.print("]");
            }
            System.out.println();
            return fArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setSpeakerPositions(float[][] fArray) {
        if (fArray.length > 0 && fArray[0].length != this.dimensions) {
            new IllegalArgumentException("Error, location data does not correspond to dimensions: " + this.dimensions + "!").printStackTrace();
            return;
        }
        this.speakerPositions = new float[fArray.length][this.dimensions];
        for (int i = 0; i < this.speakerPositions.length; ++i) {
            for (int j = 0; j < this.dimensions; ++j) {
                this.speakerPositions[i][j] = fArray[i][j];
            }
        }
    }

    public static float distance(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += (fArray[i] - fArray2[i]) * (fArray[i] - fArray2[i]);
        }
        f = (float)Math.sqrt(f);
        return f;
    }

    @Override
    public void addInput(UGen uGen) {
        Location location = new Location(uGen);
        this.sources.put(uGen, location);
    }

    @Override
    public void addInput(int n, UGen uGen, int n2) {
        this.addInput(uGen);
    }

    public void addInput(UGen uGen, UGen[][] uGenArray) {
        Location location = new Location(uGen, uGenArray);
        this.sources.put(uGen, location);
    }

    public void setLocation(UGen uGen, int n, float[] fArray) {
        Location location = this.sources.get(uGen);
        if (location != null) {
            location.move(n, fArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(UGen uGen) {
        Map<UGen, Location> map = this.sources;
        synchronized (map) {
            this.sources.remove(uGen);
        }
    }

    @Override
    public synchronized void clearInputConnections() {
        super.clearInputConnections();
        this.sources.clear();
    }

    @Override
    public synchronized void removeAllConnections(UGen uGen) {
        super.removeAllConnections(uGen);
        this.removeSource(uGen);
    }

    public void setCurve(float f) {
        this.curve = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateBuffer() {
        Map<UGen, Location> map = this.sources;
        synchronized (map) {
            for (UGen uGen : this.sources.keySet()) {
                Location location = this.sources.get(uGen);
                location.mixInAudio(this.bufOut);
                if (!uGen.isDeleted()) continue;
                this.deadSources.add(uGen);
            }
            for (UGen uGen : this.deadSources) {
                this.sources.remove(uGen);
            }
            this.deadSources.clear();
        }
    }

    @Override
    public synchronized int getNumberOfConnectedUGens(int n) {
        return this.sources.size();
    }

    public synchronized int getNumberOfSources() {
        return this.sources.size();
    }

    private class Location {
        UGen source;
        UGen[][] pos;
        boolean ownsPosition;

        Location(UGen uGen) {
            this.source = uGen;
            this.pos = new UGen[uGen.getOuts()][Spatial.this.dimensions];
            for (int i = 0; i < this.pos.length; ++i) {
                for (int j = 0; j < Spatial.this.dimensions; ++j) {
                    this.pos[i][j] = new Glide(Spatial.this.context, 100.0f, 5.0f);
                }
            }
            this.ownsPosition = true;
        }

        Location(UGen uGen, UGen[][] uGenArray) {
            this.source = uGen;
            this.pos = uGenArray;
            this.ownsPosition = false;
        }

        void move(int n, float[] fArray) {
            if (!this.ownsPosition) {
                return;
            }
            for (int i = 0; i < this.pos[n].length; ++i) {
                this.pos[n][i].setValue(fArray[i]);
            }
        }

        void moveImmediately(int n, float[] fArray) {
            if (!this.ownsPosition) {
                return;
            }
            for (int i = 0; i < this.pos[n].length; ++i) {
                ((Glide)this.pos[n][i]).setValueImmediately(fArray[i]);
            }
        }

        void mixInAudio(float[][] fArray) {
            this.source.update();
            for (int i = 0; i < this.pos.length; ++i) {
                int n;
                for (n = 0; n < Spatial.this.dimensions; ++n) {
                    this.pos[i][n].update();
                }
                for (n = 0; n < Spatial.this.bufferSize; ++n) {
                    int n2;
                    float[] fArray2 = new float[Spatial.this.dimensions];
                    for (int j = 0; j < Spatial.this.dimensions; ++j) {
                        fArray2[j] = this.pos[i][j].getValue(0, n);
                    }
                    float[] fArray3 = new float[Spatial.this.speakerPositions.length];
                    for (n2 = 0; n2 < Spatial.this.speakerPositions.length; ++n2) {
                        float f;
                        float f2 = Spatial.distance(Spatial.this.speakerPositions[n2], fArray2);
                        fArray3[n2] = f = Math.max(0.0f, 1.0f - f2 / Spatial.this.sphereDiameter);
                    }
                    for (n2 = 0; n2 < Spatial.this.speakerPositions.length; ++n2) {
                        float[] fArray4 = fArray[n2];
                        int n3 = n;
                        fArray4[n3] = fArray4[n3] + fArray3[n2] * this.source.getValue(i, n);
                    }
                }
            }
        }
    }
}

