/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.ugens.Static;

public class WavePlayer
extends UGen {
    private double phase;
    private UGen frequencyEnvelope;
    private UGen phaseEnvelope;
    private Buffer buffer;
    private float frequency;
    private float one_over_sr;
    private boolean isFreqStatic;

    private WavePlayer(AudioContext audioContext, Buffer buffer) {
        super(audioContext, 1);
        this.buffer = buffer;
        this.phase = 0.0;
        this.one_over_sr = 1.0f / audioContext.getSampleRate();
    }

    public WavePlayer(AudioContext audioContext, UGen uGen, Buffer buffer) {
        this(audioContext, buffer);
        this.setFrequency(uGen);
    }

    public WavePlayer(AudioContext audioContext, float f, Buffer buffer) {
        this(audioContext, buffer);
        this.setFrequency(f);
    }

    @Override
    public void start() {
        super.start();
        this.phase = 0.0;
    }

    @Override
    public void calculateBuffer() {
        this.frequencyEnvelope.update();
        float[] fArray = this.bufOut[0];
        if (this.phaseEnvelope == null) {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.frequency = this.frequencyEnvelope.getValue(0, i);
                this.phase = ((this.phase + (double)(this.frequency * this.one_over_sr)) % 1.0 + 1.0) % 1.0;
                fArray[i] = this.buffer.getValueFraction((float)this.phase);
            }
        } else {
            this.phaseEnvelope.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                fArray[i] = this.buffer.getValueFraction(this.phaseEnvelope.getValue(0, i));
            }
        }
    }

    @Deprecated
    public UGen getFrequencyEnvelope() {
        return this.frequencyEnvelope;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.frequencyEnvelope;
    }

    public float getFrequency() {
        return this.frequency;
    }

    @Deprecated
    public void setFrequencyEnvelope(UGen uGen) {
        this.setFrequency(uGen);
    }

    public WavePlayer setFrequency(UGen uGen) {
        if (uGen == null) {
            this.setFrequency(this.frequency);
        } else {
            this.frequencyEnvelope = uGen;
            this.isFreqStatic = false;
        }
        return this;
    }

    public WavePlayer setFrequency(float f) {
        if (this.isFreqStatic) {
            ((Static)this.frequencyEnvelope).setValue(f);
        } else {
            this.frequencyEnvelope = new Static(this.context, f);
            this.isFreqStatic = true;
        }
        this.frequency = f;
        return this;
    }

    @Deprecated
    public UGen getPhaseEnvelope() {
        return this.phaseEnvelope;
    }

    public UGen getPhaseUGen() {
        return this.phaseEnvelope;
    }

    public float getPhase() {
        return (float)this.phase;
    }

    @Deprecated
    public void setPhaseEnvelope(UGen uGen) {
        this.setPhase(uGen);
    }

    public WavePlayer setPhase(UGen uGen) {
        this.phaseEnvelope = uGen;
        if (uGen != null) {
            this.phase = uGen.getValue();
        }
        return this;
    }

    public WavePlayer setPhase(float f) {
        this.phase = f;
        this.phaseEnvelope = null;
        return this;
    }

    public WavePlayer setBuffer(Buffer buffer) {
        this.buffer = buffer;
        return this;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }
}

