/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class ZeroCross
extends UGen {
    private boolean above = false;
    private boolean[] cross;
    private int sum = 0;
    private int index = 0;
    private int memSize;

    public ZeroCross(AudioContext audioContext, float f) {
        super(audioContext, 1, 1);
        this.memSize = (int)(audioContext.msToSamples(f) + 1.0);
        this.cross = new boolean[this.memSize];
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufIn[0];
        float[] fArray2 = this.bufOut[0];
        for (int i = 0; i < this.bufferSize; ++i) {
            if (this.cross[this.index]) {
                --this.sum;
                this.cross[this.index] = false;
            }
            if (fArray[i] < 0.0f) {
                if (this.above) {
                    this.cross[this.index] = true;
                    ++this.sum;
                    this.above = false;
                }
            } else if (!this.above) {
                this.cross[this.index] = true;
                ++this.sum;
                this.above = true;
            }
            fArray2[i] = this.sum;
            this.index = (this.index + 1) % this.memSize;
        }
    }

    public float getMemorySize() {
        return (float)this.context.samplesToMs(this.memSize);
    }
}

