/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import com.sun.corba.se.impl.util.RepositoryId;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Names;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.Constants;
import sun.rmi.rmic.iiop.ContextElement;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Identifier;

public abstract class Type
implements Constants,
ContextElement,
Cloneable {
    private int typeCode;
    private int fullTypeCode;
    private Identifier id;
    private String name;
    private String packageName;
    private String qualifiedName;
    private String idlName;
    private String[] idlModuleNames;
    private String qualifiedIDLName;
    private String repositoryID;
    private Class ourClass;
    private int status = 0;
    protected BatchEnvironment env;
    protected ContextStack stack;
    protected boolean destroyed = false;

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public abstract String getSignature();

    public String getIDLName() {
        return this.idlName;
    }

    public String[] getIDLModuleNames() {
        return this.idlModuleNames;
    }

    public String getQualifiedIDLName(boolean bl) {
        if (bl && this.getIDLModuleNames().length > 0) {
            return "::" + this.qualifiedIDLName;
        }
        return this.qualifiedIDLName;
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public String getBoxedRepositoryID() {
        return RepositoryId.createForJavaType((Class)this.ourClass);
    }

    public Class getClassInstance() {
        if (this.ourClass == null) {
            this.initClass();
        }
        return this.ourClass;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public BatchEnvironment getEnv() {
        return this.env;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public int getFullTypeCode() {
        return this.fullTypeCode;
    }

    public int getTypeCodeModifiers() {
        return this.fullTypeCode & 0xFF000000;
    }

    public boolean isType(int n) {
        return (this.fullTypeCode & n) == n;
    }

    public boolean typeMatches(int n) {
        return (this.fullTypeCode & n) > 0;
    }

    public int getRootTypeCode() {
        if (this.isArray()) {
            return this.getElementType().getFullTypeCode();
        }
        return this.fullTypeCode;
    }

    public boolean isInterface() {
        return (this.fullTypeCode & 0x8000000) == 0x8000000;
    }

    public boolean isClass() {
        return (this.fullTypeCode & 0x4000000) == 0x4000000;
    }

    public boolean isInner() {
        return (this.fullTypeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public boolean isSpecialInterface() {
        return (this.fullTypeCode & 0x20000000) == 0x20000000;
    }

    public boolean isSpecialClass() {
        return (this.fullTypeCode & 0x10000000) == 0x10000000;
    }

    public boolean isCompound() {
        return (this.fullTypeCode & 0x2000000) == 0x2000000;
    }

    public boolean isPrimitive() {
        return (this.fullTypeCode & 0x1000000) == 0x1000000;
    }

    public boolean isArray() {
        return (this.fullTypeCode & 0x40000) == 262144;
    }

    public boolean isConforming() {
        return (this.fullTypeCode & 0x40000000) == 0x40000000;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public Type getElementType() {
        return null;
    }

    public int getArrayDimension() {
        return 0;
    }

    public String getArrayBrackets() {
        return "";
    }

    public boolean equals(Object object) {
        String string = this.toString();
        String string2 = ((Type)object).toString();
        return string.equals(string2);
    }

    public Type[] collectMatching(int n) {
        return this.collectMatching(n, new HashSet(this.env.allTypes.size()));
    }

    public Type[] collectMatching(int n, HashSet hashSet) {
        Vector vector = new Vector();
        this.addTypes(n, hashSet, vector);
        Object[] objectArray = new Type[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public abstract String getTypeDescription();

    public String getTypeName(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            if (bl) {
                return this.getQualifiedIDLName(bl3);
            }
            return this.getIDLName();
        }
        if (bl) {
            return this.getQualifiedName();
        }
        return this.getName();
    }

    public void print(IndentingWriter indentingWriter, int n, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Type[] typeArray = this.collectMatching(n);
        Type.print(indentingWriter, typeArray, bl, bl2, bl3);
    }

    public static void print(IndentingWriter indentingWriter, Type[] typeArray, boolean bl, boolean bl2, boolean bl3) throws IOException {
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i].println(indentingWriter, bl, bl2, bl3);
        }
    }

    public void print(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.printTypeName(indentingWriter, bl, bl2, bl3);
    }

    public void println(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.print(indentingWriter, bl, bl2, bl3);
        indentingWriter.pln();
    }

    public void printTypeName(IndentingWriter indentingWriter, boolean bl, boolean bl2, boolean bl3) throws IOException {
        indentingWriter.p(this.getTypeName(bl, bl2, bl3));
    }

    public String getElementName() {
        return this.getQualifiedName();
    }

    protected void printPackageOpen(IndentingWriter indentingWriter, boolean bl) throws IOException {
        if (bl) {
            String[] stringArray = this.getIDLModuleNames();
            for (int i = 0; i < stringArray.length; ++i) {
                indentingWriter.plnI("module " + stringArray[i] + " {");
            }
        } else {
            String string = this.getPackageName();
            if (string != null) {
                indentingWriter.pln("package " + string + ";");
            }
        }
    }

    protected static Type getType(sun.tools.java.Type type, ContextStack contextStack) {
        return Type.getType(type.toString(), contextStack);
    }

    protected static Type getType(String string, ContextStack contextStack) {
        Type type = (Type)contextStack.getEnv().allTypes.get(string);
        if (type != null) {
            contextStack.traceExistingType(type);
        }
        return type;
    }

    protected static void removeType(String string, ContextStack contextStack) {
        Type type = (Type)contextStack.getEnv().allTypes.remove(string);
        contextStack.getEnv().invalidTypes.put(type, string);
    }

    protected static void removeType(sun.tools.java.Type type, ContextStack contextStack) {
        String string = type.toString();
        Type type2 = (Type)contextStack.getEnv().allTypes.remove(string);
        Type.putInvalidType(type2, string, contextStack);
    }

    protected static void putType(sun.tools.java.Type type, Type type2, ContextStack contextStack) {
        contextStack.getEnv().allTypes.put(type.toString(), type2);
    }

    protected static void putType(String string, Type type, ContextStack contextStack) {
        contextStack.getEnv().allTypes.put(string, type);
    }

    protected static void putInvalidType(Type type, String string, ContextStack contextStack) {
        contextStack.getEnv().invalidTypes.put(type, string);
    }

    public void removeInvalidTypes() {
        if (this.env.invalidTypes.size() > 0) {
            this.env.invalidTypes.clear();
        }
    }

    protected static void updateAllInvalidTypes(ContextStack contextStack) {
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        if (batchEnvironment.invalidTypes.size() > 0) {
            Enumeration enumeration = batchEnvironment.allTypes.elements();
            while (enumeration.hasMoreElements()) {
                Type type = (Type)enumeration.nextElement();
                type.swapInvalidTypes();
            }
            batchEnvironment.invalidTypes.clear();
        }
    }

    protected int countTypes() {
        return this.env.allTypes.size();
    }

    void resetTypes() {
        this.env.reset();
    }

    protected void destroy() {
        if (!this.destroyed) {
            this.id = null;
            this.name = null;
            this.packageName = null;
            this.qualifiedName = null;
            this.idlName = null;
            this.idlModuleNames = null;
            this.qualifiedIDLName = null;
            this.repositoryID = null;
            this.ourClass = null;
            this.env = null;
            this.stack = null;
            this.destroyed = true;
        }
    }

    protected void swapInvalidTypes() {
    }

    protected Type getValidType(Type type) {
        if (type.getStatus() == 1) {
            return type;
        }
        String string = (String)this.env.invalidTypes.get(type);
        Type type2 = null;
        if (string != null) {
            type2 = (Type)this.env.allTypes.get(string);
        }
        if (type2 == null) {
            throw new Error("Failed to find valid type to swap for " + type + " mis-identified as " + type.getTypeDescription());
        }
        return type2;
    }

    protected void printPackageClose(IndentingWriter indentingWriter, boolean bl) throws IOException {
        if (bl) {
            String[] stringArray = this.getIDLModuleNames();
            for (int i = 0; i < stringArray.length; ++i) {
                indentingWriter.pOln("};");
            }
        }
    }

    protected Type(ContextStack contextStack, int n) {
        this.env = contextStack.getEnv();
        this.stack = contextStack;
        this.fullTypeCode = n;
        this.typeCode = n & 0xFFFFFF;
    }

    protected void setTypeCode(int n) {
        this.fullTypeCode = n;
        this.typeCode = n & 0xFFFFFF;
    }

    protected void setNames(Identifier identifier, String[] stringArray, String string) {
        this.id = identifier;
        this.name = Names.mangleClass(identifier).getName().toString();
        this.packageName = null;
        if (identifier.isQualified()) {
            this.packageName = identifier.getQualifier().toString();
            this.qualifiedName = this.packageName + "." + this.name;
        } else {
            this.qualifiedName = this.name;
        }
        this.setIDLNames(stringArray, string);
    }

    protected void setIDLNames(String[] stringArray, String string) {
        this.idlName = string;
        this.idlModuleNames = stringArray != null ? stringArray : new String[0];
        this.qualifiedIDLName = IDLNames.getQualifiedName(stringArray, string);
    }

    protected static void classNotFound(ContextStack contextStack, ClassNotFound classNotFound) {
        Type.classNotFound(false, contextStack, classNotFound);
    }

    protected static void classNotFound(boolean bl, ContextStack contextStack, ClassNotFound classNotFound) {
        if (!bl) {
            contextStack.getEnv().error(0L, "rmic.class.not.found", classNotFound.name);
        }
        contextStack.traceCallStack();
    }

    protected static boolean failedConstraint(int n, boolean bl, ContextStack contextStack, Object object, Object object2, Object object3) {
        String string = "rmic.iiop.constraint." + n;
        if (!bl) {
            contextStack.getEnv().error(0L, string, object != null ? object.toString() : null, object2 != null ? object2.toString() : null, object3 != null ? object3.toString() : null);
        } else {
            String string2 = contextStack.getEnv().errorString(string, object, object2, object3);
            contextStack.traceln(string2);
        }
        return false;
    }

    protected static boolean failedConstraint(int n, boolean bl, ContextStack contextStack, Object object, Object object2) {
        return Type.failedConstraint(n, bl, contextStack, object, object2, null);
    }

    protected static boolean failedConstraint(int n, boolean bl, ContextStack contextStack, Object object) {
        return Type.failedConstraint(n, bl, contextStack, object, null, null);
    }

    protected static boolean failedConstraint(int n, boolean bl, ContextStack contextStack) {
        return Type.failedConstraint(n, bl, contextStack, null, null, null);
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("clone failed");
        }
    }

    protected boolean addTypes(int n, HashSet hashSet, Vector vector) {
        boolean bl;
        if (hashSet.contains(this)) {
            bl = false;
        } else {
            hashSet.add(this);
            if (this.typeMatches(n)) {
                vector.addElement(this);
            }
            bl = true;
        }
        return bl;
    }

    protected abstract Class loadClass();

    private boolean initClass() {
        if (this.ourClass == null) {
            this.ourClass = this.loadClass();
            if (this.ourClass == null) {
                Type.failedConstraint(27, false, this.stack, this.getQualifiedName());
                return false;
            }
        }
        return true;
    }

    protected boolean setRepositoryID() {
        if (!this.initClass()) {
            return false;
        }
        this.repositoryID = RepositoryId.createForAnyType((Class)this.ourClass);
        return true;
    }

    private Type() {
    }
}

