#!/usr/bin/perl
use File::Spec;
use File::Basename;
use File::Which;
use Cwd 'abs_path';

$bot_path = File::Spec->rel2abs($0);
$bot_dir = dirname($bot_path);
chdir($bot_dir);
#print &cwd;

open(INPUT,  "<",  "config.txt")  or die "Can't open input.txt: $!";

# Musebot name
$line = <INPUT>;
($field,$value) = ($line =~ /(.+) (.+)/);
$bot_name = $value;
print "Running $bot_name ...\n";


# Conductor name
$line = <INPUT>;
($field,$value) = ($line =~ /(.+) (.+)/);
$conductor_name = $value;


# Conductor port
$line = <INPUT>;
($field,$value) = ($line =~ /(.+) (.+)/);
$mc_port = $value;


# Musebot port
$line = <INPUT>;
($field,$value) = ($line =~ /(.+) (.+)/);
$bot_port = $value;

close(INPUT);

# In order to have several different extempore instances running, calculate
# a unique port number for extempore based on the musebot port
# We have to faff about doubling the musebot port number LSBs, because extempore
# opens two successive ports, whilst the musebot conductor only increments each
# port by 1. 
$remainder = $bot_port % 100;
$extempore_port = 2 * $remainder + 8000;

print "Open extempore on port $extempore_port\n";

print "Connecting to $conductor_name port $mc_port and listening on port $bot_port\n";


my $exe_path = which 'extempore';
my $exe_dir = "/Applications/extempore";

if (-f "Applications/extempore/extempore") {
	$exe_dir = "Applications/extempore";
} elsif (defined($exe_path)) {
	$exe_dir = dirname(abs_path($exe_path));
}

chdir($exe_dir);
$cmd = "./extempore --device=2 --port=$extempore_port --bot_dir='$bot_dir' --run='$bot_dir/$bot_name.xtm'";
print "\n $cmd \n";
exec($cmd);
