/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.io;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;

abstract class ConsoleStream
extends PrintStream {
    public static final String NL = "\n";
    protected static final int MAX_LINE_LENGTH = 200;
    private ByteArrayOutputStream mBaos = null;

    protected ConsoleStream(ByteArrayOutputStream baos) {
        super(baos, true);
        this.mBaos = baos;
    }

    protected abstract void send(String var1);

    public void print(float f) {
        String s = String.valueOf(f);
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(long l) {
        String s = String.valueOf(l);
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(int i) {
        String s = String.valueOf(i);
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(String s) {
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(Object o) {
        String s = o != null ? o.toString() : "null";
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(double d) {
        String s = String.valueOf(d);
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(char[] c) {
        String s = String.valueOf(c);
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(char c) {
        String s = String.valueOf(c);
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void print(boolean b) {
        String s = String.valueOf(b);
        this.mBaos.write(s.getBytes(), 0, s.length());
    }

    public void println() {
        this.flush();
    }

    public void println(float f) {
        String s = String.valueOf(f);
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(long l) {
        String s = String.valueOf(l);
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(int i) {
        String s = String.valueOf(i);
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(String s) {
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(Object o) {
        String s = o != null ? o.toString() : "null";
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(double d) {
        String s = String.valueOf(d);
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(char[] c) {
        String s = String.valueOf(c);
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(char c) {
        String s = String.valueOf(c);
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void println(boolean b) {
        String s = String.valueOf(b);
        this.mBaos.write(s.getBytes(), 0, s.length());
        this.flush();
    }

    public void flush() {
        super.flush();
        String s = this.mBaos.toString();
        int len = s.length();
        StringTokenizer st = new StringTokenizer(s, NL);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int linelength = line.length();
            if (line.length() > 200) {
                for (int i = 0; i < linelength; i += 200) {
                    String sub = line.substring(i, Math.min(i + 200, linelength));
                    this.send(sub);
                }
                continue;
            }
            this.send(line);
        }
        this.mBaos.reset();
    }

    public void reset() {
        super.flush();
        this.mBaos.reset();
    }
}

