/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import jode.GlobalOptions;
import jode.bytecode.BinaryInfo;
import jode.bytecode.ClassFormatException;
import jode.bytecode.ConstantPool;
import jode.bytecode.GrowableConstantPool;
import jode.bytecode.Handler;
import jode.bytecode.Instruction;
import jode.bytecode.LineNumber;
import jode.bytecode.LocalVariableInfo;
import jode.bytecode.MethodInfo;
import jode.bytecode.Opcodes;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;

public class BytecodeInfo
extends BinaryInfo
implements Opcodes {
    private static final Object[] constants = new Object[]{null, new Integer(-1), new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Long(0L), new Long(1L), new Float(0.0f), new Float(1.0f), new Float(2.0f), new Double(0.0), new Double(1.0)};
    private MethodInfo methodInfo;
    private int maxStack;
    private int maxLocals;
    private Handler[] exceptionHandlers;
    private LocalVariableInfo[] lvt;
    private LineNumber[] lnt;
    private Instruction[] instrs;
    private InstructionList instructions;

    protected void readAttribute(String string, int n, ConstantPool constantPool, DataInputStream dataInputStream, int n2) throws IOException {
        if ((n2 & 0x10) != 0 && string.equals("LocalVariableTable")) {
            int n3;
            if ((GlobalOptions.debuggingFlags & 0x40) != 0) {
                GlobalOptions.err.println("LocalVariableTable of " + this.methodInfo);
            }
            if (n != 2 + (n3 = dataInputStream.readUnsignedShort()) * 10) {
                if ((GlobalOptions.debuggingFlags & 0x40) != 0) {
                    GlobalOptions.err.println("Illegal LVT length, ignoring it");
                }
                return;
            }
            this.lvt = new LocalVariableInfo[n3];
            int n4 = 0;
            while (n4 < n3) {
                Instruction instruction;
                Instruction instruction2;
                this.lvt[n4] = new LocalVariableInfo();
                int n5 = dataInputStream.readUnsignedShort();
                int n6 = n5 + dataInputStream.readUnsignedShort();
                int n7 = dataInputStream.readUnsignedShort();
                int n8 = dataInputStream.readUnsignedShort();
                int n9 = dataInputStream.readUnsignedShort();
                Instruction instruction3 = instruction2 = n5 >= 0 && n5 < this.instrs.length ? this.instrs[n5] : null;
                if (n6 >= 0 && n6 < this.instrs.length) {
                    instruction = this.instrs[n6] == null ? null : this.instrs[n6].getPrevByAddr();
                } else {
                    instruction = null;
                    int n10 = this.instrs.length - 1;
                    while (n10 >= 0) {
                        if (this.instrs[n10] != null) {
                            if (this.instrs[n10].getNextAddr() != n6) break;
                            instruction = this.instrs[n10];
                            break;
                        }
                        --n10;
                    }
                }
                if (instruction2 == null || instruction == null || n7 == 0 || n8 == 0 || n9 >= this.maxLocals || constantPool.getTag(n7) != 1 || constantPool.getTag(n8) != 1) {
                    if ((GlobalOptions.debuggingFlags & 0x40) != 0) {
                        GlobalOptions.err.println("Illegal entry, ignoring LVT");
                    }
                    this.lvt = null;
                    return;
                }
                this.lvt[n4].start = instruction2;
                this.lvt[n4].end = instruction;
                this.lvt[n4].name = constantPool.getUTF8(n7);
                this.lvt[n4].type = constantPool.getUTF8(n8);
                this.lvt[n4].slot = n9;
                if ((GlobalOptions.debuggingFlags & 0x40) != 0) {
                    GlobalOptions.err.println("\t" + this.lvt[n4].name + ": " + this.lvt[n4].type + " range " + n5 + " - " + n6 + " slot " + n9);
                }
                ++n4;
            }
        } else if ((n2 & 0x10) != 0 && string.equals("LineNumberTable")) {
            int n11 = dataInputStream.readUnsignedShort();
            if (n != 2 + n11 * 4) {
                GlobalOptions.err.println("Illegal LineNumberTable, ignoring it");
                return;
            }
            this.lnt = new LineNumber[n11];
            int n12 = 0;
            while (n12 < n11) {
                this.lnt[n12] = new LineNumber();
                int n13 = dataInputStream.readUnsignedShort();
                Instruction instruction = this.instrs[n13];
                if (instruction == null) {
                    GlobalOptions.err.println("Illegal entry, ignoring LineNumberTable table");
                    this.lnt = null;
                    return;
                }
                this.lnt[n12].start = instruction;
                this.lnt[n12].linenr = dataInputStream.readUnsignedShort();
                ++n12;
            }
        } else {
            super.readAttribute(string, n, constantPool, dataInputStream, n2);
        }
    }

    public void read(ConstantPool constantPool, DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        Instruction instruction;
        int n3;
        this.maxStack = dataInputStream.readUnsignedShort();
        this.maxLocals = dataInputStream.readUnsignedShort();
        BytecodeInfo bytecodeInfo = this;
        if (bytecodeInfo == null) {
            throw null;
        }
        this.instructions = bytecodeInfo.new InstructionList();
        int n4 = dataInputStream.readInt();
        this.instrs = new Instruction[n4];
        int[][] nArray = new int[n4][];
        int n5 = 0;
        while (n5 < n4) {
            n3 = dataInputStream.readUnsignedByte();
            if ((GlobalOptions.debuggingFlags & 1) != 0 && (GlobalOptions.debuggingFlags & 1) != 0) {
                GlobalOptions.err.print(n5 + ": " + Opcodes.opcodeString[n3]);
            }
            block0 : switch (n3) {
                case 196: {
                    int n6 = dataInputStream.readUnsignedByte();
                    switch (n6) {
                        case 21: 
                        case 23: 
                        case 25: 
                        case 54: 
                        case 56: 
                        case 58: {
                            int n7 = dataInputStream.readUnsignedShort();
                            if (n7 >= this.maxLocals) {
                                throw new ClassFormatError("Invalid local slot " + n7);
                            }
                            instruction = new Instruction(n6);
                            instruction.setLocalSlot(n7);
                            n2 = 4;
                            if ((GlobalOptions.debuggingFlags & 1) == 0) break block0;
                            GlobalOptions.err.print(" " + Opcodes.opcodeString[n6] + " " + n7);
                            break block0;
                        }
                        case 22: 
                        case 24: 
                        case 55: 
                        case 57: {
                            int n7 = dataInputStream.readUnsignedShort();
                            if (n7 >= this.maxLocals - 1) {
                                throw new ClassFormatError("Invalid local slot " + n7);
                            }
                            instruction = new Instruction(n6);
                            instruction.setLocalSlot(n7);
                            n2 = 4;
                            if ((GlobalOptions.debuggingFlags & 1) == 0) break block0;
                            GlobalOptions.err.print(" " + Opcodes.opcodeString[n6] + " " + n7);
                            break block0;
                        }
                        case 169: {
                            int n7 = dataInputStream.readUnsignedShort();
                            if (n7 >= this.maxLocals) {
                                throw new ClassFormatError("Invalid local slot " + n7);
                            }
                            instruction = new Instruction(n6);
                            instruction.setLocalSlot(n7);
                            n2 = 4;
                            if ((GlobalOptions.debuggingFlags & 1) == 0) break block0;
                            GlobalOptions.err.print(" ret " + n7);
                            break block0;
                        }
                        case 132: {
                            int n7 = dataInputStream.readUnsignedShort();
                            if (n7 >= this.maxLocals) {
                                throw new ClassFormatError("Invalid local slot " + n7);
                            }
                            instruction = new Instruction(n6);
                            instruction.setLocalSlot(n7);
                            instruction.setIncrement(dataInputStream.readShort());
                            n2 = 6;
                            if ((GlobalOptions.debuggingFlags & 1) == 0) break block0;
                            GlobalOptions.err.print(" iinc " + n7 + " " + instruction.getIncrement());
                            break block0;
                        }
                        default: {
                            throw new ClassFormatError("Invalid wide opcode " + n6);
                        }
                    }
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int n8 = n3 - 26 & 3;
                    if (n8 >= this.maxLocals) {
                        throw new ClassFormatError("Invalid local slot " + n8);
                    }
                    instruction = new Instruction(21 + (n3 - 26) / 4);
                    instruction.setLocalSlot(n8);
                    n2 = 1;
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int n9 = n3 - 59 & 3;
                    if (n9 >= this.maxLocals) {
                        throw new ClassFormatError("Invalid local slot " + n9);
                    }
                    instruction = new Instruction(54 + (n3 - 59) / 4);
                    instruction.setLocalSlot(n9);
                    n2 = 1;
                    break;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    int n10 = n3 - 59 & 3;
                    if (n10 >= this.maxLocals - 1) {
                        throw new ClassFormatError("Invalid local slot " + n10);
                    }
                    instruction = new Instruction(54 + (n3 - 59) / 4);
                    instruction.setLocalSlot(n10);
                    n2 = 1;
                    break;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    int n11 = dataInputStream.readUnsignedByte();
                    if (n11 >= this.maxLocals) {
                        throw new ClassFormatError("Invalid local slot " + n11);
                    }
                    instruction = new Instruction(n3);
                    instruction.setLocalSlot(n11);
                    n2 = 2;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + n11);
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    int n12 = dataInputStream.readUnsignedByte();
                    if (n12 >= this.maxLocals - 1) {
                        throw new ClassFormatError("Invalid local slot " + n12);
                    }
                    instruction = new Instruction(n3);
                    instruction.setLocalSlot(n12);
                    n2 = 2;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + n12);
                    break;
                }
                case 169: {
                    int n13 = dataInputStream.readUnsignedByte();
                    if (n13 >= this.maxLocals) {
                        throw new ClassFormatError("Invalid local slot " + n13);
                    }
                    instruction = new Instruction(n3);
                    instruction.setLocalSlot(n13);
                    n2 = 2;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + n13);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: {
                    instruction = new Instruction(18);
                    instruction.setConstant(constants[n3 - 1]);
                    n2 = 1;
                    break;
                }
                case 9: 
                case 10: 
                case 14: 
                case 15: {
                    instruction = new Instruction(20);
                    instruction.setConstant(constants[n3 - 1]);
                    n2 = 1;
                    break;
                }
                case 16: {
                    instruction = new Instruction(18);
                    instruction.setConstant(new Integer(dataInputStream.readByte()));
                    n2 = 2;
                    break;
                }
                case 17: {
                    instruction = new Instruction(18);
                    instruction.setConstant(new Integer(dataInputStream.readShort()));
                    n2 = 3;
                    break;
                }
                case 18: {
                    int n14 = dataInputStream.readUnsignedByte();
                    int n15 = constantPool.getTag(n14);
                    if (n15 != 8 && n15 != 3 && n15 != 4) {
                        throw new ClassFormatException("wrong constant tag: " + n15);
                    }
                    instruction = new Instruction(n3);
                    instruction.setConstant(constantPool.getConstant(n14));
                    n2 = 2;
                    break;
                }
                case 19: {
                    int n16 = dataInputStream.readUnsignedShort();
                    int n17 = constantPool.getTag(n16);
                    if (n17 != 8 && n17 != 3 && n17 != 4) {
                        throw new ClassFormatException("wrong constant tag: " + n17);
                    }
                    instruction = new Instruction(18);
                    instruction.setConstant(constantPool.getConstant(n16));
                    n2 = 3;
                    break;
                }
                case 20: {
                    int n18 = dataInputStream.readUnsignedShort();
                    int n19 = constantPool.getTag(n18);
                    if (n19 != 5 && n19 != 6) {
                        throw new ClassFormatException("wrong constant tag: " + n19);
                    }
                    instruction = new Instruction(n3);
                    instruction.setConstant(constantPool.getConstant(n18));
                    n2 = 3;
                    break;
                }
                case 132: {
                    int n20 = dataInputStream.readUnsignedByte();
                    if (n20 >= this.maxLocals) {
                        throw new ClassFormatError("Invalid local slot " + n20);
                    }
                    instruction = new Instruction(n3);
                    instruction.setLocalSlot(n20);
                    instruction.setIncrement(dataInputStream.readByte());
                    n2 = 3;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + n20 + " " + instruction.getIncrement());
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    instruction = new Instruction(n3);
                    n2 = 3;
                    nArray[n5] = new int[]{n5 + dataInputStream.readShort()};
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + nArray[n5][0]);
                    break;
                }
                case 200: 
                case 201: {
                    instruction = new Instruction(n3 - 33);
                    n2 = 5;
                    nArray[n5] = new int[]{n5 + dataInputStream.readInt()};
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + nArray[n5][0]);
                    break;
                }
                case 170: {
                    n2 = 3 - n5 % 4;
                    dataInputStream.readFully(new byte[n2]);
                    int n21 = dataInputStream.readInt();
                    int n22 = dataInputStream.readInt();
                    n = dataInputStream.readInt();
                    int[] nArray2 = new int[n - n22 + 1];
                    int n23 = 0;
                    int n24 = 0;
                    while (n24 < nArray2.length) {
                        nArray2[n24] = dataInputStream.readInt();
                        if (nArray2[n24] != n21) {
                            ++n23;
                        }
                        ++n24;
                    }
                    instruction = new Instruction(171);
                    nArray[n5] = new int[n23 + 1];
                    int[] nArray3 = new int[n23];
                    int n25 = 0;
                    int n26 = 0;
                    while (n26 < nArray2.length) {
                        if (nArray2[n26] != n21) {
                            nArray3[n25] = n26 + n22;
                            nArray[n5][n25] = n5 + nArray2[n26];
                            ++n25;
                        }
                        ++n26;
                    }
                    nArray[n5][n23] = n5 + n21;
                    instruction.setValues(nArray3);
                    n2 += 13 + 4 * (n - n22 + 1);
                    break;
                }
                case 171: {
                    n2 = 3 - n5 % 4;
                    dataInputStream.readFully(new byte[n2]);
                    int n27 = dataInputStream.readInt();
                    int n28 = dataInputStream.readInt();
                    instruction = new Instruction(n3);
                    nArray[n5] = new int[n28 + 1];
                    int[] nArray4 = new int[n28];
                    int n29 = 0;
                    while (n29 < n28) {
                        nArray4[n29] = dataInputStream.readInt();
                        if (n29 > 0 && nArray4[n29 - 1] >= nArray4[n29]) {
                            throw new ClassFormatException("lookupswitch not sorted");
                        }
                        nArray[n5][n29] = n5 + dataInputStream.readInt();
                        ++n29;
                    }
                    nArray[n5][n28] = n5 + n27;
                    instruction.setValues(nArray4);
                    n2 += 9 + 8 * n28;
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    Reference reference;
                    int n30 = dataInputStream.readUnsignedShort();
                    int n31 = constantPool.getTag(n30);
                    if (n3 < 182) {
                        if (n31 != 9) {
                            throw new ClassFormatException("field tag mismatch: " + n31);
                        }
                    } else if (n31 != 10) {
                        throw new ClassFormatException("method tag mismatch: " + n31);
                    }
                    if (!((reference = constantPool.getRef(n30)).getName().charAt(0) != '<' || reference.getName().equals("<init>") && n3 == 183)) {
                        throw new ClassFormatException("Illegal call of special method/field " + reference);
                    }
                    instruction = new Instruction(n3);
                    instruction.setReference(reference);
                    n2 = 3;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + reference);
                    break;
                }
                case 185: {
                    int n32 = dataInputStream.readUnsignedShort();
                    int n33 = constantPool.getTag(n32);
                    if (n33 != 11) {
                        throw new ClassFormatException("interface tag mismatch: " + n33);
                    }
                    Reference reference = constantPool.getRef(n32);
                    if (reference.getName().charAt(0) == '<') {
                        throw new ClassFormatException("Illegal call of special method " + reference);
                    }
                    int n34 = dataInputStream.readUnsignedByte();
                    if (TypeSignature.getArgumentSize(reference.getType()) != n34 - 1) {
                        throw new ClassFormatException("Interface nargs mismatch: " + reference + " vs. " + n34);
                    }
                    if (dataInputStream.readUnsignedByte() != 0) {
                        throw new ClassFormatException("Interface reserved param not zero");
                    }
                    instruction = new Instruction(n3);
                    instruction.setReference(reference);
                    n2 = 5;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + reference);
                    break;
                }
                case 187: 
                case 192: 
                case 193: {
                    String string = constantPool.getClassType(dataInputStream.readUnsignedShort());
                    if (n3 == 187 && string.charAt(0) == '[') {
                        throw new ClassFormatException("Can't create array with opc_new");
                    }
                    instruction = new Instruction(n3);
                    instruction.setClazzType(string);
                    n2 = 3;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + string);
                    break;
                }
                case 197: {
                    String string = constantPool.getClassType(dataInputStream.readUnsignedShort());
                    int n35 = dataInputStream.readUnsignedByte();
                    if (n35 == 0) {
                        throw new ClassFormatException("multianewarray dimension is 0.");
                    }
                    n = 0;
                    while (n < n35) {
                        if (string.charAt(n) != '[') {
                            throw new ClassFormatException("multianewarray called for non array:" + string);
                        }
                        ++n;
                    }
                    instruction = new Instruction(n3);
                    instruction.setClazzType(string);
                    instruction.setDimensions(n35);
                    n2 = 4;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + string + " " + n35);
                    break;
                }
                case 189: {
                    String string = constantPool.getClassType(dataInputStream.readUnsignedShort());
                    instruction = new Instruction(197);
                    instruction.setClazzType(("[" + string).intern());
                    instruction.setDimensions(1);
                    n2 = 3;
                    if ((GlobalOptions.debuggingFlags & 1) == 0) break;
                    GlobalOptions.err.print(" " + string);
                    break;
                }
                case 188: {
                    char c = "ZCFDBSIJ".charAt(dataInputStream.readUnsignedByte() - 4);
                    String string = new String(new char[]{'[', c});
                    if ((GlobalOptions.debuggingFlags & 1) != 0) {
                        GlobalOptions.err.print(" " + string);
                    }
                    instruction = new Instruction(197);
                    instruction.setClazzType(string);
                    instruction.setDimensions(1);
                    n2 = 2;
                    break;
                }
                case 0: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    instruction = new Instruction(n3);
                    n2 = 1;
                    break;
                }
                default: {
                    throw new ClassFormatError("Invalid opcode " + n3);
                }
            }
            if ((GlobalOptions.debuggingFlags & 1) != 0) {
                GlobalOptions.err.println();
            }
            this.instrs[n5] = instruction;
            this.instructions.add(instruction);
            this.instructions.setLastAddr(n5 += n2);
        }
        if (n5 != n4) {
            throw new ClassFormatError("last instruction too long");
        }
        Iterator iterator = this.instructions.iterator();
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            n2 = instruction.getAddr();
            if (nArray[n2] == null) continue;
            n3 = nArray[n2].length;
            Instruction[] instructionArray = new Instruction[n3];
            int n36 = 0;
            while (n36 < n3) {
                n = nArray[n2][n36];
                if (n < 0 || n > n4 || this.instrs[n] == null) {
                    throw new ClassFormatException("Illegal jump target at " + this + "@" + n2);
                }
                instructionArray[n36] = this.instrs[n];
                ++n36;
            }
            instruction.setSuccs(instructionArray);
        }
        nArray = null;
        int n37 = dataInputStream.readUnsignedShort();
        this.exceptionHandlers = new Handler[n37];
        int n38 = 0;
        while (n38 < n37) {
            this.exceptionHandlers[n38] = new Handler();
            this.exceptionHandlers[n38].start = this.instrs[dataInputStream.readUnsignedShort()];
            this.exceptionHandlers[n38].end = this.instrs[dataInputStream.readUnsignedShort()].getPrevByAddr();
            this.exceptionHandlers[n38].catcher = this.instrs[dataInputStream.readUnsignedShort()];
            n2 = dataInputStream.readUnsignedShort();
            String string = this.exceptionHandlers[n38].type = n2 == 0 ? null : constantPool.getClassName(n2);
            if (this.exceptionHandlers[n38].catcher.getOpcode() == 191) {
                --n37;
                --n38;
            } else if (this.exceptionHandlers[n38].start.getAddr() <= this.exceptionHandlers[n38].catcher.getAddr() && this.exceptionHandlers[n38].end.getAddr() >= this.exceptionHandlers[n38].catcher.getAddr()) {
                if (this.exceptionHandlers[n38].start == this.exceptionHandlers[n38].catcher) {
                    --n37;
                    --n38;
                } else {
                    this.exceptionHandlers[n38].end = this.exceptionHandlers[n38].catcher.getPrevByAddr();
                }
            }
            ++n38;
        }
        if (n37 < this.exceptionHandlers.length) {
            Handler[] handlerArray = new Handler[n37];
            System.arraycopy(this.exceptionHandlers, 0, handlerArray, 0, n37);
            this.exceptionHandlers = handlerArray;
        }
        this.readAttributes(constantPool, dataInputStream, 255);
        this.instrs = null;
    }

    public void dumpCode(PrintWriter printWriter) {
        Iterator iterator = this.instructions.iterator();
        while (iterator.hasNext()) {
            int n;
            Instruction instruction = (Instruction)iterator.next();
            printWriter.println(instruction.getDescription() + " " + Integer.toHexString(this.hashCode()));
            Instruction[] instructionArray = instruction.getSuccs();
            if (instructionArray != null) {
                printWriter.print("\tsuccs: " + instructionArray[0]);
                n = 1;
                while (n < instructionArray.length) {
                    printWriter.print(", " + instructionArray[n]);
                    ++n;
                }
                printWriter.println();
            }
            if (instruction.getPreds() == null) continue;
            printWriter.print("\tpreds: " + instruction.getPreds()[0]);
            n = 1;
            while (n < instruction.getPreds().length) {
                printWriter.print(", " + instruction.getPreds()[n]);
                ++n;
            }
            printWriter.println();
        }
        int n = 0;
        while (n < this.exceptionHandlers.length) {
            printWriter.println("catch " + this.exceptionHandlers[n].type + " from " + this.exceptionHandlers[n].start + " to " + this.exceptionHandlers[n].end + " catcher " + this.exceptionHandlers[n].catcher);
            ++n;
        }
    }

    public void reserveSmallConstants(GrowableConstantPool growableConstantPool) {
        Iterator iterator = this.instructions.iterator();
        block0: while (iterator.hasNext()) {
            Object object;
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.getOpcode() != 18 || (object = instruction.getConstant()) == null) continue;
            int n = 1;
            while (n < constants.length) {
                if (object.equals(constants[n])) continue block0;
                ++n;
            }
            if (object instanceof Integer && (n = ((Integer)object).intValue()) >= Short.MIN_VALUE && n <= Short.MAX_VALUE) continue;
            growableConstantPool.reserveConstant(object);
        }
    }

    private void calculateMaxStack() {
        this.maxStack = 0;
        int[] nArray = new int[this.instructions.getCodeLength()];
        int[] nArray2 = new int[2];
        Stack<Object> stack = new Stack<Object>();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -1;
            ++n;
        }
        nArray[0] = 0;
        stack.push(this.instructions.get(0));
        while (!stack.isEmpty()) {
            int n2;
            Instruction instruction = (Instruction)stack.pop();
            Instruction instruction2 = instruction.getNextByAddr();
            Instruction[] instructionArray = instruction.getSuccs();
            int n3 = instruction.getAddr();
            instruction.getStackPopPush(nArray2);
            int n4 = nArray[n3] - nArray2[0] + nArray2[1];
            if (this.maxStack < n4) {
                this.maxStack = n4;
            }
            if (instruction.getOpcode() == 168) {
                if (nArray[instruction2.getAddr()] == -1) {
                    nArray[instruction2.getAddr()] = n4 - 1;
                    stack.push(instruction2);
                }
                if (nArray[instructionArray[0].getAddr()] == -1) {
                    nArray[instructionArray[0].getAddr()] = n4;
                    stack.push(instructionArray[0]);
                }
            } else {
                if (instructionArray != null) {
                    n2 = 0;
                    while (n2 < instructionArray.length) {
                        if (nArray[instructionArray[n2].getAddr()] == -1) {
                            nArray[instructionArray[n2].getAddr()] = n4;
                            stack.push(instructionArray[n2]);
                        }
                        ++n2;
                    }
                }
                if (!instruction.doesAlwaysJump() && nArray[instruction2.getAddr()] == -1) {
                    nArray[instruction2.getAddr()] = n4;
                    stack.push(instruction2);
                }
            }
            n2 = 0;
            while (n2 < this.exceptionHandlers.length) {
                int n5;
                if (this.exceptionHandlers[n2].start.compareTo(instruction) <= 0 && this.exceptionHandlers[n2].end.compareTo(instruction) >= 0 && nArray[n5 = this.exceptionHandlers[n2].catcher.getAddr()] == -1) {
                    nArray[n5] = 1;
                    stack.push(this.exceptionHandlers[n2].catcher);
                }
                ++n2;
            }
        }
    }

    public void prepareWriting(GrowableConstantPool growableConstantPool) {
        int n = 0;
        this.maxLocals = (this.methodInfo.isStatic() ? 0 : 1) + TypeSignature.getArgumentSize(this.methodInfo.getType());
        Iterator iterator = this.instructions.iterator();
        while (iterator.hasNext()) {
            int n2;
            Instruction instruction = (Instruction)iterator.next();
            int n3 = instruction.getOpcode();
            instruction.setAddr(n);
            block1 : switch (n3) {
                case 18: 
                case 20: {
                    Object object = instruction.getConstant();
                    if (object == null) {
                        n2 = 1;
                        break;
                    }
                    int n4 = 1;
                    while (n4 < constants.length) {
                        if (object.equals(constants[n4])) {
                            n2 = 1;
                            break block1;
                        }
                        ++n4;
                    }
                    if (n3 == 20) {
                        growableConstantPool.putLongConstant(object);
                        n2 = 3;
                        break;
                    }
                    if (object instanceof Integer) {
                        n4 = (Integer)object;
                        if (n4 >= -128 && n4 <= 127) {
                            n2 = 2;
                            break;
                        }
                        if (n4 >= Short.MIN_VALUE && n4 <= Short.MAX_VALUE) {
                            n2 = 3;
                            break;
                        }
                    }
                    if (growableConstantPool.putConstant(object) < 256) {
                        n2 = 2;
                        break;
                    }
                    n2 = 3;
                    break;
                }
                case 132: {
                    int n5 = instruction.getLocalSlot();
                    int n4 = instruction.getIncrement();
                    n2 = n5 < 256 && n4 >= -128 && n4 <= 127 ? 3 : 6;
                    if (n5 < this.maxLocals) break;
                    this.maxLocals = n5 + 1;
                    break;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    int n6 = instruction.getLocalSlot();
                    n2 = n6 < 4 ? 1 : (n6 < 256 ? 2 : 4);
                    if (n6 < this.maxLocals) break;
                    this.maxLocals = n6 + 1;
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    int n7 = instruction.getLocalSlot();
                    n2 = n7 < 4 ? 1 : (n7 < 256 ? 2 : 4);
                    if (n7 + 1 < this.maxLocals) break;
                    this.maxLocals = n7 + 2;
                    break;
                }
                case 169: {
                    int n8 = instruction.getLocalSlot();
                    n2 = n8 < 256 ? 2 : 4;
                    if (n8 < this.maxLocals) break;
                    this.maxLocals = n8 + 1;
                    break;
                }
                case 171: {
                    int n9;
                    n2 = 3 - n % 4;
                    int[] nArray = instruction.getValues();
                    int n4 = nArray.length;
                    if (n4 > 0 && 4 + (n9 = nArray[n4 - 1] - nArray[0] + 1) * 4 < 8 * n4) {
                        n2 += 13 + 4 * n9;
                        break;
                    }
                    n2 += 9 + 8 * n4;
                    break;
                }
                case 167: 
                case 168: {
                    int n10 = instruction.getSingleSucc().getAddr() - instruction.getAddr();
                    if (n10 < Short.MIN_VALUE || n10 > Short.MAX_VALUE) {
                        n2 = 5;
                        break;
                    }
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    n2 = 3;
                    break;
                }
                case 197: {
                    if (instruction.getDimensions() == 1) {
                        String string = instruction.getClazzType().substring(1);
                        if ("ZCFDBSIJ".indexOf(string.charAt(0)) != -1) {
                            n2 = 2;
                            break;
                        }
                        growableConstantPool.putClassType(string);
                        n2 = 3;
                        break;
                    }
                    growableConstantPool.putClassType(instruction.getClazzType());
                    n2 = 4;
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    growableConstantPool.putRef(9, instruction.getReference());
                    n2 = 3;
                    break;
                }
                case 182: 
                case 183: 
                case 184: {
                    growableConstantPool.putRef(10, instruction.getReference());
                    n2 = 3;
                    break;
                }
                case 185: {
                    growableConstantPool.putRef(11, instruction.getReference());
                    n2 = 5;
                    break;
                }
                case 187: 
                case 192: 
                case 193: {
                    growableConstantPool.putClassType(instruction.getClazzType());
                    n2 = 3;
                    break;
                }
                case 0: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw new ClassFormatError("Invalid opcode " + n3);
                }
            }
            n += n2;
        }
        this.instructions.setLastAddr(n);
        try {
            this.calculateMaxStack();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            this.dumpCode(GlobalOptions.err);
        }
        int n11 = 0;
        while (n11 < this.exceptionHandlers.length) {
            if (this.exceptionHandlers[n11].type != null) {
                growableConstantPool.putClassName(this.exceptionHandlers[n11].type);
            }
            ++n11;
        }
        if (this.lvt != null) {
            growableConstantPool.putUTF8("LocalVariableTable");
            n11 = 0;
            while (n11 < this.lvt.length) {
                growableConstantPool.putUTF8(this.lvt[n11].name);
                growableConstantPool.putUTF8(this.lvt[n11].type);
                ++n11;
            }
        }
        if (this.lnt != null) {
            growableConstantPool.putUTF8("LineNumberTable");
        }
        this.prepareAttributes(growableConstantPool);
    }

    protected int getKnownAttributeCount() {
        int n = 0;
        if (this.lvt != null) {
            ++n;
        }
        if (this.lnt != null) {
            ++n;
        }
        return n;
    }

    public void writeKnownAttributes(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        int n3;
        if (this.lvt != null) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("LocalVariableTable"));
            n3 = this.lvt.length;
            n2 = 2 + 10 * n3;
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeShort(n3);
            n = 0;
            while (n < n3) {
                dataOutputStream.writeShort(this.lvt[n].start.getAddr());
                dataOutputStream.writeShort(this.lvt[n].end.getAddr() + this.lvt[n].end.getLength() - this.lvt[n].start.getAddr());
                dataOutputStream.writeShort(growableConstantPool.putUTF8(this.lvt[n].name));
                dataOutputStream.writeShort(growableConstantPool.putUTF8(this.lvt[n].type));
                dataOutputStream.writeShort(this.lvt[n].slot);
                ++n;
            }
        }
        if (this.lnt != null) {
            dataOutputStream.writeShort(growableConstantPool.putUTF8("LineNumberTable"));
            n3 = this.lnt.length;
            n2 = 2 + 4 * n3;
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeShort(n3);
            n = 0;
            while (n < n3) {
                dataOutputStream.writeShort(this.lnt[n].start.getAddr());
                dataOutputStream.writeShort(this.lnt[n].linenr);
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void write(GrowableConstantPool growableConstantPool, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        dataOutputStream.writeInt(this.instructions.getCodeLength());
        Iterator iterator = this.instructions.iterator();
        block14: while (iterator.hasNext()) {
            int n;
            int n2;
            int n3;
            int n4;
            int[] nArray;
            Instruction instruction = (Instruction)iterator.next();
            int n5 = instruction.getOpcode();
            switch (n5) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    int n6 = instruction.getLocalSlot();
                    if (n6 < 4) {
                        if (n5 < 54) {
                            dataOutputStream.writeByte(26 + 4 * (n5 - 21) + n6);
                            continue block14;
                        }
                        dataOutputStream.writeByte(59 + 4 * (n5 - 54) + n6);
                        continue block14;
                    }
                    if (n6 < 256) {
                        dataOutputStream.writeByte(n5);
                        dataOutputStream.writeByte(n6);
                        continue block14;
                    }
                    dataOutputStream.writeByte(196);
                    dataOutputStream.writeByte(n5);
                    dataOutputStream.writeShort(n6);
                    continue block14;
                }
                case 169: {
                    int n7 = instruction.getLocalSlot();
                    if (n7 < 256) {
                        dataOutputStream.writeByte(n5);
                        dataOutputStream.writeByte(n7);
                        continue block14;
                    }
                    dataOutputStream.writeByte(196);
                    dataOutputStream.writeByte(n5);
                    dataOutputStream.writeShort(n7);
                    continue block14;
                }
                case 18: 
                case 20: {
                    Object object = instruction.getConstant();
                    if (object == null) {
                        dataOutputStream.writeByte(1);
                        continue block14;
                    }
                    int n8 = 1;
                    while (true) {
                        if (n8 >= constants.length) {
                            if (n5 != 20) break;
                            dataOutputStream.writeByte(n5);
                            dataOutputStream.writeShort(growableConstantPool.putLongConstant(object));
                            continue block14;
                        }
                        if (object.equals(constants[n8])) {
                            dataOutputStream.writeByte(1 + n8);
                            continue block14;
                        }
                        ++n8;
                    }
                    if (object instanceof Integer) {
                        n8 = (Integer)object;
                        if (n8 >= -128 && n8 <= 127) {
                            dataOutputStream.writeByte(16);
                            dataOutputStream.writeByte((Integer)object);
                            continue block14;
                        }
                        if (n8 >= Short.MIN_VALUE && n8 <= Short.MAX_VALUE) {
                            dataOutputStream.writeByte(17);
                            dataOutputStream.writeShort((Integer)object);
                            continue block14;
                        }
                    }
                    if (instruction.getLength() == 2) {
                        dataOutputStream.writeByte(18);
                        dataOutputStream.writeByte(growableConstantPool.putConstant(object));
                        continue block14;
                    }
                    dataOutputStream.writeByte(19);
                    dataOutputStream.writeShort(growableConstantPool.putConstant(object));
                    continue block14;
                }
                case 132: {
                    int n9 = instruction.getLocalSlot();
                    int n10 = instruction.getIncrement();
                    if (instruction.getLength() == 3) {
                        dataOutputStream.writeByte(n5);
                        dataOutputStream.writeByte(n9);
                        dataOutputStream.writeByte(n10);
                        continue block14;
                    }
                    dataOutputStream.writeByte(196);
                    dataOutputStream.writeByte(n5);
                    dataOutputStream.writeShort(n9);
                    dataOutputStream.writeShort(n10);
                    continue block14;
                }
                case 167: 
                case 168: {
                    if (instruction.getLength() == 5) {
                        dataOutputStream.writeByte(n5 + 33);
                        dataOutputStream.writeInt(instruction.getSingleSucc().getAddr() - instruction.getAddr());
                        continue block14;
                    }
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    dataOutputStream.writeByte(n5);
                    dataOutputStream.writeShort(instruction.getSingleSucc().getAddr() - instruction.getAddr());
                    continue block14;
                }
                case 171: {
                    int n11;
                    int n12 = 3 - instruction.getAddr() % 4;
                    nArray = instruction.getValues();
                    n4 = nArray.length;
                    n3 = instruction.getSuccs()[n4].getAddr() - instruction.getAddr();
                    if (n4 > 0 && 4 + (n11 = nArray[n4 - 1] - nArray[0] + 1) * 4 < 8 * n4) {
                        dataOutputStream.writeByte(170);
                        dataOutputStream.write(new byte[n12]);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.writeInt(nArray[0]);
                        dataOutputStream.writeInt(nArray[n4 - 1]);
                        n2 = nArray[0];
                        n = 0;
                    } else {
                        dataOutputStream.writeByte(171);
                        dataOutputStream.write(new byte[n12]);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.writeInt(n4);
                        n11 = 0;
                        while (n11 < n4) {
                            dataOutputStream.writeInt(nArray[n11]);
                            dataOutputStream.writeInt(instruction.getSuccs()[n11].getAddr() - instruction.getAddr());
                            ++n11;
                        }
                        continue block14;
                    }
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    dataOutputStream.writeByte(n5);
                    dataOutputStream.writeShort(growableConstantPool.putRef(9, instruction.getReference()));
                    continue block14;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Reference reference = instruction.getReference();
                    dataOutputStream.writeByte(n5);
                    if (n5 == 185) {
                        dataOutputStream.writeShort(growableConstantPool.putRef(11, reference));
                        dataOutputStream.writeByte(TypeSignature.getArgumentSize(reference.getType()) + 1);
                        dataOutputStream.writeByte(0);
                        continue block14;
                    }
                    dataOutputStream.writeShort(growableConstantPool.putRef(10, reference));
                    continue block14;
                }
                case 187: 
                case 192: 
                case 193: {
                    dataOutputStream.writeByte(n5);
                    dataOutputStream.writeShort(growableConstantPool.putClassType(instruction.getClazzType()));
                    continue block14;
                }
                case 197: {
                    if (instruction.getDimensions() == 1) {
                        String string = instruction.getClazzType().substring(1);
                        int n13 = "ZCFDBSIJ".indexOf(string.charAt(0));
                        if (n13 != -1) {
                            dataOutputStream.writeByte(188);
                            dataOutputStream.writeByte(n13 + 4);
                            continue block14;
                        }
                        dataOutputStream.writeByte(189);
                        dataOutputStream.writeShort(growableConstantPool.putClassType(string));
                        continue block14;
                    }
                    dataOutputStream.writeByte(n5);
                    dataOutputStream.writeShort(growableConstantPool.putClassType(instruction.getClazzType()));
                    dataOutputStream.writeByte(instruction.getDimensions());
                    continue block14;
                }
                case 0: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 190: 
                case 191: 
                case 194: 
                case 195: {
                    dataOutputStream.writeByte(n5);
                    continue block14;
                }
                default: {
                    throw new ClassFormatError("Invalid opcode " + n5);
                }
            }
            {
                dataOutputStream.writeInt(n3);
                do {
                    if (n2++ < nArray[n]) continue block17;
                    dataOutputStream.writeInt(instruction.getSuccs()[n].getAddr() - instruction.getAddr());
                    ++n;
                } while (n < n4);
            }
        }
        dataOutputStream.writeShort(this.exceptionHandlers.length);
        int n = 0;
        while (n < this.exceptionHandlers.length) {
            dataOutputStream.writeShort(this.exceptionHandlers[n].start.getAddr());
            dataOutputStream.writeShort(this.exceptionHandlers[n].end.getNextByAddr().getAddr());
            dataOutputStream.writeShort(this.exceptionHandlers[n].catcher.getAddr());
            dataOutputStream.writeShort(this.exceptionHandlers[n].type == null ? 0 : growableConstantPool.putClassName(this.exceptionHandlers[n].type));
            ++n;
        }
        this.writeAttributes(growableConstantPool, dataOutputStream);
    }

    public void dropInfo(int n) {
        if ((n & 0x10) != 0) {
            this.lvt = null;
            this.lnt = null;
        }
        super.dropInfo(n);
    }

    public int getSize() {
        int n = 0;
        if (this.lvt != null) {
            n += 8 + this.lvt.length * 10;
        }
        if (this.lnt != null) {
            n += 8 + this.lnt.length * 4;
        }
        return 10 + this.instructions.getCodeLength() + this.exceptionHandlers.length * 8 + this.getAttributeSize() + n;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public List getInstructions() {
        return this.instructions;
    }

    public Handler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public LocalVariableInfo[] getLocalVariableTable() {
        return this.lvt;
    }

    public LineNumber[] getLineNumberTable() {
        return this.lnt;
    }

    public void setExceptionHandlers(Handler[] handlerArray) {
        this.exceptionHandlers = handlerArray;
    }

    public void setLocalVariableTable(LocalVariableInfo[] localVariableInfoArray) {
        this.lvt = localVariableInfoArray;
    }

    public void setLineNumberTable(LineNumber[] lineNumberArray) {
        this.lnt = lineNumberArray;
    }

    public String toString() {
        return "Bytecode " + this.methodInfo;
    }

    public BytecodeInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }

    private class InstructionList
    extends AbstractSequentialList {
        Instruction borderInstr;
        int instructionCount = 0;

        public int size() {
            return this.instructionCount;
        }

        Instruction get0(int n) {
            Instruction instruction = this.borderInstr;
            if (n < this.instructionCount / 2) {
                int n2 = 0;
                while (n2 <= n) {
                    instruction = instruction.nextByAddr;
                    ++n2;
                }
            } else {
                int n3 = this.instructionCount;
                while (n3 > n) {
                    instruction = instruction.prevByAddr;
                    --n3;
                }
            }
            return instruction;
        }

        public Object get(int n) {
            if (n < 0 || n >= this.instructionCount) {
                throw new IllegalArgumentException();
            }
            return this.get0(n);
        }

        public boolean add(Object object) {
            ++this.instructionCount;
            this.borderInstr.prevByAddr.appendInstruction((Instruction)object, BytecodeInfo.this);
            return true;
        }

        public ListIterator listIterator(int n) {
            if (n < 0 || n > this.instructionCount) {
                throw new IllegalArgumentException();
            }
            InstructionList instructionList = this;
            if (instructionList == null) {
                throw null;
            }
            return new ListIterator(instructionList, n){
                Instruction instr;
                Instruction toRemove;
                int index;
                private final /* synthetic */ InstructionList this$0;
                private final /* synthetic */ int val$startIndex;
                private final /* synthetic */ BytecodeInfo this$1;

                public boolean hasNext() {
                    return this.index < this.this$0.instructionCount;
                }

                public boolean hasPrevious() {
                    return this.index > 0;
                }

                public Object next() {
                    if (this.index >= this.this$0.instructionCount) {
                        throw new NoSuchElementException();
                    }
                    ++this.index;
                    this.toRemove = this.instr;
                    this.instr = this.instr.nextByAddr;
                    return this.toRemove;
                }

                public Object previous() {
                    if (this.index == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.index;
                    this.toRemove = this.instr = this.instr.prevByAddr;
                    return this.toRemove;
                }

                public int nextIndex() {
                    return this.index;
                }

                public int previousIndex() {
                    return this.index - 1;
                }

                public void remove() {
                    if (this.toRemove == null) {
                        throw new IllegalStateException();
                    }
                    --this.this$0.instructionCount;
                    if (this.instr == this.toRemove) {
                        this.instr = this.instr.nextByAddr;
                    } else {
                        --this.index;
                    }
                    this.toRemove.removeInstruction(this.this$1);
                    this.toRemove = null;
                }

                public void add(Object object) {
                    ++this.this$0.instructionCount;
                    ++this.index;
                    this.instr.prevByAddr.appendInstruction((Instruction)object, this.this$1);
                    this.toRemove = null;
                }

                public void set(Object object) {
                    if (this.toRemove == null) {
                        throw new IllegalStateException();
                    }
                    this.toRemove.replaceInstruction((Instruction)object, this.this$1);
                    if (this.instr == this.toRemove) {
                        this.instr = (Instruction)object;
                    }
                    this.toRemove = (Instruction)object;
                }
                {
                    this.val$startIndex = n;
                    this.this$0 = instructionList;
                    this.this$1 = InstructionList.access$0(this.this$0);
                    this.instr = this.this$0.get0(this.val$startIndex);
                    this.toRemove = null;
                    this.index = this.val$startIndex;
                    this.constructor$0(instructionList);
                }

                private final void constructor$0(InstructionList instructionList) {
                }
            };
        }

        void setLastAddr(int n) {
            this.borderInstr.setAddr(n);
        }

        int getCodeLength() {
            return this.borderInstr.getAddr();
        }

        static /* synthetic */ BytecodeInfo access$0(InstructionList instructionList) {
            return instructionList.BytecodeInfo.this;
        }

        InstructionList() {
            this.borderInstr.nextByAddr = this.borderInstr.prevByAddr = (this.borderInstr = new Instruction(254));
        }
    }
}

