/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.util.Set;
import java.util.Stack;
import jode.decompiler.LocalInfo;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CombineableOperator;
import jode.expr.ConstOperator;
import jode.expr.Expression;
import jode.expr.LocalStoreOperator;
import jode.expr.StoreInstruction;
import jode.flow.BreakBlock;
import jode.flow.BreakableBlock;
import jode.flow.ContinueBlock;
import jode.flow.CreateForInitializer;
import jode.flow.FlowBlock;
import jode.flow.InstructionBlock;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;
import jode.util.SimpleSet;

public class LoopBlock
extends StructuredBlock
implements BreakableBlock {
    public static final int WHILE = 0;
    public static final int DOWHILE = 1;
    public static final int FOR = 2;
    public static final int POSSFOR = 3;
    public static final Expression TRUE = new ConstOperator(Boolean.TRUE);
    public static final Expression FALSE = new ConstOperator(Boolean.FALSE);
    static int serialno = 0;
    Expression cond;
    VariableStack condStack;
    InstructionBlock initBlock;
    InstructionBlock incrBlock;
    Expression initInstr;
    Expression incrInstr;
    boolean isDeclaration;
    int type;
    StructuredBlock bodyBlock;
    VariableStack breakedStack;
    VariableStack continueStack;
    boolean mayChangeJump = true;
    String label = null;

    public StructuredBlock getNextBlock(StructuredBlock structuredBlock) {
        return this;
    }

    public FlowBlock getNextFlowBlock(StructuredBlock structuredBlock) {
        return null;
    }

    public void setBody(StructuredBlock structuredBlock) {
        this.bodyBlock = structuredBlock;
        this.bodyBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
    }

    public void setInit(InstructionBlock instructionBlock) {
        if (this.type == 3) {
            this.initBlock = instructionBlock;
        } else if (this.type == 2) {
            this.initInstr = instructionBlock.getInstruction();
            instructionBlock.removeBlock();
        }
    }

    public boolean conditionMatches(CombineableOperator combineableOperator) {
        return this.type == 3 || this.cond.containsMatchingLoad(combineableOperator);
    }

    public Expression getCondition() {
        return this.cond;
    }

    public void setCondition(Expression expression) {
        this.cond = expression;
        if (this.type == 3) {
            if (expression.containsMatchingLoad((CombineableOperator)((Object)this.incrBlock.getInstruction()))) {
                this.type = 2;
                this.incrInstr = this.incrBlock.getInstruction();
                this.incrBlock.removeBlock();
                if (this.initBlock != null && expression.containsMatchingLoad((CombineableOperator)((Object)this.initBlock.getInstruction()))) {
                    this.initInstr = this.initBlock.getInstruction();
                    this.initBlock.removeBlock();
                }
            } else {
                this.type = 0;
            }
            this.incrBlock = null;
            this.initBlock = null;
        }
        this.mayChangeJump = false;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        if (this.bodyBlock != structuredBlock) {
            return false;
        }
        this.bodyBlock = structuredBlock2;
        return true;
    }

    public StructuredBlock[] getSubBlocks() {
        return new StructuredBlock[]{this.bodyBlock};
    }

    public void removeLocallyDeclareable(Set set) {
        StoreInstruction storeInstruction;
        if (this.type == 2 && this.initInstr instanceof StoreInstruction && (storeInstruction = (StoreInstruction)this.initInstr).getLValue() instanceof LocalStoreOperator) {
            LocalInfo localInfo = ((LocalStoreOperator)storeInstruction.getLValue()).getLocalInfo();
            set.remove(localInfo);
        }
    }

    public Set getDeclarables() {
        SimpleSet simpleSet = new SimpleSet();
        if (this.type == 2) {
            this.incrInstr.fillDeclarables(simpleSet);
            if (this.initInstr != null) {
                this.initInstr.fillDeclarables(simpleSet);
            }
        }
        this.cond.fillDeclarables(simpleSet);
        return simpleSet;
    }

    public void checkDeclaration(Set set) {
        StoreInstruction storeInstruction;
        LocalInfo localInfo;
        if (this.initInstr instanceof StoreInstruction && ((StoreInstruction)this.initInstr).getLValue() instanceof LocalStoreOperator && set.contains(localInfo = ((LocalStoreOperator)(storeInstruction = (StoreInstruction)this.initInstr).getLValue()).getLocalInfo())) {
            this.isDeclaration = true;
            set.remove(localInfo);
        }
    }

    public void makeDeclaration(Set set) {
        if (this.type == 2) {
            if (this.initInstr != null) {
                this.initInstr.makeDeclaration(set);
            }
            this.incrInstr.makeDeclaration(set);
        }
        this.cond.makeDeclaration(set);
        super.makeDeclaration(set);
        if (this.type == 2 && this.initInstr != null) {
            this.checkDeclaration(this.declare);
        }
    }

    public void dumpSource(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        super.dumpSource(tabbedPrintWriter);
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        if (this.label != null) {
            tabbedPrintWriter.untab();
            tabbedPrintWriter.println(this.label + ":");
            tabbedPrintWriter.tab();
        }
        boolean bl = this.bodyBlock.needsBraces();
        switch (this.type) {
            case 0: 
            case 3: {
                if (this.cond == TRUE) {
                    tabbedPrintWriter.print("for (;;)");
                    break;
                }
                tabbedPrintWriter.print("while (");
                this.cond.dumpExpression(0, tabbedPrintWriter);
                tabbedPrintWriter.print(")");
                break;
            }
            case 1: {
                tabbedPrintWriter.print("do");
                break;
            }
            case 2: {
                tabbedPrintWriter.print("for (");
                tabbedPrintWriter.startOp(0, 0);
                if (this.initInstr != null) {
                    if (this.isDeclaration) {
                        StoreInstruction storeInstruction = (StoreInstruction)this.initInstr;
                        LocalInfo localInfo = ((LocalStoreOperator)storeInstruction.getLValue()).getLocalInfo();
                        tabbedPrintWriter.startOp(1, 1);
                        localInfo.dumpDeclaration(tabbedPrintWriter);
                        tabbedPrintWriter.breakOp();
                        tabbedPrintWriter.print(" = ");
                        storeInstruction.getSubExpressions()[1].makeInitializer(localInfo.getType());
                        storeInstruction.getSubExpressions()[1].dumpExpression(tabbedPrintWriter, 100);
                        tabbedPrintWriter.endOp();
                    } else {
                        this.initInstr.dumpExpression(1, tabbedPrintWriter);
                    }
                } else {
                    tabbedPrintWriter.print("/**/");
                }
                tabbedPrintWriter.print("; ");
                tabbedPrintWriter.breakOp();
                this.cond.dumpExpression(2, tabbedPrintWriter);
                tabbedPrintWriter.print("; ");
                tabbedPrintWriter.breakOp();
                this.incrInstr.dumpExpression(1, tabbedPrintWriter);
                tabbedPrintWriter.endOp();
                tabbedPrintWriter.print(")");
                break;
            }
        }
        if (bl) {
            tabbedPrintWriter.openBrace();
        } else {
            tabbedPrintWriter.println();
        }
        tabbedPrintWriter.tab();
        this.bodyBlock.dumpSource(tabbedPrintWriter);
        tabbedPrintWriter.untab();
        if (this.type == 1) {
            if (bl) {
                tabbedPrintWriter.closeBraceContinue();
            }
            tabbedPrintWriter.print("while (");
            this.cond.dumpExpression(0, tabbedPrintWriter);
            tabbedPrintWriter.println(");");
        } else if (bl) {
            tabbedPrintWriter.closeBrace();
        }
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = "while_" + serialno++ + "_";
        }
        return this.label;
    }

    public void setBreaked() {
        this.mayChangeJump = false;
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        if (this.type == 1) {
            VariableStack variableStack2 = this.bodyBlock.mapStackToLocal(variableStack);
            if (variableStack2 != null) {
                this.mergeContinueStack(variableStack2);
            }
            if (this.continueStack != null) {
                VariableStack variableStack3;
                int n = this.cond.getFreeOperandCount();
                if (n > 0) {
                    this.condStack = this.continueStack.peek(n);
                    variableStack3 = this.continueStack.pop(n);
                } else {
                    variableStack3 = this.continueStack;
                }
                if (this.cond != TRUE) {
                    this.mergeBreakedStack(variableStack3);
                }
                if (this.cond != FALSE) {
                    variableStack.merge(variableStack3);
                }
            }
        } else {
            VariableStack variableStack4;
            VariableStack variableStack5;
            this.continueStack = variableStack;
            int n = this.cond.getFreeOperandCount();
            if (n > 0) {
                this.condStack = variableStack.peek(n);
                variableStack5 = variableStack.pop(n);
            } else {
                variableStack5 = variableStack;
            }
            if (this.cond != TRUE) {
                this.breakedStack = variableStack5;
            }
            if ((variableStack4 = this.bodyBlock.mapStackToLocal(variableStack5)) != null) {
                this.mergeContinueStack(variableStack4);
            }
        }
        return this.breakedStack;
    }

    public void mergeContinueStack(VariableStack variableStack) {
        if (this.continueStack == null) {
            this.continueStack = variableStack;
        } else {
            this.continueStack.merge(variableStack);
        }
    }

    public void mergeBreakedStack(VariableStack variableStack) {
        if (this.breakedStack != null) {
            this.breakedStack.merge(variableStack);
        } else {
            this.breakedStack = variableStack;
        }
    }

    public void removePush() {
        if (this.condStack != null) {
            this.cond = this.condStack.mergeIntoExpression(this.cond);
        }
        this.bodyBlock.removePush();
    }

    public void removeOnetimeLocals() {
        this.cond = this.cond.removeOnetimeLocals();
        if (this.type == 2) {
            if (this.initInstr != null) {
                this.initInstr.removeOnetimeLocals();
            }
            this.incrInstr.removeOnetimeLocals();
        }
        super.removeOnetimeLocals();
    }

    public void replaceBreakContinue(BreakableBlock breakableBlock) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(breakableBlock);
        while (!stack.isEmpty()) {
            StructuredBlock[] structuredBlockArray = ((StructuredBlock)stack.pop()).getSubBlocks();
            int n = 0;
            while (n < structuredBlockArray.length) {
                if (structuredBlockArray[n] instanceof BreakBlock) {
                    BreakBlock breakBlock = (BreakBlock)structuredBlockArray[n];
                    if (breakBlock.breaksBlock == breakableBlock) {
                        new ContinueBlock(this, breakBlock.label != null).replace(breakBlock);
                    }
                }
                stack.push(structuredBlockArray[n]);
                ++n;
            }
        }
    }

    public boolean jumpMayBeChanged() {
        return this.mayChangeJump;
    }

    public void simplify() {
        this.cond = this.cond.simplify();
        if (this.type == 2) {
            this.incrInstr = this.incrInstr.simplify();
            if (this.initInstr != null) {
                this.initInstr = this.initInstr.simplify();
            }
        }
        super.simplify();
    }

    public boolean doTransformations() {
        return (this.initBlock == null && this.type == 3 || this.initInstr == null && this.type == 2) && CreateForInitializer.transform(this, this.flowBlock.lastModified);
    }

    public LoopBlock(int n, Expression expression) {
        this.type = n;
        this.cond = expression;
        this.mayChangeJump = expression == TRUE;
    }
}

