/*
 * Decompiled with CFR 0.152.
 */
package jode.type;

import java.util.Iterator;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.type.ArrayType;
import jode.type.ClassInterfacesType;
import jode.type.IntegerType;
import jode.type.MethodType;
import jode.type.NullType;
import jode.type.RangeType;
import jode.type.ReferenceType;
import jode.util.UnifyHash;

public class Type {
    public static final int TC_BOOLEAN = 0;
    public static final int TC_BYTE = 1;
    public static final int TC_CHAR = 2;
    public static final int TC_SHORT = 3;
    public static final int TC_INT = 4;
    public static final int TC_LONG = 5;
    public static final int TC_FLOAT = 6;
    public static final int TC_DOUBLE = 7;
    public static final int TC_NULL = 8;
    public static final int TC_ARRAY = 9;
    public static final int TC_CLASS = 10;
    public static final int TC_VOID = 11;
    public static final int TC_METHOD = 12;
    public static final int TC_ERROR = 13;
    public static final int TC_UNKNOWN = 101;
    public static final int TC_RANGE = 103;
    public static final int TC_INTEGER = 107;
    private static final UnifyHash classHash = new UnifyHash();
    private static final UnifyHash arrayHash = new UnifyHash();
    private static final UnifyHash methodHash = new UnifyHash();
    public static final Type tBoolean = new IntegerType(1);
    public static final Type tByte = new IntegerType(16);
    public static final Type tChar = new IntegerType(4);
    public static final Type tShort = new IntegerType(8);
    public static final Type tInt = new IntegerType(2);
    public static final Type tLong = new Type(5);
    public static final Type tFloat = new Type(6);
    public static final Type tDouble = new Type(7);
    public static final Type tVoid = new Type(11);
    public static final Type tError = new Type(13);
    public static final Type tUnknown = new Type(101);
    public static final Type tUInt = new IntegerType(30);
    public static final Type tBoolInt = new IntegerType(3);
    public static final Type tBoolUInt = new IntegerType(31);
    public static final Type tBoolByte = new IntegerType(17);
    public static final ClassInterfacesType tObject = Type.tClass("java.lang.Object");
    public static final ReferenceType tNull = new NullType();
    public static final Type tUObject = Type.tRange(tObject, tNull);
    public static final Type tString = Type.tClass("java.lang.String");
    public static final Type tStringBuffer = Type.tClass("java.lang.StringBuffer");
    public static final Type tJavaLangClass = Type.tClass("java.lang.Class");
    final int typecode;

    public static final Type tType(String string) {
        if (string == null || string.length() == 0) {
            return tError;
        }
        switch (string.charAt(0)) {
            case 'Z': {
                return tBoolean;
            }
            case 'B': {
                return tByte;
            }
            case 'C': {
                return tChar;
            }
            case 'S': {
                return tShort;
            }
            case 'I': {
                return tInt;
            }
            case 'F': {
                return tFloat;
            }
            case 'J': {
                return tLong;
            }
            case 'D': {
                return tDouble;
            }
            case 'V': {
                return tVoid;
            }
            case '[': {
                return Type.tArray(Type.tType(string.substring(1)));
            }
            case 'L': {
                int n = string.indexOf(59);
                if (n != string.length() - 1) {
                    return tError;
                }
                return Type.tClass(string.substring(1, n));
            }
            case '(': {
                return Type.tMethod(string);
            }
        }
        throw new AssertError("Unknown type signature: " + string);
    }

    public static final ClassInterfacesType tClass(String string) {
        return Type.tClass(ClassInfo.forName(string.replace('/', '.')));
    }

    public static final ClassInterfacesType tClass(ClassInfo classInfo) {
        ClassInterfacesType classInterfacesType;
        int n = classInfo.hashCode();
        Iterator iterator = classHash.iterateHashCode(n);
        while (iterator.hasNext()) {
            classInterfacesType = (ClassInterfacesType)iterator.next();
            if (classInterfacesType.getClassInfo() != classInfo) continue;
            return classInterfacesType;
        }
        classInterfacesType = new ClassInterfacesType(classInfo);
        classHash.put(n, classInterfacesType);
        return classInterfacesType;
    }

    public static final Type tArray(Type type) {
        ArrayType arrayType;
        if (type == tError) {
            return type;
        }
        int n = type.hashCode();
        Iterator iterator = arrayHash.iterateHashCode(n);
        while (iterator.hasNext()) {
            arrayType = (ArrayType)iterator.next();
            if (!arrayType.getElementType().equals(type)) continue;
            return arrayType;
        }
        arrayType = new ArrayType(type);
        arrayHash.put(n, arrayType);
        return arrayType;
    }

    public static MethodType tMethod(String string) {
        MethodType methodType;
        int n = string.hashCode();
        Iterator iterator = methodHash.iterateHashCode(n);
        while (iterator.hasNext()) {
            methodType = (MethodType)iterator.next();
            if (!methodType.getTypeSignature().equals(string)) continue;
            return methodType;
        }
        methodType = new MethodType(string);
        methodHash.put(n, methodType);
        return methodType;
    }

    public static final Type tRange(ReferenceType referenceType, ReferenceType referenceType2) {
        return new RangeType(referenceType, referenceType2);
    }

    public static Type tSuperType(Type type) {
        return type.getSuperType();
    }

    public static Type tSubType(Type type) {
        return type.getSubType();
    }

    public Type getSubType() {
        return this;
    }

    public Type getSuperType() {
        return this;
    }

    public Type getHint() {
        return this.getCanonic();
    }

    public Type getCanonic() {
        return this;
    }

    public final int getTypeCode() {
        return this.typecode;
    }

    public int stackSize() {
        switch (this.typecode) {
            case 11: {
                return 0;
            }
            default: {
                return 1;
            }
            case 5: 
            case 7: 
        }
        return 2;
    }

    public Type intersection(Type type) {
        if (this == tError || type == tError) {
            return tError;
        }
        if (this == tUnknown) {
            return type;
        }
        if (type == tUnknown || this == type) {
            return this;
        }
        if ((GlobalOptions.debuggingFlags & 4) != 0) {
            GlobalOptions.err.println("intersecting " + this + " and " + type + " to <error>");
        }
        return tError;
    }

    public Type getCastHelper(Type type) {
        return null;
    }

    public boolean isValidType() {
        return this.typecode <= 7;
    }

    public boolean isClassType() {
        return false;
    }

    public boolean isOfType(Type type) {
        return this.intersection(type) != tError;
    }

    public String getDefaultName() {
        switch (this.typecode) {
            case 5: {
                return "l";
            }
            case 6: {
                return "f";
            }
            case 7: {
                return "d";
            }
        }
        return "local";
    }

    public Object getDefaultValue() {
        switch (this.typecode) {
            case 5: {
                return new Long(0L);
            }
            case 6: {
                return new Float(0.0f);
            }
            case 7: {
                return new Double(0.0);
            }
        }
        return null;
    }

    public String getTypeSignature() {
        switch (this.typecode) {
            case 5: {
                return "J";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
        }
        return "?";
    }

    public Class getTypeClass() throws ClassNotFoundException {
        switch (this.typecode) {
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
        }
        throw new AssertError("getTypeClass() called on illegal type");
    }

    public String toString() {
        switch (this.typecode) {
            case 5: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "null";
            }
            case 11: {
                return "void";
            }
            case 101: {
                return "<unknown>";
            }
        }
        return "<error>";
    }

    protected Type(int n) {
        this.typecode = n;
    }
}

