/*
 * Decompiled with CFR 0.152.
 */
package sadam;

import com.cycling74.max.Callback;
import com.cycling74.max.Executable;
import com.cycling74.max.MaxObject;
import com.cycling74.max.MaxQelem;
import com.cycling74.max.MaxSystem;
import hu.sadam.musicxml.MusicXMLtoJScoreXMLConverter;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;

public final class MusicXMLtoJScoreXML
extends MaxObject {
    private boolean maxscore;
    protected static HashSet<File> tempFiles;
    protected String file = null;
    protected MaxQelem reader;
    protected Callback readerCB = new Callback((Object)this, "deferredRead", "");

    static {
        MusicXMLtoJScoreXML.post((String)"[sadam.MusicXMLtoJScoreXML] MusicXML to JMSL Score XML conversion tool,");
        MusicXMLtoJScoreXML.post((String)"     version 2012-11-11");
        MusicXMLtoJScoreXML.post((String)"     Copyright (C) 2012 Adam Siska (www.sadam.hu)");
        MusicXMLtoJScoreXML.post((String)"     All Rights Reserved.");
        tempFiles = new HashSet();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                for (File currentFile : tempFiles) {
                    if (!currentFile.exists()) continue;
                    currentFile.delete();
                }
            }
        });
    }

    public MusicXMLtoJScoreXML() {
        this.reader = new MaxQelem((Executable)this.readerCB);
        this.declareInlets(new int[]{15});
        this.declareOutlets(new int[]{15});
        this.createInfoOutlet(false);
        this.declareAttribute("maxscore");
        this.setInletAssist(new String[]{"read Read and Convert a MusicXML to JMSL Score XML."});
        this.setOutletAssist(new String[]{"(Converted File Path, Original File Path)"});
    }

    protected void deferredRead(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            fileName = MaxSystem.openDialog((String)"Select MusicXML file to open.");
        }
        if (fileName == null) {
            return;
        }
        try {
            String fullFileName = MaxSystem.locateFile((String)fileName);
            if (fullFileName != null) {
                MusicXMLtoJScoreXMLConverter loader = new MusicXMLtoJScoreXMLConverter();
                loader.loadXML(new FileInputStream(fullFileName), this.maxscore);
                File tempFile = File.createTempFile("hu.sadam.mx2jx", ".xml");
                fullFileName = tempFile.getAbsolutePath();
                loader.getScore().save(fullFileName);
                this.outlet(0, new String[]{fullFileName, fileName});
                tempFiles.add(tempFile);
                tempFile.deleteOnExit();
            }
        }
        catch (Exception ex) {
            MaxObject.showException((Throwable)ex);
        }
    }

    public void read(String fileName) {
        this.file = fileName;
        this.readerCB.setArgs(fileName);
        this.reader.set();
    }

    public void read() {
        this.read(null);
    }

    public void readagain() {
        this.read(this.file);
    }
}

