/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jmsl.score;

import com.softsynth.jmsl.Composable;
import com.softsynth.jmsl.Instrument;
import com.softsynth.jmsl.ParallelCollection;
import com.softsynth.jmsl.score.Clef;
import com.softsynth.jmsl.score.ClefRenderer;
import com.softsynth.jmsl.score.KeySignature;
import com.softsynth.jmsl.score.KeySignatureRenderer;
import com.softsynth.jmsl.score.Measure;
import com.softsynth.jmsl.score.MusicGlyphNumberRenderer;
import com.softsynth.jmsl.score.MusicGlyphRenderer;
import com.softsynth.jmsl.score.Note;
import com.softsynth.jmsl.score.Orchestra;
import com.softsynth.jmsl.score.Score;
import com.softsynth.jmsl.score.TimeSigRenderer;
import com.softsynth.jmsl.score.Track;
import com.softsynth.jmsl.score.util.RenderedMessageBean;
import com.softsynth.jmsl.util.SimpleXMLSaver;
import com.softsynth.jmsl.util.XMLString;
import com.softsynth.jmsl.util.XMLWritable;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Staff
extends ParallelCollection
implements XMLWritable {
    Measure y;
    public static final int SPACE_INTERVAL = 12;
    public static final int DEFAULT_STAFF_SPACE_ABOVE = 72;
    public static final int DEFAULT_STAFF_SPACE_BELOW = 72;
    public static final int LEVEL_OF_MIDDLE_LINE = 128;
    public static final int LEVEL_OF_TOP_LINE = 132;
    public static final int LEVEL_OF_BOTTOM_LINE = 124;
    Point2D z;
    Clef A;
    boolean B;
    boolean C;
    boolean D;
    boolean E;
    boolean F;
    int G;
    boolean H;
    private KeySignature I;
    private Vector J = new Vector();
    private boolean K;
    private int L;
    private int M = 0;
    private int N = 0;
    public static final String copyright;
    private static String[] O;

    public Staff(Measure measure) {
        this(measure, null);
        this.E = false;
        this.I = new KeySignature();
        this.I.setKeySignatureType(0);
        this.I.setNumAccidentals(0);
    }

    public Staff(Measure measure, Instrument instrument) {
        this.y = measure;
        int n2 = 2;
        if (measure.getScore() != null) {
            n2 = measure.getScore().getNumTracksPerStaff();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add((Composable)new Track(this, i2, instrument));
            if (!Score.zb) continue;
        }
        this.z = new Point2D.Double();
        this.setClef(Clef.TREBLE_CLEF);
    }

    public int getExtendedLinesAbove() {
        return this.M;
    }

    public void setExtendedLinesAbove(int n2) {
        this.M = n2;
    }

    public int getExtendedLinesBelow() {
        return this.N;
    }

    public void setExtendedLinesBelow(int n2) {
        this.N = n2;
    }

    public int getStaffIndex() {
        return this.y.getChildren().indexOf((Object)this);
    }

    public void setInstrumentIndex(int n2) {
        this.G = n2;
        this.setInstrument();
    }

    public int getInstrumentIndex() {
        return this.G;
    }

    public void setInstrument() {
        Orchestra orchestra = this.getScore().getOrchestra();
        if (orchestra != null && orchestra.size() > this.G && this.G >= 0) {
            Instrument instrument = orchestra.getInstrument(this.G);
            this.setInstrument(instrument);
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Track track = (Track)((Object)enumeration.nextElement());
                track.setInstrument(instrument);
                if (!Score.zb) continue;
            }
        }
    }

    public void setClefSetByHand(boolean bl) {
        this.E = bl;
    }

    public Track addTrack() {
        Track track = new Track(this, this.size());
        this.add((Composable)track);
        return track;
    }

    public Track addTrack(Instrument instrument) {
        Track track = new Track(this, this.size(), instrument);
        this.add((Composable)track);
        return track;
    }

    public boolean getClefSetByHand() {
        return this.E;
    }

    public void setKeySignatureSetByHand(boolean bl) {
        this.F = bl;
    }

    public boolean getKeySignatureSetByHand() {
        return this.F;
    }

    public boolean getInsIndexSetByHand() {
        return this.H;
    }

    public void setInsIndexSetByHand(boolean bl) {
        this.H = bl;
    }

    public KeySignature getKeySignature() {
        return this.I;
    }

    public void setKeySignature(KeySignature keySignature) {
        this.I = keySignature;
    }

    public void setDisplayClef(boolean bl) {
        this.B = bl;
    }

    public boolean getDisplayClef() {
        return this.B;
    }

    public void setDisplayTimeSig(boolean bl) {
        this.C = bl;
    }

    public boolean getDisplayTimeSig() {
        return this.C;
    }

    public void setDisplayKeySignature(boolean bl) {
        this.D = bl;
    }

    public boolean getDisplayKeySignature() {
        return this.D;
    }

    public boolean isMultiTrack() {
        return this.getNonEmptyTrackCount() > 1;
    }

    public int getNonEmptyTrackCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.getTrack(i2).size() <= 0) continue;
            ++n2;
            if (!Score.zb) continue;
        }
        return n2;
    }

    public Measure getMeasure() {
        return this.y;
    }

    public Track getTrack(int n2) {
        return (Track)this.get(n2);
    }

    public Score getScore() {
        if (this.getMeasure() == null) {
            return null;
        }
        return this.getMeasure().getScore();
    }

    public double getMaxDuration() {
        double d2 = 0.0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Track track = (Track)((Object)enumeration.nextElement());
            d2 = Math.max(d2, track.getDuration());
            if (!Score.zb) continue;
        }
        return d2;
    }

    public void setClef(Clef clef) {
        Clef clef2;
        this.A = clef2 = new Clef(clef);
        this.A.setStaff(this);
    }

    public Clef getClef() {
        return this.A;
    }

    public double getSpaceAbove() {
        return this.getScore().getStaffSpacing(this.getStaffIndex()).getSpaceAbove();
    }

    public double getSpaceBelow() {
        return this.getScore().getStaffSpacing(this.getStaffIndex()).getSpaceBelow();
    }

    public static double getStaffHeight() {
        return 48.0;
    }

    public double getTotalHeight() {
        return this.getSpaceAbove() + this.getSpaceBelow() + Staff.getStaffHeight();
    }

    public void setSpaceAbove(double d2) {
        this.getScore().getStaffSpacing(this.getStaffIndex()).setSpaceAbove(d2);
    }

    public void setSpaceBelow(double d2) {
        this.getScore().getStaffSpacing(this.getStaffIndex()).setSpaceBelow(d2);
    }

    public void addToSpaceAbove(double d2) {
        this.setSpaceAbove(Math.max(0.0, this.getSpaceAbove() + d2));
    }

    public void addToSpaceBelow(double d2) {
        this.setSpaceBelow(Math.max(0.0, this.getSpaceBelow() + d2));
    }

    public void setDrawingAnchor(Point2D point2D) {
        this.z.setLocation(point2D);
    }

    public Point2D getDrawingAnchor() {
        return this.z;
    }

    public void layoutChildren() {
        Point2D.Double double_ = new Point2D.Double(this.getDrawingAnchor().getX(), this.getDrawingAnchor().getY());
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Track track = (Track)((Object)enumeration.nextElement());
            double_.y = this.levelOfTopLine();
            track.setDrawingAnchor(double_);
            track.layoutChildren();
            if (!Score.zb) continue;
        }
    }

    public double levelOfTopLine() {
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        return this.getDrawingAnchor().getY() + d2 * this.getSpaceAbove();
    }

    public boolean within(Point point) {
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        return (double)point.x >= this.z.getX() && (double)point.x < this.z.getX() + (double)((int)(this.getMeasure().getWidth() * d2)) && (double)point.y >= this.z.getY() && (double)point.y < this.z.getY() + (double)((int)(this.getTotalHeight() * d2));
    }

    public int getInsertionIndex(Point2D point2D, int n2) {
        boolean bl = Score.zb;
        int n3 = 0;
        Enumeration enumeration = this.getTrack(n2).elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (point2D.getX() <= note.getDrawingAnchor().getX() && !bl) break;
            ++n3;
            if (!bl) continue;
        }
        return n3;
    }

    public int getNearestLevel(Point point) {
        double d2 = this.getScore().getScoreLayoutManager().getZoom();
        int n2 = (int)(this.levelOfTopLine() + (Staff.getStaffHeight() + 12.0) * d2);
        return (int)(((double)(n2 - point.y) + d2 * 12.0 / 4.0) / (d2 * 12.0 / 2.0) + 122.0);
    }

    void a(Graphics graphics, double d2) {
        block4: {
            int n2;
            int n3;
            String string;
            block5: {
                if (!this.getScore().getStaffNumbersVisible()) {
                    return;
                }
                if (0 != this.getMeasure().getMeasureIndex() && !this.getMeasure().isBeginningOfLine()) break block4;
                string = this.getStaffIndex() + 1 + "";
                FontMetrics fontMetrics = graphics.getFontMetrics();
                double d3 = fontMetrics.stringWidth(string);
                double d4 = fontMetrics.stringWidth("0");
                double d5 = this.getDrawingAnchor().getX() - d4 * 2.0;
                double d6 = d3 - d4;
                double d7 = d5 - d6 / 2.0;
                n3 = (int)d7;
                n2 = (int)(this.levelOfTopLine() + d2 * 12.0 * 2.0);
                MusicGlyphRenderer musicGlyphRenderer = MusicGlyphNumberRenderer.a(O[4], graphics, string, d2, this.getScore());
                if (musicGlyphRenderer == null) break block5;
                MusicGlyphNumberRenderer.a(O[4], graphics, n3, n2, d2, musicGlyphRenderer, 0, string, 0, (Object)this);
                if (!Score.zb) break block4;
            }
            graphics.drawString(string, n3, n2);
        }
    }

    void a(Graphics graphics, double d2, int n2, boolean bl) {
        block6: {
            FontMetrics fontMetrics;
            String string;
            block7: {
                block8: {
                    if (!this.getScore().getInstrumentNamesVisible()) {
                        return;
                    }
                    if (!this.getInsIndexSetByHand() && 0 != this.getMeasure().getMeasureIndex() && !this.getMeasure().isBeginningOfLine()) break block6;
                    Orchestra orchestra = this.getScore().getOrchestra();
                    string = O[15] + this.getInstrumentIndex();
                    if (orchestra == null) break block7;
                    if (this.getInstrumentIndex() >= orchestra.size()) break block8;
                    fontMetrics = orchestra.getInstrument(this.getInstrumentIndex());
                    if (fontMetrics != null) {
                        string = fontMetrics.getName();
                    }
                    if (!Score.zb) break block7;
                }
                string = O[16];
            }
            fontMetrics = graphics.getFontMetrics();
            int n3 = 0;
            if (bl) {
                n3 = (int)(18.0 * d2);
            }
            ((Graphics2D)graphics).drawString(string, (float)(this.z.getX() + (double)n2 + 1.0), (float)(this.levelOfTopLine() - (double)n3 - (double)(fontMetrics.getHeight() / 4)));
        }
    }

    public void render(Graphics graphics, double d2) {
        graphics.setColor(Color.black);
        int n2 = 0;
        n2 = this.a(graphics, d2, n2);
        n2 = this.b(graphics, d2, n2);
        this.a(graphics, d2, n2, this.K);
        this.a(graphics, d2);
        n2 = this.c(graphics, d2, n2);
        this.c(graphics, d2);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ((Track)((Object)enumeration.nextElement())).render(graphics, d2);
            if (!Score.zb) continue;
        }
        this.b(graphics, d2);
    }

    private void b(Graphics graphics, double d2) {
        Enumeration enumeration = this.getUserBeans().elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (e2 instanceof RenderedMessageBean) {
                ((RenderedMessageBean)e2).execute(this.getScore(), (Object)this, graphics, this.getDrawingAnchor(), d2);
            }
            if (!Score.zb) continue;
        }
    }

    private boolean a() {
        boolean bl;
        block3: {
            block2: {
                bl = false;
                int n2 = this.getMeasure().getMeasureIndex() - 1;
                if (n2 < 0) break block2;
                Measure measure = this.getScore().getMeasure(n2);
                Staff staff = measure.getStaff(this.getStaffIndex());
                Clef clef = staff.getClef();
                boolean bl2 = bl = clef.getClefType() != this.getClef().getClefType();
                if (!Score.zb) break block3;
            }
            bl = true;
        }
        return bl;
    }

    private int a(Graphics graphics, double d2, int n2) {
        if (this.getDisplayClef()) {
            Measure measure = this.getMeasure();
            if (measure.isBeginningOfLine() || this.a() || this.getScore().isDrawCourtesyClefs()) {
                ClefRenderer.render(graphics, this.getClef(), this.z.getX(), this.levelOfTopLine(), d2, this);
            }
            n2 += (int)(ClefRenderer.CLEF_WIDTH * d2);
        }
        return n2;
    }

    private void c(Graphics graphics, double d2) {
        boolean bl;
        boolean bl2 = Score.zb;
        double d3 = this.getMeasure().getWidth() * d2;
        boolean bl3 = bl = this.getScore().getSelectedStaff() == this;
        if (!this.getScore().isHighlightSelectedStaff()) {
            bl = false;
        }
        int n2 = 0 - this.getExtendedLinesAbove();
        int n3 = 5 + this.getExtendedLinesBelow();
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            Object object;
            Serializable serializable;
            if (!this.getScore().getStaffAndLedgerLineVisibilityManager().isStaffLineVisible(this.getStaffIndex(), i2)) continue;
            double d4 = ((double)(i2 * 12) + this.getSpaceAbove()) * d2 + this.z.getY();
            if (this.getScore().getMusicCurveRenderer() != null) {
                serializable = new Hashtable();
                ((Hashtable)serializable).put(O[14], new Double(d2));
                ((Hashtable)serializable).put(O[13], new Double(this.z.getX()));
                ((Hashtable)serializable).put(O[11], new Double(d4));
                ((Hashtable)serializable).put(O[10], new Double(this.z.getX() + d3));
                ((Hashtable)serializable).put(O[8], new Double(d4));
                ((Hashtable)serializable).put(O[5], new Integer(this.getExtendedLinesAbove()));
                ((Hashtable)serializable).put(O[7], new Integer(this.getExtendedLinesBelow()));
                ((Hashtable)serializable).put(O[6], new Double(i2));
                ((Hashtable)serializable).put(O[3], this);
                ((Hashtable)serializable).put(O[9], bl + "");
                object = O[12];
                this.getScore().getMusicCurveRenderer().draw(graphics, (String)object, (Hashtable)serializable);
                if (!bl2) continue;
            }
            serializable = graphics.getColor();
            object = bl ? Color.cyan : Color.black;
            graphics.setColor((Color)object);
            ((Graphics2D)graphics).draw(new Line2D.Double(this.z.getX(), d4, this.z.getX() + d3, d4));
            graphics.setColor((Color)serializable);
            if (!bl2) continue;
        }
    }

    private int b(Graphics graphics, double d2, int n2) {
        this.K = false;
        if (this.getDisplayKeySignature() && this.getScore().getKeySignaturesVisible()) {
            int n3 = (int)(24.0 * d2);
            KeySignature keySignature = this.getKeySignature();
            KeySignature keySignature2 = this.needsCancellingKeySig();
            if (keySignature2 != null) {
                keySignature = keySignature2;
            }
            KeySignatureRenderer.render(graphics, this, keySignature, this.z.getX() + (double)n2 + (double)n3, d2);
            this.K = keySignature.getKeySignatureType() == 0 && keySignature.getNumAccidentals() > 0 || keySignature.getKeySignatureType() == 1 && keySignature.getNumAccidentals() > 1;
        }
        return (int)((double)n2 + (double)this.L * d2);
    }

    protected KeySignature needsCancellingKeySig() {
        KeySignature keySignature = null;
        if (this.getMeasure().getMeasureIndex() > 0 && this.getKeySignature().getNumAccidentals() == 0) {
            int n2 = this.getMeasure().getMeasureIndex();
            Measure measure = this.getScore().getMeasure(n2 - 1);
            Staff staff = measure.getStaff(this.getStaffIndex());
            KeySignature keySignature2 = staff.getKeySignature();
            if (keySignature2.getNumAccidentals() > 0) {
                keySignature = KeySignature.getCancellingKeySignature(keySignature2);
            }
        }
        return keySignature;
    }

    private int c(Graphics graphics, double d2, int n2) {
        if (this.getDisplayTimeSig() && this.getScore().getTimeSignaturesVisible()) {
            TimeSigRenderer.render(graphics, this.getMeasure().getTimeSig(), this.z.getX() + (double)n2, this.levelOfTopLine(), d2, this.getScore().getScorePainter().getTimeSigFont(), this);
            n2 += (int)(40.0 * d2);
        }
        return n2;
    }

    public String getHierarchy() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Score.indent() + O[1]);
        Score.printIndent += 5;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((Track)((Object)enumeration.nextElement())).getHierarchy() + "\n");
            if (!Score.zb) continue;
        }
        Score.printIndent -= 5;
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(O[2] + this.getStaffIndex());
        return stringBuffer.toString();
    }

    public void writeXML(PrintWriter printWriter) throws IOException {
        Track track;
        boolean bl = Score.zb;
        this.writeStaffPropertiesXML(printWriter);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            track = (Track)((Object)enumeration.nextElement());
            track.writeXML(printWriter);
            if (!bl) continue;
        }
        if (this.J != null) {
            enumeration = this.J.elements();
            while (enumeration.hasMoreElements()) {
                track = enumeration.nextElement();
                SimpleXMLSaver simpleXMLSaver = new SimpleXMLSaver((Object)track, O[0]);
                simpleXMLSaver.writeXML(printWriter);
                if (!bl) continue;
            }
        }
        this.closeStaffPropertiesXML(printWriter);
    }

    public void closeStaffPropertiesXML(PrintWriter printWriter) {
        XMLString xMLString = new XMLString();
        xMLString.endElement(O[3], true);
        printWriter.println(xMLString);
    }

    public void writeStaffPropertiesXML(PrintWriter printWriter) {
        XMLString xMLString = new XMLString();
        xMLString.startElement(O[3], false);
        xMLString.addAttribute(O[17], this.getStaffIndex() + "");
        xMLString.addAttribute(O[25], this.getClef().getClefType() + "");
        xMLString.addAttribute(O[18], this.getClefSetByHand() + "");
        xMLString.addAttribute(O[19], this.getInstrumentIndex() + "");
        xMLString.addAttribute(O[20], this.getInsIndexSetByHand() + "");
        xMLString.addAttribute(O[24], this.getKeySignature().getKeySignatureType() + "");
        xMLString.addAttribute(O[21], this.getKeySignature().getNumAccidentals() + "");
        xMLString.addAttribute(O[26], this.getKeySignatureSetByHand() + "");
        xMLString.addAttribute(O[23], this.getExtendedLinesAbove() + "");
        xMLString.addAttribute(O[22], this.getExtendedLinesBelow() + "");
        xMLString.endElement(null, true);
        printWriter.println(xMLString);
    }

    public Vector getUserBeans() {
        return this.J;
    }

    public void addUserBean(Object object) {
        this.J.addElement(object);
    }

    public void removeUserBean(Object object) {
        this.J.removeElement(object);
    }

    public void setMaxKeySignatureWidthInMeasure(int n2) {
        this.L = n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block307: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block306: {
                char[] cArray3;
                Object var0;
                block305: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block304: {
                        char[] cArray5;
                        block303: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block302: {
                                char[] cArray7;
                                block301: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block300: {
                                        char[] cArray9;
                                        block299: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block298: {
                                                char[] cArray11;
                                                block297: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block296: {
                                                        char[] cArray13;
                                                        block295: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block294: {
                                                                char[] cArray15;
                                                                block293: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block292: {
                                                                        char[] cArray17;
                                                                        block291: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block290: {
                                                                                char[] cArray19;
                                                                                block289: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block288: {
                                                                                        char[] cArray21;
                                                                                        block287: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block286: {
                                                                                                char[] cArray23;
                                                                                                block285: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block284: {
                                                                                                        char[] cArray25;
                                                                                                        block283: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block282: {
                                                                                                                char[] cArray27;
                                                                                                                block281: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block280: {
                                                                                                                        char[] cArray29;
                                                                                                                        block279: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block278: {
                                                                                                                                char[] cArray31;
                                                                                                                                block277: {
                                                                                                                                    int n33;
                                                                                                                                    int n34;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block276: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block275: {
                                                                                                                                            int n35;
                                                                                                                                            int n36;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block274: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block273: {
                                                                                                                                                    int n37;
                                                                                                                                                    int n38;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block272: {
                                                                                                                                                        char[] cArray37;
                                                                                                                                                        block271: {
                                                                                                                                                            int n39;
                                                                                                                                                            int n40;
                                                                                                                                                            char[] cArray38;
                                                                                                                                                            block270: {
                                                                                                                                                                char[] cArray39;
                                                                                                                                                                block269: {
                                                                                                                                                                    int n41;
                                                                                                                                                                    int n42;
                                                                                                                                                                    char[] cArray40;
                                                                                                                                                                    block268: {
                                                                                                                                                                        char[] cArray41;
                                                                                                                                                                        block267: {
                                                                                                                                                                            int n43;
                                                                                                                                                                            int n44;
                                                                                                                                                                            char[] cArray42;
                                                                                                                                                                            block266: {
                                                                                                                                                                                char[] cArray43;
                                                                                                                                                                                block265: {
                                                                                                                                                                                    int n45;
                                                                                                                                                                                    int n46;
                                                                                                                                                                                    char[] cArray44;
                                                                                                                                                                                    block264: {
                                                                                                                                                                                        char[] cArray45;
                                                                                                                                                                                        block263: {
                                                                                                                                                                                            int n47;
                                                                                                                                                                                            int n48;
                                                                                                                                                                                            char[] cArray46;
                                                                                                                                                                                            block262: {
                                                                                                                                                                                                char[] cArray47;
                                                                                                                                                                                                block261: {
                                                                                                                                                                                                    int n49;
                                                                                                                                                                                                    int n50;
                                                                                                                                                                                                    char[] cArray48;
                                                                                                                                                                                                    block260: {
                                                                                                                                                                                                        char[] cArray49;
                                                                                                                                                                                                        block259: {
                                                                                                                                                                                                            int n51;
                                                                                                                                                                                                            int n52;
                                                                                                                                                                                                            char[] cArray50;
                                                                                                                                                                                                            block258: {
                                                                                                                                                                                                                char[] cArray51;
                                                                                                                                                                                                                block257: {
                                                                                                                                                                                                                    int n53;
                                                                                                                                                                                                                    int n54;
                                                                                                                                                                                                                    char[] cArray52;
                                                                                                                                                                                                                    block256: {
                                                                                                                                                                                                                        char[] cArray53;
                                                                                                                                                                                                                        block255: {
                                                                                                                                                                                                                            int n55;
                                                                                                                                                                                                                            int n56;
                                                                                                                                                                                                                            char[] cArray54;
                                                                                                                                                                                                                            block254: {
                                                                                                                                                                                                                                char[] cArray55;
                                                                                                                                                                                                                                block253: {
                                                                                                                                                                                                                                    int n57;
                                                                                                                                                                                                                                    int n58;
                                                                                                                                                                                                                                    char[] cArray56;
                                                                                                                                                                                                                                    block252: {
                                                                                                                                                                                                                                        stringArray = new String[27];
                                                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                                                        char[] cArray57 = "YF\u0007piSN\u001f};\u0012j^))\n\u0019G)USJ\u001c)_SM\u001cfmIB\u000e%;[E\u001b)iSN\u001f}h\u001a[\u0012z~H_\u0012m".toCharArray();
                                                                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                                                                        int n59 = cArray57.length;
                                                                                                                                                                                                                                        cArray56 = cArray57;
                                                                                                                                                                                                                                        n58 = n59;
                                                                                                                                                                                                                                        if (n59 <= 1) break block252;
                                                                                                                                                                                                                                        cArray55 = cArray56;
                                                                                                                                                                                                                                        n57 = n58;
                                                                                                                                                                                                                                        if (n58 <= n4) break block253;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    do {
                                                                                                                                                                                                                                        char[] cArray58 = cArray56;
                                                                                                                                                                                                                                        char[] cArray59 = cArray56;
                                                                                                                                                                                                                                        int n60 = n4;
                                                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                                                            int n61;
                                                                                                                                                                                                                                            char c2 = cArray58[n60];
                                                                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                                                                    n61 = 58;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                                                                    n61 = 41;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                                                                    n61 = 119;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                                                                    n61 = 9;
                                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                default: {
                                                                                                                                                                                                                                                    n61 = 27;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            cArray58[n60] = (char)(c2 ^ n61);
                                                                                                                                                                                                                                            ++n4;
                                                                                                                                                                                                                                            cArray56 = cArray59;
                                                                                                                                                                                                                                            n58 = n58;
                                                                                                                                                                                                                                            if (n58 != 0) break;
                                                                                                                                                                                                                                            cArray59 = cArray56;
                                                                                                                                                                                                                                            n57 = n58;
                                                                                                                                                                                                                                            n60 = n58;
                                                                                                                                                                                                                                            cArray58 = cArray56;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        cArray55 = cArray56;
                                                                                                                                                                                                                                        n57 = n58;
                                                                                                                                                                                                                                    } while (n58 > n4);
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                copyright = new String(cArray55).intern();
                                                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                                                char[] cArray60 = "I]\u0016o}oZ\u0012{Y_H\u0019".toCharArray();
                                                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                                                int n62 = cArray60.length;
                                                                                                                                                                                                                                cArray54 = cArray60;
                                                                                                                                                                                                                                n56 = n62;
                                                                                                                                                                                                                                if (n62 <= 1) break block254;
                                                                                                                                                                                                                                cArray53 = cArray54;
                                                                                                                                                                                                                                n55 = n56;
                                                                                                                                                                                                                                if (n56 <= n4) break block255;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            do {
                                                                                                                                                                                                                                char[] cArray61 = cArray54;
                                                                                                                                                                                                                                char[] cArray62 = cArray54;
                                                                                                                                                                                                                                int n63 = n4;
                                                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                                                    int n64;
                                                                                                                                                                                                                                    char c3 = cArray61[n63];
                                                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                                                            n64 = 58;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                                                            n64 = 41;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                                                            n64 = 119;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                                                            n64 = 9;
                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        default: {
                                                                                                                                                                                                                                            n64 = 27;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    cArray61[n63] = (char)(c3 ^ n64);
                                                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                                                    cArray54 = cArray62;
                                                                                                                                                                                                                                    n56 = n56;
                                                                                                                                                                                                                                    if (n56 != 0) break;
                                                                                                                                                                                                                                    cArray62 = cArray54;
                                                                                                                                                                                                                                    n55 = n56;
                                                                                                                                                                                                                                    n63 = n56;
                                                                                                                                                                                                                                    cArray61 = cArray54;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                cArray53 = cArray54;
                                                                                                                                                                                                                                n55 = n56;
                                                                                                                                                                                                                            } while (n56 > n4);
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        stringArray[0] = new String(cArray53).intern();
                                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                                        char[] cArray63 = "i]\u0016o}0".toCharArray();
                                                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                                                        int n65 = cArray63.length;
                                                                                                                                                                                                                        cArray52 = cArray63;
                                                                                                                                                                                                                        n54 = n65;
                                                                                                                                                                                                                        if (n65 <= 1) break block256;
                                                                                                                                                                                                                        cArray51 = cArray52;
                                                                                                                                                                                                                        n53 = n54;
                                                                                                                                                                                                                        if (n54 <= n4) break block257;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    do {
                                                                                                                                                                                                                        char[] cArray64 = cArray52;
                                                                                                                                                                                                                        char[] cArray65 = cArray52;
                                                                                                                                                                                                                        int n66 = n4;
                                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                                            int n67;
                                                                                                                                                                                                                            char c4 = cArray64[n66];
                                                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                                                    n67 = 58;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                                                    n67 = 41;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                                                    n67 = 119;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                                                    n67 = 9;
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                default: {
                                                                                                                                                                                                                                    n67 = 27;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            cArray64[n66] = (char)(c4 ^ n67);
                                                                                                                                                                                                                            ++n4;
                                                                                                                                                                                                                            cArray52 = cArray65;
                                                                                                                                                                                                                            n54 = n54;
                                                                                                                                                                                                                            if (n54 != 0) break;
                                                                                                                                                                                                                            cArray65 = cArray52;
                                                                                                                                                                                                                            n53 = n54;
                                                                                                                                                                                                                            n66 = n54;
                                                                                                                                                                                                                            cArray64 = cArray52;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        cArray51 = cArray52;
                                                                                                                                                                                                                        n53 = n54;
                                                                                                                                                                                                                    } while (n54 > n4);
                                                                                                                                                                                                                }
                                                                                                                                                                                                                stringArray[1] = new String(cArray51).intern();
                                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                                char[] cArray66 = "i]\u0016o}\u001a".toCharArray();
                                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                                int n68 = cArray66.length;
                                                                                                                                                                                                                cArray50 = cArray66;
                                                                                                                                                                                                                n52 = n68;
                                                                                                                                                                                                                if (n68 <= 1) break block258;
                                                                                                                                                                                                                cArray49 = cArray50;
                                                                                                                                                                                                                n51 = n52;
                                                                                                                                                                                                                if (n52 <= n4) break block259;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            do {
                                                                                                                                                                                                                char[] cArray67 = cArray50;
                                                                                                                                                                                                                char[] cArray68 = cArray50;
                                                                                                                                                                                                                int n69 = n4;
                                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                                    int n70;
                                                                                                                                                                                                                    char c5 = cArray67[n69];
                                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                                            n70 = 58;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                                            n70 = 41;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                                            n70 = 119;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                                            n70 = 9;
                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        default: {
                                                                                                                                                                                                                            n70 = 27;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    cArray67[n69] = (char)(c5 ^ n70);
                                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                                    cArray50 = cArray68;
                                                                                                                                                                                                                    n52 = n52;
                                                                                                                                                                                                                    if (n52 != 0) break;
                                                                                                                                                                                                                    cArray68 = cArray50;
                                                                                                                                                                                                                    n51 = n52;
                                                                                                                                                                                                                    n69 = n52;
                                                                                                                                                                                                                    cArray67 = cArray50;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                cArray49 = cArray50;
                                                                                                                                                                                                                n51 = n52;
                                                                                                                                                                                                            } while (n52 > n4);
                                                                                                                                                                                                        }
                                                                                                                                                                                                        stringArray[2] = new String(cArray49).intern();
                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                        char[] cArray69 = "I]\u0016o}".toCharArray();
                                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                                        int n71 = cArray69.length;
                                                                                                                                                                                                        cArray48 = cArray69;
                                                                                                                                                                                                        n50 = n71;
                                                                                                                                                                                                        if (n71 <= 1) break block260;
                                                                                                                                                                                                        cArray47 = cArray48;
                                                                                                                                                                                                        n49 = n50;
                                                                                                                                                                                                        if (n50 <= n4) break block261;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    do {
                                                                                                                                                                                                        char[] cArray70 = cArray48;
                                                                                                                                                                                                        char[] cArray71 = cArray48;
                                                                                                                                                                                                        int n72 = n4;
                                                                                                                                                                                                        while (true) {
                                                                                                                                                                                                            int n73;
                                                                                                                                                                                                            char c6 = cArray70[n72];
                                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                                    n73 = 58;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                                    n73 = 41;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                                    n73 = 119;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                                    n73 = 9;
                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                default: {
                                                                                                                                                                                                                    n73 = 27;
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                            cArray70[n72] = (char)(c6 ^ n73);
                                                                                                                                                                                                            ++n4;
                                                                                                                                                                                                            cArray48 = cArray71;
                                                                                                                                                                                                            n50 = n50;
                                                                                                                                                                                                            if (n50 != 0) break;
                                                                                                                                                                                                            cArray71 = cArray48;
                                                                                                                                                                                                            n49 = n50;
                                                                                                                                                                                                            n72 = n50;
                                                                                                                                                                                                            cArray70 = cArray48;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        cArray47 = cArray48;
                                                                                                                                                                                                        n49 = n50;
                                                                                                                                                                                                    } while (n50 > n4);
                                                                                                                                                                                                }
                                                                                                                                                                                                stringArray[3] = new String(cArray47).intern();
                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                char[] cArray72 = "I]\u0016o}T\\\u001ak~H".toCharArray();
                                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                                int n74 = cArray72.length;
                                                                                                                                                                                                cArray46 = cArray72;
                                                                                                                                                                                                n48 = n74;
                                                                                                                                                                                                if (n74 <= 1) break block262;
                                                                                                                                                                                                cArray45 = cArray46;
                                                                                                                                                                                                n47 = n48;
                                                                                                                                                                                                if (n48 <= n4) break block263;
                                                                                                                                                                                            }
                                                                                                                                                                                            do {
                                                                                                                                                                                                char[] cArray73 = cArray46;
                                                                                                                                                                                                char[] cArray74 = cArray46;
                                                                                                                                                                                                int n75 = n4;
                                                                                                                                                                                                while (true) {
                                                                                                                                                                                                    int n76;
                                                                                                                                                                                                    char c7 = cArray73[n75];
                                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                                        case 0: {
                                                                                                                                                                                                            n76 = 58;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 1: {
                                                                                                                                                                                                            n76 = 41;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 2: {
                                                                                                                                                                                                            n76 = 119;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        case 3: {
                                                                                                                                                                                                            n76 = 9;
                                                                                                                                                                                                            break;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        default: {
                                                                                                                                                                                                            n76 = 27;
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                    cArray73[n75] = (char)(c7 ^ n76);
                                                                                                                                                                                                    ++n4;
                                                                                                                                                                                                    cArray46 = cArray74;
                                                                                                                                                                                                    n48 = n48;
                                                                                                                                                                                                    if (n48 != 0) break;
                                                                                                                                                                                                    cArray74 = cArray46;
                                                                                                                                                                                                    n47 = n48;
                                                                                                                                                                                                    n75 = n48;
                                                                                                                                                                                                    cArray73 = cArray46;
                                                                                                                                                                                                }
                                                                                                                                                                                                cArray45 = cArray46;
                                                                                                                                                                                                n47 = n48;
                                                                                                                                                                                            } while (n48 > n4);
                                                                                                                                                                                        }
                                                                                                                                                                                        stringArray[4] = new String(cArray45).intern();
                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                        char[] cArray75 = "_Q\u0003lu^L\u0013ErTL\u0004HyU_\u0012".toCharArray();
                                                                                                                                                                                        n4 = 0;
                                                                                                                                                                                        int n77 = cArray75.length;
                                                                                                                                                                                        cArray44 = cArray75;
                                                                                                                                                                                        n46 = n77;
                                                                                                                                                                                        if (n77 <= 1) break block264;
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                        if (n46 <= n4) break block265;
                                                                                                                                                                                    }
                                                                                                                                                                                    do {
                                                                                                                                                                                        char[] cArray76 = cArray44;
                                                                                                                                                                                        char[] cArray77 = cArray44;
                                                                                                                                                                                        int n78 = n4;
                                                                                                                                                                                        while (true) {
                                                                                                                                                                                            int n79;
                                                                                                                                                                                            char c8 = cArray76[n78];
                                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                                case 0: {
                                                                                                                                                                                                    n79 = 58;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 1: {
                                                                                                                                                                                                    n79 = 41;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 2: {
                                                                                                                                                                                                    n79 = 119;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                case 3: {
                                                                                                                                                                                                    n79 = 9;
                                                                                                                                                                                                    break;
                                                                                                                                                                                                }
                                                                                                                                                                                                default: {
                                                                                                                                                                                                    n79 = 27;
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                            cArray76[n78] = (char)(c8 ^ n79);
                                                                                                                                                                                            ++n4;
                                                                                                                                                                                            cArray44 = cArray77;
                                                                                                                                                                                            n46 = n46;
                                                                                                                                                                                            if (n46 != 0) break;
                                                                                                                                                                                            cArray77 = cArray44;
                                                                                                                                                                                            n45 = n46;
                                                                                                                                                                                            n78 = n46;
                                                                                                                                                                                            cArray76 = cArray44;
                                                                                                                                                                                        }
                                                                                                                                                                                        cArray43 = cArray44;
                                                                                                                                                                                        n45 = n46;
                                                                                                                                                                                    } while (n46 > n4);
                                                                                                                                                                                }
                                                                                                                                                                                stringArray[5] = new String(cArray43).intern();
                                                                                                                                                                                var0 = null;
                                                                                                                                                                                char[] cArray78 = "i]\u0016o}v@\u0019lRTM\u0012q".toCharArray();
                                                                                                                                                                                n4 = 0;
                                                                                                                                                                                int n80 = cArray78.length;
                                                                                                                                                                                cArray42 = cArray78;
                                                                                                                                                                                n44 = n80;
                                                                                                                                                                                if (n80 <= 1) break block266;
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                                if (n44 <= n4) break block267;
                                                                                                                                                                            }
                                                                                                                                                                            do {
                                                                                                                                                                                char[] cArray79 = cArray42;
                                                                                                                                                                                char[] cArray80 = cArray42;
                                                                                                                                                                                int n81 = n4;
                                                                                                                                                                                while (true) {
                                                                                                                                                                                    int n82;
                                                                                                                                                                                    char c9 = cArray79[n81];
                                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                                        case 0: {
                                                                                                                                                                                            n82 = 58;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 1: {
                                                                                                                                                                                            n82 = 41;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 2: {
                                                                                                                                                                                            n82 = 119;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        case 3: {
                                                                                                                                                                                            n82 = 9;
                                                                                                                                                                                            break;
                                                                                                                                                                                        }
                                                                                                                                                                                        default: {
                                                                                                                                                                                            n82 = 27;
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                    cArray79[n81] = (char)(c9 ^ n82);
                                                                                                                                                                                    ++n4;
                                                                                                                                                                                    cArray42 = cArray80;
                                                                                                                                                                                    n44 = n44;
                                                                                                                                                                                    if (n44 != 0) break;
                                                                                                                                                                                    cArray80 = cArray42;
                                                                                                                                                                                    n43 = n44;
                                                                                                                                                                                    n81 = n44;
                                                                                                                                                                                    cArray79 = cArray42;
                                                                                                                                                                                }
                                                                                                                                                                                cArray41 = cArray42;
                                                                                                                                                                                n43 = n44;
                                                                                                                                                                            } while (n44 > n4);
                                                                                                                                                                        }
                                                                                                                                                                        stringArray[6] = new String(cArray41).intern();
                                                                                                                                                                        var0 = null;
                                                                                                                                                                        char[] cArray81 = "_Q\u0003lu^L\u0013ErTL\u0004K~VF\u0000".toCharArray();
                                                                                                                                                                        n4 = 0;
                                                                                                                                                                        int n83 = cArray81.length;
                                                                                                                                                                        cArray40 = cArray81;
                                                                                                                                                                        n42 = n83;
                                                                                                                                                                        if (n83 <= 1) break block268;
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                        if (n42 <= n4) break block269;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        char[] cArray82 = cArray40;
                                                                                                                                                                        char[] cArray83 = cArray40;
                                                                                                                                                                        int n84 = n4;
                                                                                                                                                                        while (true) {
                                                                                                                                                                            int n85;
                                                                                                                                                                            char c10 = cArray82[n84];
                                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                                case 0: {
                                                                                                                                                                                    n85 = 58;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 1: {
                                                                                                                                                                                    n85 = 41;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 2: {
                                                                                                                                                                                    n85 = 119;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                case 3: {
                                                                                                                                                                                    n85 = 9;
                                                                                                                                                                                    break;
                                                                                                                                                                                }
                                                                                                                                                                                default: {
                                                                                                                                                                                    n85 = 27;
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                            cArray82[n84] = (char)(c10 ^ n85);
                                                                                                                                                                            ++n4;
                                                                                                                                                                            cArray40 = cArray83;
                                                                                                                                                                            n42 = n42;
                                                                                                                                                                            if (n42 != 0) break;
                                                                                                                                                                            cArray83 = cArray40;
                                                                                                                                                                            n41 = n42;
                                                                                                                                                                            n84 = n42;
                                                                                                                                                                            cArray82 = cArray40;
                                                                                                                                                                        }
                                                                                                                                                                        cArray39 = cArray40;
                                                                                                                                                                        n41 = n42;
                                                                                                                                                                    } while (n42 > n4);
                                                                                                                                                                }
                                                                                                                                                                stringArray[7] = new String(cArray39).intern();
                                                                                                                                                                var0 = null;
                                                                                                                                                                char[] cArray84 = "C\u001b".toCharArray();
                                                                                                                                                                n4 = 0;
                                                                                                                                                                int n86 = cArray84.length;
                                                                                                                                                                cArray38 = cArray84;
                                                                                                                                                                n40 = n86;
                                                                                                                                                                if (n86 <= 1) break block270;
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                                if (n40 <= n4) break block271;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                char[] cArray85 = cArray38;
                                                                                                                                                                char[] cArray86 = cArray38;
                                                                                                                                                                int n87 = n4;
                                                                                                                                                                while (true) {
                                                                                                                                                                    int n88;
                                                                                                                                                                    char c11 = cArray85[n87];
                                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                                        case 0: {
                                                                                                                                                                            n88 = 58;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 1: {
                                                                                                                                                                            n88 = 41;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 2: {
                                                                                                                                                                            n88 = 119;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        case 3: {
                                                                                                                                                                            n88 = 9;
                                                                                                                                                                            break;
                                                                                                                                                                        }
                                                                                                                                                                        default: {
                                                                                                                                                                            n88 = 27;
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    cArray85[n87] = (char)(c11 ^ n88);
                                                                                                                                                                    ++n4;
                                                                                                                                                                    cArray38 = cArray86;
                                                                                                                                                                    n40 = n40;
                                                                                                                                                                    if (n40 != 0) break;
                                                                                                                                                                    cArray86 = cArray38;
                                                                                                                                                                    n39 = n40;
                                                                                                                                                                    n87 = n40;
                                                                                                                                                                    cArray85 = cArray38;
                                                                                                                                                                }
                                                                                                                                                                cArray37 = cArray38;
                                                                                                                                                                n39 = n40;
                                                                                                                                                            } while (n40 > n4);
                                                                                                                                                        }
                                                                                                                                                        stringArray[8] = new String(cArray37).intern();
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray87 = "IL\u001blxNL\u0013".toCharArray();
                                                                                                                                                        n4 = 0;
                                                                                                                                                        int n89 = cArray87.length;
                                                                                                                                                        cArray36 = cArray87;
                                                                                                                                                        n38 = n89;
                                                                                                                                                        if (n89 <= 1) break block272;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                        if (n38 <= n4) break block273;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray88 = cArray36;
                                                                                                                                                        char[] cArray89 = cArray36;
                                                                                                                                                        int n90 = n4;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n91;
                                                                                                                                                            char c12 = cArray88[n90];
                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n91 = 58;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n91 = 41;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n91 = 119;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n91 = 9;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n91 = 27;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray88[n90] = (char)(c12 ^ n91);
                                                                                                                                                            ++n4;
                                                                                                                                                            cArray36 = cArray89;
                                                                                                                                                            n38 = n38;
                                                                                                                                                            if (n38 != 0) break;
                                                                                                                                                            cArray89 = cArray36;
                                                                                                                                                            n37 = n38;
                                                                                                                                                            n90 = n38;
                                                                                                                                                            cArray88 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                    } while (n38 > n4);
                                                                                                                                                }
                                                                                                                                                stringArray[9] = new String(cArray35).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray90 = "B\u001b".toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n92 = cArray90.length;
                                                                                                                                                cArray34 = cArray90;
                                                                                                                                                n36 = n92;
                                                                                                                                                if (n92 <= 1) break block274;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                                if (n36 <= n4) break block275;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray91 = cArray34;
                                                                                                                                                char[] cArray92 = cArray34;
                                                                                                                                                int n93 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n94;
                                                                                                                                                    char c13 = cArray91[n93];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n94 = 58;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n94 = 41;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n94 = 119;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n94 = 9;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n94 = 27;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray91[n93] = (char)(c13 ^ n94);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray92;
                                                                                                                                                    n36 = n36;
                                                                                                                                                    if (n36 != 0) break;
                                                                                                                                                    cArray92 = cArray34;
                                                                                                                                                    n35 = n36;
                                                                                                                                                    n93 = n36;
                                                                                                                                                    cArray91 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                            } while (n36 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[10] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray93 = "C\u0018".toCharArray();
                                                                                                                                        n4 = 0;
                                                                                                                                        int n95 = cArray93.length;
                                                                                                                                        cArray32 = cArray93;
                                                                                                                                        n34 = n95;
                                                                                                                                        if (n95 <= 1) break block276;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                        if (n34 <= n4) break block277;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray94 = cArray32;
                                                                                                                                        char[] cArray95 = cArray32;
                                                                                                                                        int n96 = n4;
                                                                                                                                        while (true) {
                                                                                                                                            int n97;
                                                                                                                                            char c14 = cArray94[n96];
                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n97 = 58;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n97 = 41;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n97 = 119;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n97 = 9;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n97 = 27;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray94[n96] = (char)(c14 ^ n97);
                                                                                                                                            ++n4;
                                                                                                                                            cArray32 = cArray95;
                                                                                                                                            n34 = n34;
                                                                                                                                            if (n34 != 0) break;
                                                                                                                                            cArray95 = cArray32;
                                                                                                                                            n33 = n34;
                                                                                                                                            n96 = n34;
                                                                                                                                            cArray94 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                    } while (n34 > n4);
                                                                                                                                }
                                                                                                                                stringArray[11] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray96 = "i]\u0016o}v@\u0019l".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n98 = cArray96.length;
                                                                                                                                cArray30 = cArray96;
                                                                                                                                n32 = n98;
                                                                                                                                if (n98 <= 1) break block278;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block279;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray97 = cArray30;
                                                                                                                                char[] cArray98 = cArray30;
                                                                                                                                int n99 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n100;
                                                                                                                                    char c15 = cArray97[n99];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n100 = 58;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n100 = 41;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n100 = 119;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n100 = 9;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n100 = 27;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray97[n99] = (char)(c15 ^ n100);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray98;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray98 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n99 = n32;
                                                                                                                                    cArray97 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[12] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray99 = "B\u0018".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n101 = cArray99.length;
                                                                                                                        cArray28 = cArray99;
                                                                                                                        n30 = n101;
                                                                                                                        if (n101 <= 1) break block280;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block281;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray100 = cArray28;
                                                                                                                        char[] cArray101 = cArray28;
                                                                                                                        int n102 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n103;
                                                                                                                            char c16 = cArray100[n102];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n103 = 58;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n103 = 41;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n103 = 119;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n103 = 9;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n103 = 27;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray100[n102] = (char)(c16 ^ n103);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray101;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray101 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n102 = n30;
                                                                                                                            cArray100 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[13] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray102 = "@F\u0018d".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n104 = cArray102.length;
                                                                                                                cArray26 = cArray102;
                                                                                                                n28 = n104;
                                                                                                                if (n104 <= 1) break block282;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block283;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray103 = cArray26;
                                                                                                                char[] cArray104 = cArray26;
                                                                                                                int n105 = n4;
                                                                                                                while (true) {
                                                                                                                    int n106;
                                                                                                                    char c17 = cArray103[n105];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n106 = 58;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n106 = 41;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n106 = 119;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n106 = 9;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n106 = 27;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray103[n105] = (char)(c17 ^ n106);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray104;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray104 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n105 = n28;
                                                                                                                    cArray103 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[14] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray105 = "t\\\u001be;sG\u0004)".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n107 = cArray105.length;
                                                                                                        cArray24 = cArray105;
                                                                                                        n26 = n107;
                                                                                                        if (n107 <= 1) break block284;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block285;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray106 = cArray24;
                                                                                                        char[] cArray107 = cArray24;
                                                                                                        int n108 = n4;
                                                                                                        while (true) {
                                                                                                            int n109;
                                                                                                            char c18 = cArray106[n108];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n109 = 58;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n109 = 41;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n109 = 119;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n109 = 9;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n109 = 27;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray106[n108] = (char)(c18 ^ n109);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray107;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray107 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n108 = n26;
                                                                                                            cArray106 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[15] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray108 = "sG\u0004)rTM\u0012q;U\\\u0003)t\\\t\u0005hu]L".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n110 = cArray108.length;
                                                                                                cArray22 = cArray108;
                                                                                                n24 = n110;
                                                                                                if (n110 <= 1) break block286;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block287;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray109 = cArray22;
                                                                                                char[] cArray110 = cArray22;
                                                                                                int n111 = n4;
                                                                                                while (true) {
                                                                                                    int n112;
                                                                                                    char c19 = cArray109[n111];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n112 = 58;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n112 = 41;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n112 = 119;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n112 = 9;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n112 = 27;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray109[n111] = (char)(c19 ^ n112);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray110;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray110 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n111 = n24;
                                                                                                    cArray109 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[16] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray111 = "sg3LC".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n113 = cArray111.length;
                                                                                        cArray20 = cArray111;
                                                                                        n22 = n113;
                                                                                        if (n113 <= 1) break block288;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block289;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray112 = cArray20;
                                                                                        char[] cArray113 = cArray20;
                                                                                        int n114 = n4;
                                                                                        while (true) {
                                                                                            int n115;
                                                                                            char c20 = cArray112[n114];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n115 = 58;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n115 = 41;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n115 = 119;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n115 = 9;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n115 = 27;
                                                                                                }
                                                                                            }
                                                                                            cArray112[n114] = (char)(c20 ^ n115);
                                                                                            ++n4;
                                                                                            cArray20 = cArray113;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray113 = cArray20;
                                                                                            n21 = n22;
                                                                                            n114 = n22;
                                                                                            cArray112 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[17] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray114 = "ye2OH\u007f}5PS{g3".toCharArray();
                                                                                n4 = 0;
                                                                                int n116 = cArray114.length;
                                                                                cArray18 = cArray114;
                                                                                n20 = n116;
                                                                                if (n116 <= 1) break block290;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block291;
                                                                            }
                                                                            do {
                                                                                char[] cArray115 = cArray18;
                                                                                char[] cArray116 = cArray18;
                                                                                int n117 = n4;
                                                                                while (true) {
                                                                                    int n118;
                                                                                    char c21 = cArray115[n117];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n118 = 58;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n118 = 41;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n118 = 119;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n118 = 9;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n118 = 27;
                                                                                        }
                                                                                    }
                                                                                    cArray115[n117] = (char)(c21 ^ n118);
                                                                                    ++n4;
                                                                                    cArray18 = cArray116;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray116 = cArray18;
                                                                                    n19 = n20;
                                                                                    n117 = n20;
                                                                                    cArray115 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[18] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray117 = "sg$]Iod2GOsg3LC".toCharArray();
                                                                        n4 = 0;
                                                                        int n119 = cArray117.length;
                                                                        cArray16 = cArray117;
                                                                        n18 = n119;
                                                                        if (n119 <= 1) break block292;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block293;
                                                                    }
                                                                    do {
                                                                        char[] cArray118 = cArray16;
                                                                        char[] cArray119 = cArray16;
                                                                        int n120 = n4;
                                                                        while (true) {
                                                                            int n121;
                                                                            char c22 = cArray118[n120];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n121 = 58;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n121 = 41;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n121 = 119;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n121 = 9;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n121 = 27;
                                                                                }
                                                                            }
                                                                            cArray118[n120] = (char)(c22 ^ n121);
                                                                            ++n4;
                                                                            cArray16 = cArray119;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray119 = cArray16;
                                                                            n17 = n18;
                                                                            n120 = n18;
                                                                            cArray118 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[19] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray120 = "sg$@U~l/Z^nk.AZtm".toCharArray();
                                                                n4 = 0;
                                                                int n122 = cArray120.length;
                                                                cArray14 = cArray120;
                                                                n16 = n122;
                                                                if (n122 <= 1) break block294;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block295;
                                                            }
                                                            do {
                                                                char[] cArray121 = cArray14;
                                                                char[] cArray122 = cArray14;
                                                                int n123 = n4;
                                                                while (true) {
                                                                    int n124;
                                                                    char c23 = cArray121[n123];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n124 = 58;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n124 = 41;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n124 = 119;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n124 = 9;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n124 = 27;
                                                                        }
                                                                    }
                                                                    cArray121[n123] = (char)(c23 ^ n124);
                                                                    ++n4;
                                                                    cArray14 = cArray122;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray122 = cArray14;
                                                                    n15 = n16;
                                                                    n123 = n16;
                                                                    cArray121 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[20] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray123 = "ql.ZR}g\"DZyj".toCharArray();
                                                        n4 = 0;
                                                        int n125 = cArray123.length;
                                                        cArray12 = cArray123;
                                                        n14 = n125;
                                                        if (n125 <= 1) break block296;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block297;
                                                    }
                                                    do {
                                                        char[] cArray124 = cArray12;
                                                        char[] cArray125 = cArray12;
                                                        int n126 = n4;
                                                        while (true) {
                                                            int n127;
                                                            char c24 = cArray124[n126];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n127 = 58;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n127 = 41;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n127 = 119;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n127 = 9;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n127 = 27;
                                                                }
                                                            }
                                                            cArray124[n126] = (char)(c24 ^ n127);
                                                            ++n4;
                                                            cArray12 = cArray125;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray125 = cArray12;
                                                            n13 = n14;
                                                            n126 = n14;
                                                            cArray124 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[21] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray126 = "\u007fq#LU~l3ERtl$K^vf ".toCharArray();
                                                n4 = 0;
                                                int n128 = cArray126.length;
                                                cArray10 = cArray126;
                                                n12 = n128;
                                                if (n128 <= 1) break block298;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block299;
                                            }
                                            do {
                                                char[] cArray127 = cArray10;
                                                char[] cArray128 = cArray10;
                                                int n129 = n4;
                                                while (true) {
                                                    int n130;
                                                    char c25 = cArray127[n129];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n130 = 58;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n130 = 41;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n130 = 119;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n130 = 9;
                                                            break;
                                                        }
                                                        default: {
                                                            n130 = 27;
                                                        }
                                                    }
                                                    cArray127[n129] = (char)(c25 ^ n130);
                                                    ++n4;
                                                    cArray10 = cArray128;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray128 = cArray10;
                                                    n11 = n12;
                                                    n129 = n12;
                                                    cArray127 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[22] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray129 = "\u007fq#LU~l3ERtl$HYu\u007f2".toCharArray();
                                        n4 = 0;
                                        int n131 = cArray129.length;
                                        cArray8 = cArray129;
                                        n10 = n131;
                                        if (n131 <= 1) break block300;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block301;
                                    }
                                    do {
                                        char[] cArray130 = cArray8;
                                        char[] cArray131 = cArray8;
                                        int n132 = n4;
                                        while (true) {
                                            int n133;
                                            char c26 = cArray130[n132];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n133 = 58;
                                                    break;
                                                }
                                                case 1: {
                                                    n133 = 41;
                                                    break;
                                                }
                                                case 2: {
                                                    n133 = 119;
                                                    break;
                                                }
                                                case 3: {
                                                    n133 = 9;
                                                    break;
                                                }
                                                default: {
                                                    n133 = 27;
                                                }
                                            }
                                            cArray130[n132] = (char)(c26 ^ n133);
                                            ++n4;
                                            cArray8 = cArray131;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray131 = cArray8;
                                            n9 = n10;
                                            n132 = n10;
                                            cArray130 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[23] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray132 = "ql.ZR}}.Y^".toCharArray();
                                n4 = 0;
                                int n134 = cArray132.length;
                                cArray6 = cArray132;
                                n8 = n134;
                                if (n134 <= 1) break block302;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block303;
                            }
                            do {
                                char[] cArray133 = cArray6;
                                char[] cArray134 = cArray6;
                                int n135 = n4;
                                while (true) {
                                    int n136;
                                    char c27 = cArray133[n135];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n136 = 58;
                                            break;
                                        }
                                        case 1: {
                                            n136 = 41;
                                            break;
                                        }
                                        case 2: {
                                            n136 = 119;
                                            break;
                                        }
                                        case 3: {
                                            n136 = 9;
                                            break;
                                        }
                                        default: {
                                            n136 = 27;
                                        }
                                    }
                                    cArray133[n135] = (char)(c27 ^ n136);
                                    ++n4;
                                    cArray6 = cArray134;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray134 = cArray6;
                                    n7 = n8;
                                    n135 = n8;
                                    cArray133 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[24] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray135 = "ye2O".toCharArray();
                        n4 = 0;
                        int n137 = cArray135.length;
                        cArray4 = cArray135;
                        n6 = n137;
                        if (n137 <= 1) break block304;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block305;
                    }
                    do {
                        char[] cArray136 = cArray4;
                        char[] cArray137 = cArray4;
                        int n138 = n4;
                        while (true) {
                            int n139;
                            char c28 = cArray136[n138];
                            switch (n4 % 5) {
                                case 0: {
                                    n139 = 58;
                                    break;
                                }
                                case 1: {
                                    n139 = 41;
                                    break;
                                }
                                case 2: {
                                    n139 = 119;
                                    break;
                                }
                                case 3: {
                                    n139 = 9;
                                    break;
                                }
                                default: {
                                    n139 = 27;
                                }
                            }
                            cArray136[n138] = (char)(c28 ^ n139);
                            ++n4;
                            cArray4 = cArray137;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray137 = cArray4;
                            n5 = n6;
                            n138 = n6;
                            cArray136 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[25] = new String(cArray3).intern();
                var0 = null;
                char[] cArray138 = "ql.ZR}z2]Yca6G_".toCharArray();
                n4 = 0;
                int n140 = cArray138.length;
                cArray2 = cArray138;
                n3 = n140;
                if (n140 <= 1) break block306;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block307;
            }
            do {
                char[] cArray139 = cArray2;
                char[] cArray140 = cArray2;
                int n141 = n4;
                while (true) {
                    int n142;
                    char c29 = cArray139[n141];
                    switch (n4 % 5) {
                        case 0: {
                            n142 = 58;
                            break;
                        }
                        case 1: {
                            n142 = 41;
                            break;
                        }
                        case 2: {
                            n142 = 119;
                            break;
                        }
                        case 3: {
                            n142 = 9;
                            break;
                        }
                        default: {
                            n142 = 27;
                        }
                    }
                    cArray139[n141] = (char)(c29 ^ n142);
                    ++n4;
                    cArray2 = cArray140;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray140 = cArray2;
                    n2 = n3;
                    n141 = n3;
                    cArray139 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[26] = new String(cArray).intern();
        O = stringArray;
    }
}

