/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.AbstractMemberWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;

public abstract class AbstractExecutableMemberWriter
extends AbstractMemberWriter {
    public AbstractExecutableMemberWriter(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        super(subWriterHolderWriter, classDoc);
    }

    public AbstractExecutableMemberWriter(SubWriterHolderWriter subWriterHolderWriter) {
        super(subWriterHolderWriter);
    }

    protected int writeTypeParameters(ExecutableMemberDoc executableMemberDoc) {
        LinkInfoImpl linkInfoImpl = new LinkInfoImpl(32, executableMemberDoc, false);
        String string = this.writer.getTypeParameterLinks(linkInfoImpl);
        if (linkInfoImpl.displayLength > 0) {
            this.writer.print(string + " ");
            this.writer.displayLength += linkInfoImpl.displayLength + 1;
        }
        return linkInfoImpl.displayLength;
    }

    protected void writeSignature(ExecutableMemberDoc executableMemberDoc) {
        this.writer.displayLength = 0;
        this.writer.pre();
        this.writer.writeAnnotationInfo(executableMemberDoc);
        this.printModifiers(executableMemberDoc);
        this.writeTypeParameters(executableMemberDoc);
        if (this.configuration().linksource && executableMemberDoc.position().line() != this.classdoc.position().line()) {
            this.writer.printSrcLink(executableMemberDoc, executableMemberDoc.name());
        } else {
            this.bold(executableMemberDoc.name());
        }
        this.writeParameters(executableMemberDoc);
        this.writeExceptions(executableMemberDoc);
        this.writer.preEnd();
    }

    protected void writeDeprecatedLink(ProgramElementDoc programElementDoc) {
        ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
        this.writer.printDocLink(3, executableMemberDoc, executableMemberDoc.qualifiedName() + executableMemberDoc.flatSignature(), false);
    }

    protected void writeSummaryLink(int n, ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
        String string = executableMemberDoc.name();
        this.writer.bold();
        this.writer.printDocLink(n, classDoc, executableMemberDoc, string, false);
        this.writer.boldEnd();
        this.writer.displayLength = string.length();
        this.writeParameters(executableMemberDoc, false);
    }

    protected void writeInheritedSummaryLink(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.writer.printDocLink(3, classDoc, (MemberDoc)programElementDoc, programElementDoc.name(), false);
    }

    protected void writeParam(ExecutableMemberDoc executableMemberDoc, Parameter parameter, boolean bl) {
        if (parameter.type() != null) {
            this.writer.printLink(new LinkInfoImpl(18, parameter.type(), bl));
        }
        if (parameter.name().length() > 0) {
            this.writer.space();
            this.writer.print(parameter.name());
        }
    }

    protected void writeParameters(ExecutableMemberDoc executableMemberDoc) {
        this.writeParameters(executableMemberDoc, true);
    }

    protected void writeParameters(ExecutableMemberDoc executableMemberDoc, boolean bl) {
        boolean bl2;
        this.print('(');
        Parameter[] parameterArray = executableMemberDoc.parameters();
        String string = this.makeSpace(this.writer.displayLength);
        if (this.configuration().linksource) {
            string = string + this.makeSpace(executableMemberDoc.name().length());
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            Parameter parameter = parameterArray[i];
            if (parameter.name().startsWith("this$")) continue;
            if (bl && (bl2 = this.writer.writeAnnotationInfo(string.length(), executableMemberDoc, parameter))) {
                this.writer.println();
                this.writer.print(string);
            }
            this.writeParam(executableMemberDoc, parameter, i == parameterArray.length - 1 && executableMemberDoc.isVarArgs());
            break;
        }
        for (int i = i + 1; i < parameterArray.length; ++i) {
            this.writer.print(',');
            this.writer.println();
            this.writer.print(string);
            if (bl && (bl2 = this.writer.writeAnnotationInfo(string.length(), executableMemberDoc, parameterArray[i]))) {
                this.writer.println();
                this.writer.print(string);
            }
            this.writeParam(executableMemberDoc, parameterArray[i], i == parameterArray.length - 1 && executableMemberDoc.isVarArgs());
        }
        this.writer.print(')');
    }

    protected void writeExceptions(ExecutableMemberDoc executableMemberDoc) {
        Type[] typeArray = executableMemberDoc.thrownExceptionTypes();
        if (typeArray.length > 0) {
            LinkInfoImpl linkInfoImpl = new LinkInfoImpl(3, executableMemberDoc, false);
            int n = this.getReturnTypeLength(executableMemberDoc);
            this.writer.getTypeParameterLinks(linkInfoImpl);
            String string = this.makeSpace(this.modifierString(executableMemberDoc).length() + executableMemberDoc.name().length() + (n += linkInfoImpl.displayLength == 0 ? 0 : linkInfoImpl.displayLength + 1) - 4);
            this.writer.println();
            this.writer.print(string);
            this.writer.print("throws ");
            string = string + "       ";
            this.writer.printLink(new LinkInfoImpl(3, typeArray[0]));
            for (int i = 1; i < typeArray.length; ++i) {
                this.writer.println(",");
                this.writer.print(string);
                this.writer.printLink(new LinkInfoImpl(3, typeArray[i]));
            }
        }
    }

    protected int getReturnTypeLength(ExecutableMemberDoc executableMemberDoc) {
        if (executableMemberDoc instanceof MethodDoc) {
            MethodDoc methodDoc = (MethodDoc)executableMemberDoc;
            Type type = methodDoc.returnType();
            if (type.isPrimitive()) {
                return type.typeName().length() + type.dimension().length();
            }
            LinkInfoImpl linkInfoImpl = new LinkInfoImpl(3, type);
            this.writer.getLink(linkInfoImpl);
            return linkInfoImpl.displayLength;
        }
        return -1;
    }

    protected ClassDoc implementsMethodInIntfac(MethodDoc methodDoc, ClassDoc[] classDocArray) {
        for (int i = 0; i < classDocArray.length; ++i) {
            MethodDoc[] methodDocArray = classDocArray[i].methods();
            if (methodDocArray.length <= 0) continue;
            for (int j = 0; j < methodDocArray.length; ++j) {
                if (!methodDocArray[j].name().equals(methodDoc.name()) || !methodDocArray[j].signature().equals(methodDoc.signature())) continue;
                return classDocArray[i];
            }
        }
        return null;
    }

    protected String getErasureAnchor(ExecutableMemberDoc executableMemberDoc) {
        StringBuffer stringBuffer = new StringBuffer(executableMemberDoc.name() + "(");
        Parameter[] parameterArray = executableMemberDoc.parameters();
        boolean bl = false;
        for (int i = 0; i < parameterArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            Type type = parameterArray[i].type();
            bl = bl || type.asTypeVariable() != null;
            stringBuffer.append(type.isPrimitive() ? type.typeName() : type.asClassDoc().qualifiedName());
        }
        stringBuffer.append(")");
        return bl ? stringBuffer.toString() : null;
    }
}

