/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Diagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check {
    protected static final Context.Key<Check> checkKey = new Context.Key();
    private final Name.Table names;
    private final Log log;
    private final Symtab syms;
    private final Infer infer;
    private final Target target;
    private final Source source;
    private final Name classDollar;
    private final Name thisDollar;
    private final Types types;
    private final boolean skipAnnotations;
    private Lint lint;
    boolean allowGenerics;
    boolean allowVariance;
    boolean allowAnnotations;
    boolean complexInference;
    public Map<Name, Symbol.ClassSymbol> compiled = new HashMap<Name, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private Validator validator = new Validator();
    Warner overrideWarner = new Warner();

    public static Check instance(Context context) {
        Check check = context.get(checkKey);
        if (check == null) {
            check = new Check(context);
        }
        return check;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        Options options = Options.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.lint = Lint.instance(context);
        this.classDollar = this.names.fromString("class" + this.target.syntheticNameChar());
        this.thisDollar = this.names.fromString("this" + this.target.syntheticNameChar());
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowAnnotations = source.allowAnnotations();
        this.complexInference = options.get("-complexinference") != null;
        this.skipAnnotations = options.get("skipAnnotations") != null;
        boolean bl = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean bl2 = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        this.deprecationHandler = new MandatoryWarningHandler(this.log, bl, "deprecated");
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, bl2, "unchecked");
    }

    Lint setLint(Lint lint) {
        Lint lint2 = this.lint;
        this.lint = lint;
        return lint2;
    }

    void warnDeprecated(int n, Symbol symbol) {
        if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            this.deprecationHandler.report(n, "has.been.deprecated", symbol, symbol.location());
        }
    }

    public void warnUnchecked(int n, String string, Object ... objectArray) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(n, string, objectArray);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
    }

    public Type completionError(int n, Symbol.CompletionFailure completionFailure) {
        this.log.error(n, "cant.access", completionFailure.sym, completionFailure.errmsg);
        if (completionFailure instanceof ClassReader.BadClassFile) {
            throw new Abort();
        }
        return this.syms.errType;
    }

    Type typeError(int n, Object object, Type type, Type type2) {
        this.log.error(n, "prob.found.req", object, type, type2);
        return this.syms.errType;
    }

    Type typeError(int n, String string, Type type, Type type2, Object object) {
        this.log.error(n, "prob.found.req.1", string, type, type2, object);
        return this.syms.errType;
    }

    Type typeTagError(int n, Object object, Object object2) {
        this.log.error(n, "type.found.req", object2, object);
        return this.syms.errType;
    }

    void earlyRefError(int n, Symbol symbol) {
        this.log.error(n, "cant.ref.before.ctor.called", symbol);
    }

    void duplicateError(int n, Symbol symbol) {
        if (!symbol.type.isErroneous()) {
            this.log.error(n, "already.defined", symbol, symbol.location());
        }
    }

    void duplicateErasureError(int n, Symbol symbol, Symbol symbol2) {
        if (!symbol.type.isErroneous() && !symbol2.type.isErroneous()) {
            this.log.error(n, "name.clash.same.erasure", symbol, symbol2);
        }
    }

    void checkTransparentVar(int n, Symbol.VarSymbol varSymbol, Scope scope) {
        if (scope.next != null) {
            Scope.Entry entry = scope.next.lookup(varSymbol.name);
            while (entry.scope != null && entry.sym.owner == varSymbol.owner) {
                if (entry.sym.kind == 4 && (entry.sym.owner.kind & 0x14) != 0 && varSymbol.name != this.names.error) {
                    this.duplicateError(n, entry.sym);
                    return;
                }
                entry = entry.next();
            }
        }
    }

    void checkTransparentClass(int n, Symbol.ClassSymbol classSymbol, Scope scope) {
        if (scope.next != null) {
            Scope.Entry entry = scope.next.lookup(classSymbol.name);
            while (entry.scope != null && entry.sym.owner == classSymbol.owner) {
                if (entry.sym.kind == 2 && (entry.sym.owner.kind & 0x14) != 0 && classSymbol.name != this.names.error) {
                    this.duplicateError(n, entry.sym);
                    return;
                }
                entry = entry.next();
            }
        }
    }

    boolean checkUniqueClassName(int n, Name name, Scope scope) {
        Object object = scope.lookup(name);
        while (((Scope.Entry)object).scope == scope) {
            if (((Scope.Entry)object).sym.kind == 2 && ((Scope.Entry)object).sym.name != this.names.error) {
                this.duplicateError(n, ((Scope.Entry)object).sym);
                return false;
            }
            object = ((Scope.Entry)object).next();
        }
        object = scope.owner;
        while (object != null) {
            if (((Symbol)object).kind == 2 && ((Symbol)object).name == name && ((Symbol)object).name != this.names.error) {
                this.duplicateError(n, (Symbol)object);
                return true;
            }
            object = ((Symbol)object).owner;
        }
        return true;
    }

    Name localClassName(Symbol.ClassSymbol classSymbol) {
        Symbol.ClassSymbol classSymbol2 = classSymbol.outermostClass();
        int n = 1;
        Name name;
        while (this.compiled.get(name = this.names.fromString("" + classSymbol.owner.enclClass().flatname + this.target.syntheticNameChar() + n + classSymbol.name)) != null) {
            ++n;
        }
        return name;
    }

    Type checkType(int n, Type type, Type type2) {
        if (type2.tag == 19) {
            return type2;
        }
        if (type.tag == 16) {
            return this.instantiatePoly(n, (Type.ForAll)type, type2, this.convertWarner(n, type, type2));
        }
        if (type2.tag == 18) {
            return type;
        }
        if (this.types.isAssignable(type, type2, this.convertWarner(n, type, type2))) {
            return type;
        }
        if (type.tag <= 7 && type2.tag <= 7) {
            return this.typeError(n, new Diagnostic("possible.loss.of.precision", new Object[0]), type, type2);
        }
        if (type.isSuperBound()) {
            this.log.error(n, "assignment.from.super-bound", type);
            return this.syms.errType;
        }
        if (type2.isExtendsBound()) {
            this.log.error(n, "assignment.to.extends-bound", type2);
            return this.syms.errType;
        }
        return this.typeError(n, new Diagnostic("incompatible.types", new Object[0]), type, type2);
    }

    Type instantiatePoly(int n, Type.ForAll forAll, Type type, Warner warner) {
        if (type == Infer.anyPoly && this.complexInference) {
            return forAll;
        }
        if (type == Infer.anyPoly || type.tag == 18) {
            Type type2 = forAll.qtype.tag <= 9 ? forAll.qtype : this.syms.objectType;
            return this.instantiatePoly(n, forAll, type2, warner);
        }
        if (type.tag == 19) {
            return type;
        }
        try {
            return this.infer.instantiateExpr(forAll, type, warner);
        }
        catch (Infer.NoInstanceException noInstanceException) {
            if (noInstanceException.isAmbiguous) {
                Diagnostic diagnostic = noInstanceException.getDiagnostic();
                this.log.error(n, "undetermined.type" + (diagnostic != null ? ".1" : ""), forAll, diagnostic);
                return this.syms.errType;
            }
            Diagnostic diagnostic = noInstanceException.getDiagnostic();
            return this.typeError(n, new Diagnostic("incompatible.types" + (diagnostic != null ? ".1" : ""), diagnostic), forAll, type);
        }
    }

    Type checkCastable(int n, Type type, Type type2) {
        if (type.tag == 16) {
            this.instantiatePoly(n, (Type.ForAll)type, type2, this.castWarner(n, type, type2));
            return type2;
        }
        if (this.types.isCastable(type, type2, this.castWarner(n, type, type2))) {
            return type2;
        }
        return this.typeError(n, new Diagnostic("inconvertible.types", new Object[0]), type, type2);
    }

    boolean isTypeVar(Type type) {
        return type.tag == 14 || type.tag == 11 && this.isTypeVar(this.types.elemtype(type));
    }

    private void checkExtends(int n, Type type, Type.TypeVar typeVar) {
        if (type.isUnbound()) {
            return;
        }
        if (type.tag != 15) {
            type = this.types.upperBound(type);
            List<Type> list = this.types.getBounds(typeVar);
            while (list.nonEmpty()) {
                if (!this.types.isSubType(type, (Type)list.head)) {
                    this.log.error(n, "not.within.bounds", type);
                    return;
                }
                list = list.tail;
            }
        } else if (type.isExtendsBound()) {
            if (!this.types.isCastable(typeVar.bound(), this.types.upperBound(type), Warner.noWarnings)) {
                this.log.error(n, "not.within.bounds", type);
            }
        } else if (type.isSuperBound() && this.types.notSoftSubtype(this.types.lowerBound(type), typeVar.bound())) {
            this.log.error(n, "not.within.bounds", type);
        }
    }

    Type checkNonVoid(int n, Type type) {
        if (type.tag == 9) {
            this.log.error(n, "void.not.allowed.here", new Object[0]);
            return this.syms.errType;
        }
        return type;
    }

    Type checkClassType(int n, Type type) {
        if (type.tag != 10 && type.tag != 19) {
            return this.typeTagError(n, new Diagnostic("type.req.class", new Object[0]), type.tag == 14 ? new Diagnostic("type.parameter", type) : type);
        }
        return type;
    }

    Type checkClassType(int n, Type type, boolean bl) {
        type = this.checkClassType(n, type);
        if (bl && type.isParameterized()) {
            List<Type> list = type.typarams();
            while (list.nonEmpty()) {
                if (((Type)list.head).tag == 15) {
                    return this.typeTagError(n, Log.getLocalizedString("type.req.exact", new Object[0]), list.head);
                }
                list = list.tail;
            }
        }
        return type;
    }

    Type checkReifiableReferenceType(int n, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 19) {
            return this.typeTagError(n, new Diagnostic("type.req.class.array", new Object[0]), type);
        }
        if (!this.types.isReifiable(type)) {
            this.log.error(n, "illegal.generic.type.for.instof", new Object[0]);
            return this.syms.errType;
        }
        return type;
    }

    Type checkRefType(int n, Type type) {
        switch (type.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                return type;
            }
        }
        return this.typeTagError(n, new Diagnostic("type.req.ref", new Object[0]), type);
    }

    Type checkNullOrRefType(int n, Type type) {
        switch (type.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                return type;
            }
        }
        return this.typeTagError(n, new Diagnostic("type.req.ref", new Object[0]), type);
    }

    boolean checkDisjoint(int n, long l, long l2, long l3) {
        if ((l & l2) != 0L && (l & l3) != 0L) {
            this.log.error(n, "illegal.combination.of.modifiers", TreeInfo.flagNames(TreeInfo.firstFlag(l & l2)), TreeInfo.flagNames(TreeInfo.firstFlag(l & l3)));
            return false;
        }
        return true;
    }

    long checkFlags(int n, long l, Symbol symbol, Tree tree) {
        long l2;
        long l3 = 0L;
        switch (symbol.kind) {
            case 4: {
                if (symbol.owner.kind != 2) {
                    l2 = 0x200000010L;
                    break;
                }
                if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    l3 = 25L;
                    l2 = 25L;
                    break;
                }
                l2 = 16607L;
                break;
            }
            case 16: {
                if (symbol.name == this.names.init) {
                    if ((symbol.owner.flags_field & 0x4000L) != 0L) {
                        l3 = 2L;
                        l2 = 2L;
                    } else {
                        l2 = 7L;
                    }
                } else if ((symbol.owner.flags_field & 0x200L) != 0L) {
                    l3 = 1025L;
                    l2 = 1025L;
                } else {
                    l2 = 3391L;
                }
                if (((l | l3) & 0x400L) != 0L) break;
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            case 2: {
                if (symbol.isLocal()) {
                    l2 = 19472L;
                    if (symbol.name.len == 0) {
                        l2 |= 8L;
                    }
                    if ((symbol.owner.flags_field & 8L) == 0L && (l & 0x4000L) != 0L) {
                        this.log.error(n, "enums.must.be.static", new Object[0]);
                    }
                } else if (symbol.owner.kind == 2) {
                    l2 = 19991L;
                    if (symbol.owner.owner.kind == 1 || (symbol.owner.flags_field & 8L) != 0L) {
                        l2 |= 8L;
                    } else if ((l & 0x4000L) != 0L) {
                        this.log.error(n, "enums.must.be.static", new Object[0]);
                    }
                    if ((l & 0x4200L) != 0L) {
                        l3 = 8L;
                    }
                } else {
                    l2 = 28177L;
                }
                if ((l & 0x200L) != 0L) {
                    l3 |= 0x400L;
                }
                if ((l & 0x4000L) != 0L) {
                    l2 &= 0xFFFFFFFFFFFFFBEFL;
                    l3 |= this.implicitEnumFinalFlag(tree);
                }
                l3 |= symbol.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long l4 = l & 0xFFFL & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
        if (l4 != 0L) {
            this.log.error(n, "mod.not.allowed.here", TreeInfo.flagNames(l4));
        } else if (symbol.kind != 2 && !this.checkDisjoint(n, l, 1024L, 10L) || !this.checkDisjoint(n, l, 1536L, 304L) || !this.checkDisjoint(n, l, 1L, 6L) || !this.checkDisjoint(n, l, 2L, 5L) || !this.checkDisjoint(n, l, 16L, 64L) || symbol.kind == 2 || this.checkDisjoint(n, l, 1280L, 2048L)) {
            // empty if block
        }
        return l & (l2 | 0xFFFFFFFFFFFFF000L) | l3;
    }

    private long implicitEnumFinalFlag(Tree tree) {
        if (tree.tag != 3) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends Tree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            public void visitTree(Tree tree) {
            }

            public void visitVarDef(Tree.VarDef varDef) {
                if ((varDef.mods.flags & 0x4000L) != 0L && varDef.init instanceof Tree.NewClass && ((Tree.NewClass)varDef.init).def != null) {
                    this.specialized = true;
                }
            }
        }
        SpecialTreeVisitor specialTreeVisitor = new SpecialTreeVisitor();
        Tree.ClassDef classDef = (Tree.ClassDef)tree;
        for (Tree tree2 : classDef.defs) {
            tree2.accept(specialTreeVisitor);
            if (!specialTreeVisitor.specialized) continue;
            return 0L;
        }
        return 16L;
    }

    void validate(Tree tree) {
        try {
            if (tree != null) {
                tree.accept(this.validator);
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(tree.pos, completionFailure);
        }
    }

    void validate(List<Tree> list) {
        List<Tree> list2 = list;
        while (list2.nonEmpty()) {
            this.validate((Tree)list2.head);
            list2 = list2.tail;
        }
    }

    void validateTypeParams(List<Tree.TypeParameter> list) {
        List<Tree.TypeParameter> list2 = list;
        while (list2.nonEmpty()) {
            this.validate((Tree)list2.head);
            list2 = list2.tail;
        }
    }

    boolean subset(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubType(type, (Type)list2.head)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    boolean intersects(Type type, List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.types.isSubType(type, (Type)list2.head) || this.types.isSubType((Type)list2.head, type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    List<Type> incl(Type type, List<Type> list) {
        return this.subset(type, list) ? list : this.excl(type, list).prepend(type);
    }

    List<Type> excl(Type type, List<Type> list) {
        if (list.isEmpty()) {
            return list;
        }
        List<Type> list2 = this.excl(type, list.tail);
        if (this.types.isSubType((Type)list.head, type)) {
            return list2;
        }
        if (list2 == list.tail) {
            return list;
        }
        return list2.prepend((Type)list.head);
    }

    List<Type> union(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.incl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    List<Type> diff(List<Type> list, List<Type> list2) {
        List<Type> list3 = list;
        List<Type> list4 = list2;
        while (list4.nonEmpty()) {
            list3 = this.excl((Type)list4.head, list3);
            list4 = list4.tail;
        }
        return list3;
    }

    public List<Type> intersect(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list2)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        list4 = list2;
        while (list4.nonEmpty()) {
            if (this.subset((Type)list4.head, list)) {
                list3 = this.incl((Type)list4.head, list3);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    boolean isUnchecked(Symbol.ClassSymbol classSymbol) {
        return classSymbol.kind == 31 || classSymbol.isSubClass(this.syms.errorType.tsym, this.types) || classSymbol.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type type) {
        return type.tag == 14 ? this.isUnchecked(this.types.supertype(type)) : (type.tag == 10 ? this.isUnchecked((Symbol.ClassSymbol)type.tsym) : type.tag == 17);
    }

    boolean isUnchecked(int n, Type type) {
        try {
            return this.isUnchecked(type);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(n, completionFailure);
            return true;
        }
    }

    boolean isHandled(Type type, List<Type> list) {
        return this.isUnchecked(type) || this.subset(type, list);
    }

    List<Type> unHandled(List<Type> list, List<Type> list2) {
        List<Type> list3 = List.nil();
        List<Type> list4 = list;
        while (list4.nonEmpty()) {
            if (!this.isHandled((Type)list4.head, list2)) {
                list3 = list3.prepend((Type)list4.head);
            }
            list4 = list4.tail;
        }
        return list3;
    }

    static int protection(long l) {
        switch ((short)(l & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    private static String protectionString(long l) {
        long l2 = l & 7L;
        return l2 == 0L ? "package" : TreeInfo.flagNames(l2);
    }

    static Object cannotOverride(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "cant.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "cant.implement" : "clashes.with");
        return new Diagnostic(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    static Object overrides(Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        String string = (methodSymbol2.owner.flags() & 0x200L) == 0L ? "unchecked.override" : ((methodSymbol.owner.flags() & 0x200L) == 0L ? "unchecked.implement" : "unchecked.clash.with");
        return new Diagnostic(string, methodSymbol, methodSymbol.location(), methodSymbol2, methodSymbol2.location());
    }

    void checkOverride(Tree tree, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2, Symbol.ClassSymbol classSymbol) {
        if ((methodSymbol.flags() & 0x80001000L) == 0L && (methodSymbol2.flags() & 0x1000L) == 0L) {
            if ((methodSymbol.flags() & 8L) != 0L && (methodSymbol2.flags() & 8L) == 0L) {
                this.log.error(TreeInfo.positionFor(methodSymbol, tree), "override.static", Check.cannotOverride(methodSymbol, methodSymbol2));
            } else if ((methodSymbol2.flags() & 0x10L) != 0L || (methodSymbol.flags() & 8L) == 0L && (methodSymbol2.flags() & 8L) != 0L) {
                this.log.error(TreeInfo.positionFor(methodSymbol, tree), "override.meth", Check.cannotOverride(methodSymbol, methodSymbol2), TreeInfo.flagNames(methodSymbol2.flags() & 0x18L));
            } else if ((methodSymbol.owner.flags() & 0x2000L) != 0L) {
                this.log.error(TreeInfo.positionFor(methodSymbol, tree), "annotation.override", methodSymbol2, methodSymbol2.owner);
            } else if (((methodSymbol.flags() ^ methodSymbol2.flags()) & 0x400000000L) != 0L) {
                this.log.warning(TreeInfo.positionFor(methodSymbol, tree), (methodSymbol.flags() & 0x400000000L) != 0L ? "override.varargs.missing" : "override.varargs.extra", Check.cannotOverride(methodSymbol, methodSymbol2));
            } else if ((classSymbol.flags() & 0x200L) == 0L && Check.protection(methodSymbol.flags()) > Check.protection(methodSymbol2.flags())) {
                this.log.error(TreeInfo.positionFor(methodSymbol, tree), "override.weaker.access", Check.cannotOverride(methodSymbol, methodSymbol2), Check.protectionString(methodSymbol2.flags()));
            } else {
                if ((methodSymbol2.flags() & 0x80000000L) != 0L) {
                    this.log.warning(TreeInfo.positionFor(methodSymbol, tree), "override.bridge", Check.overrides(methodSymbol, methodSymbol2));
                }
                Type type = this.types.memberType(classSymbol.type, methodSymbol);
                Type type2 = this.types.memberType(classSymbol.type, methodSymbol2);
                List<Type> list = type.typarams();
                List<Type> list2 = type2.typarams();
                Type type3 = type.restype();
                Type type4 = this.types.subst(type2.restype(), list2, list);
                this.overrideWarner.warned = false;
                boolean bl = this.types.returnTypeSubstitutable(type, type2, type4, this.overrideWarner);
                if (!bl) {
                    if (this.source.allowCovariantReturns() || methodSymbol.owner == classSymbol || !methodSymbol.owner.isSubClass(methodSymbol2.owner, this.types)) {
                        this.typeError(TreeInfo.positionFor(methodSymbol, tree), new Diagnostic("override.incompatible.ret", Check.cannotOverride(methodSymbol, methodSymbol2)), type3, type4);
                    }
                } else if (this.overrideWarner.warned) {
                    this.warnUnchecked(TreeInfo.positionFor(methodSymbol, tree), "prob.found.req", new Diagnostic("override.unchecked.ret", Check.overrides(methodSymbol, methodSymbol2)), type3, type4);
                } else {
                    List<Type> list3 = this.types.subst(type2.thrown(), list2, list);
                    List<Type> list4 = this.unHandled(type.thrown(), list3);
                    if (list4.nonEmpty()) {
                        this.log.error(TreeInfo.positionFor(methodSymbol, tree), "override.meth.doesnt.throw", Check.cannotOverride(methodSymbol, methodSymbol2), list4.head);
                    }
                }
                if ((methodSymbol2.flags() & 0x20000L) != 0L && (methodSymbol.flags() & 0x20000L) == 0L && methodSymbol.outermostClass() != methodSymbol2.outermostClass()) {
                    this.warnDeprecated(TreeInfo.positionFor(methodSymbol, tree), methodSymbol2);
                }
            }
        }
    }

    public void checkCompatibleConcretes(int n, Type type) {
        Type type2 = this.types.supertype(type);
        if (type2.tag != 10) {
            return;
        }
        Type type3 = type2;
        while (type3.tsym.type.isParameterized()) {
            Scope.Entry entry = type3.tsym.members().elems;
            while (entry != null) {
                Symbol symbol = entry.sym;
                if (symbol.kind == 16 && (symbol.flags() & 0x80001008L) == 0L && symbol.isInheritedIn(type.tsym, this.types) && ((Symbol.MethodSymbol)symbol).implementation(type.tsym, this.types, true) == symbol) {
                    Type type4 = this.types.memberType(type3, symbol);
                    int n2 = type4.argtypes().length();
                    if (type4 != symbol.type) {
                        Type type5 = type2;
                        while (type5.tag == 10) {
                            Scope.Entry entry2 = type3.tsym.members().lookup(symbol.name);
                            while (entry2.scope != null) {
                                Type type6;
                                Symbol symbol2 = entry2.sym;
                                if (symbol2 != symbol && symbol2.kind == 16 && (symbol2.flags() & 0x80001008L) == 0L && symbol2.type.argtypes().length() == n2 && symbol2.isInheritedIn(type.tsym, this.types) && ((Symbol.MethodSymbol)symbol2).implementation(type.tsym, this.types, true) == symbol2 && this.types.overrideEquivalent(type4, type6 = this.types.memberType(type5, symbol2))) {
                                    this.log.error(n, "concrete.inheritance.conflict", symbol, type3, symbol2, type5, type2);
                                }
                                entry2 = entry2.next();
                            }
                            type5 = this.types.supertype(type5);
                        }
                    }
                }
                entry = entry.sibling;
            }
            type3 = this.types.supertype(type3);
        }
    }

    public boolean checkCompatibleAbstracts(int n, Type type, Type type2) {
        return this.checkCompatibleAbstracts(n, type, type2, this.types.makeCompoundType(type, type2));
    }

    public boolean checkCompatibleAbstracts(int n, Type type, Type type2, Type type3) {
        Symbol symbol = this.firstIncompatibility(type, type2, type3);
        if (symbol != null) {
            this.log.error(n, "types.incompatible.diff.ret", type, type2, symbol.name + "(" + this.types.memberType(type2, symbol).argtypes() + ")");
            return false;
        }
        return true;
    }

    private Symbol firstIncompatibility(Type type, Type type2, Type type3) {
        HashMap<Symbol.TypeSymbol, Type> hashMap;
        HashMap<Symbol.TypeSymbol, Type> hashMap2 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(type, hashMap2);
        if (type == type2) {
            hashMap = hashMap2;
        } else {
            hashMap = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(type2, hashMap2, hashMap);
        }
        for (Type type4 : hashMap2.values()) {
            for (Type type5 : hashMap.values()) {
                Symbol symbol = this.firstDirectIncompatibility(type4, type5, type3);
                if (symbol == null) continue;
                return symbol;
            }
        }
        return null;
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map) {
        if (type.tag != 10) {
            return;
        }
        if (map.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map);
            }
        }
    }

    private void closure(Type type, Map<Symbol.TypeSymbol, Type> map, Map<Symbol.TypeSymbol, Type> map2) {
        if (type.tag != 10) {
            return;
        }
        if (map.get(type.tsym) != null) {
            return;
        }
        if (map2.put(type.tsym, type) == null) {
            this.closure(this.types.supertype(type), map, map2);
            for (Type type2 : this.types.interfaces(type)) {
                this.closure(type2, map, map2);
            }
        }
    }

    private Symbol firstDirectIncompatibility(Type type, Type type2, Type type3) {
        Scope.Entry entry = type.tsym.members().elems;
        while (entry != null) {
            Symbol.MethodSymbol methodSymbol;
            Symbol symbol = entry.sym;
            Type type4 = null;
            if (symbol.kind == 16 && symbol.isInheritedIn(type3.tsym, this.types) && ((methodSymbol = ((Symbol.MethodSymbol)symbol).implementation(type3.tsym, this.types, false)) == null || (methodSymbol.flags() & 0x400L) != 0L)) {
                Scope.Entry entry2 = type2.tsym.members().lookup(symbol.name);
                while (entry2.scope != null) {
                    Symbol symbol2 = entry2.sym;
                    if (symbol != symbol2 && symbol2.kind == 16 && symbol2.isInheritedIn(type3.tsym, this.types)) {
                        Type type5;
                        if (type4 == null) {
                            type4 = this.types.memberType(type, symbol);
                        }
                        if (this.types.overrideEquivalent(type4, type5 = this.types.memberType(type2, symbol2))) {
                            Type type6;
                            boolean bl;
                            List<Type> list = type4.typarams();
                            List<Type> list2 = type5.typarams();
                            Type type7 = type4.restype();
                            boolean bl2 = bl = this.types.isSameType(type7, type6 = this.types.subst(type5.restype(), list2, list)) || type7.tag >= 10 && type6.tag >= 10 && (this.types.covariantReturnType(type7, type6, Warner.noWarnings) || this.types.covariantReturnType(type6, type7, Warner.noWarnings));
                            if (!bl) {
                                return symbol2;
                            }
                        }
                    }
                    entry2 = entry2.next();
                }
            }
            entry = entry.sibling;
        }
        return null;
    }

    void checkOverride(Tree tree, Symbol.MethodSymbol methodSymbol) {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        if ((classSymbol.flags() & 0x4000L) != 0L && this.names.finalize.equals(methodSymbol.name) && methodSymbol.overrides(this.syms.enumFinalFinalize, classSymbol, this.types, false)) {
            this.log.error(tree.pos, "enum.no.finalize", new Object[0]);
            return;
        }
        Type type = this.types.supertype(classSymbol.type);
        while (type.tag == 10) {
            Symbol.TypeSymbol typeSymbol = type.tsym;
            Scope.Entry entry = typeSymbol.members().lookup(methodSymbol.name);
            while (entry.scope != null) {
                if (methodSymbol.overrides(entry.sym, classSymbol, this.types, false)) {
                    this.checkOverride(tree, methodSymbol, (Symbol.MethodSymbol)entry.sym, classSymbol);
                }
                entry = entry.next();
            }
            type = this.types.supertype(type);
        }
    }

    void checkAllDefined(int n, Symbol.ClassSymbol classSymbol) {
        try {
            Symbol.MethodSymbol methodSymbol = this.firstUndef(classSymbol, classSymbol);
            if (methodSymbol != null) {
                if ((classSymbol.flags() & 0x4000L) != 0L && this.types.supertype((Type)classSymbol.type).tsym == this.syms.enumSym && (classSymbol.flags() & 0x10L) == 0L) {
                    classSymbol.flags_field |= 0x400L;
                } else {
                    Symbol.MethodSymbol methodSymbol2 = new Symbol.MethodSymbol(methodSymbol.flags(), methodSymbol.name, this.types.memberType(classSymbol.type, methodSymbol), methodSymbol.owner);
                    this.log.error(n, "does.not.override.abstract", classSymbol, methodSymbol2, methodSymbol2.location());
                }
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(n, completionFailure);
        }
    }

    private Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2) {
        Symbol.MethodSymbol methodSymbol = null;
        if (classSymbol2 == classSymbol || (classSymbol2.flags() & 0x600L) != 0L) {
            Scope scope = classSymbol2.members();
            List list = scope.elems;
            while (methodSymbol == null && list != null) {
                Symbol.MethodSymbol methodSymbol2;
                Symbol.MethodSymbol methodSymbol3;
                if (((Scope.Entry)((Object)list)).sym.kind == 16 && (((Scope.Entry)((Object)list)).sym.flags() & 0x200400L) == 1024L && ((methodSymbol3 = (methodSymbol2 = (Symbol.MethodSymbol)((Scope.Entry)((Object)list)).sym).implementation(classSymbol, this.types, true)) == null || methodSymbol3 == methodSymbol2)) {
                    methodSymbol = methodSymbol2;
                }
                list = ((Scope.Entry)((Object)list)).sibling;
            }
            if (methodSymbol == null) {
                list = this.types.supertype(classSymbol2.type);
                if (((Type)((Object)list)).tag == 10) {
                    methodSymbol = this.firstUndef(classSymbol, (Symbol.ClassSymbol)((Type)((Object)list)).tsym);
                }
            }
            list = this.types.interfaces(classSymbol2.type);
            while (methodSymbol == null && list.nonEmpty()) {
                methodSymbol = this.firstUndef(classSymbol, (Symbol.ClassSymbol)((Type)list.head).tsym);
                list = list.tail;
            }
        }
        return methodSymbol;
    }

    void checkNonCyclic(int n, Type type) {
        this.checkNonCyclicInternal(n, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(int n, Type type) {
        boolean bl = true;
        Symbol.TypeSymbol typeSymbol = type.tsym;
        if ((typeSymbol.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(n, (Symbol.ClassSymbol)typeSymbol);
        } else if (!typeSymbol.type.isErroneous()) {
            try {
                typeSymbol.flags_field |= 0x8000000L;
                if (typeSymbol.type.tag == 10) {
                    List list;
                    Type.ClassType classType = (Type.ClassType)typeSymbol.type;
                    if (classType.interfaces_field != null) {
                        list = classType.interfaces_field;
                        while (list.nonEmpty()) {
                            bl &= this.checkNonCyclicInternal(n, (Type)list.head);
                            list = list.tail;
                        }
                    }
                    if (classType.supertype_field != null && (list = classType.supertype_field) != null && ((Type)((Object)list)).tag == 10) {
                        bl &= this.checkNonCyclicInternal(n, (Type)((Object)list));
                    }
                    if (typeSymbol.owner.kind == 2) {
                        bl &= this.checkNonCyclicInternal(n, typeSymbol.owner.type);
                    }
                }
                Object var8_7 = null;
                typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
                throw throwable;
            }
        }
        if (bl) {
            boolean bl2 = bl = (typeSymbol.flags_field & 0x10000000L) == 0L && typeSymbol.completer == null;
        }
        if (bl) {
            typeSymbol.flags_field |= 0x40000000L;
        }
        return bl;
    }

    private void noteCyclic(int n, Symbol.ClassSymbol classSymbol) {
        this.log.error(n, "cyclic.inheritance", classSymbol);
        List list = this.types.interfaces(classSymbol.type);
        while (list.nonEmpty()) {
            list.head = new Type.ErrorType((Symbol.ClassSymbol)((Type)list.head).tsym);
            list = list.tail;
        }
        list = this.types.supertype(classSymbol.type);
        if (((Type)((Object)list)).tag == 10) {
            ((Type.ClassType)classSymbol.type).supertype_field = new Type.ErrorType((Symbol.ClassSymbol)((Type)((Object)list)).tsym);
        }
        classSymbol.type = new Type.ErrorType(classSymbol);
        classSymbol.flags_field |= 0x40000000L;
    }

    void checkImplementations(Tree.ClassDef classDef) {
        this.checkImplementations(classDef, classDef.sym);
    }

    void checkImplementations(Tree.ClassDef classDef, Symbol.ClassSymbol classSymbol) {
        List list;
        Object object;
        Symbol.ClassSymbol classSymbol2 = classDef.sym;
        if ((this.allowGenerics || classSymbol2 != classSymbol) && (classSymbol.flags() & 0x400L) != 0L) {
            object = classSymbol.members().elems;
            while (object != null) {
                Symbol.MethodSymbol methodSymbol;
                if (((Scope.Entry)object).sym.kind == 16 && (((Scope.Entry)object).sym.flags() & 0x408L) == 1024L && (methodSymbol = ((Symbol.MethodSymbol)((Object)(list = (Symbol.MethodSymbol)((Scope.Entry)object).sym))).implementation(classSymbol2, this.types, false)) != null && methodSymbol != list && (methodSymbol.owner.flags() & 0x200L) == (classSymbol2.flags() & 0x200L)) {
                    this.checkOverride(classDef, methodSymbol, (Symbol.MethodSymbol)((Object)list), classSymbol2);
                }
                object = ((Scope.Entry)object).sibling;
            }
        }
        object = this.types.supertype(classSymbol.type);
        if (((Type)object).tag == 10) {
            this.checkImplementations(classDef, (Symbol.ClassSymbol)((Type)object).tsym);
        }
        list = this.types.interfaces(classSymbol.type);
        while (list.nonEmpty()) {
            this.checkImplementations(classDef, (Symbol.ClassSymbol)((Type)list.head).tsym);
            list = list.tail;
        }
    }

    void checkCompatibleSupertypes(int n, Type type) {
        List<Type> list = this.types.interfaces(type);
        Type type2 = this.types.supertype(type);
        if (type2.tag == 10 && (type2.tsym.flags() & 0x400L) != 0L) {
            list = list.prepend(type2);
        }
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (this.allowGenerics && !((Type)list2.head).typarams().isEmpty() && !this.checkCompatibleAbstracts(n, (Type)list2.head, (Type)list2.head, type)) {
                return;
            }
            List<Type> list3 = list;
            while (list3 != list2) {
                if (!this.checkCompatibleAbstracts(n, (Type)list2.head, (Type)list3.head, type)) {
                    return;
                }
                list3 = list3.tail;
            }
            list2 = list2.tail;
        }
        this.checkCompatibleConcretes(n, type);
    }

    void checkClassBounds(int n, Type type) {
        this.checkClassBounds(n, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(int n, Map<Symbol.TypeSymbol, Type> map, Type type) {
        if (type.isErroneous()) {
            return;
        }
        Object object = this.types.interfaces(type);
        while (((List)object).nonEmpty()) {
            List<Type> list;
            List<Type> list2;
            Type type2 = (Type)((List)object).head;
            Type type3 = map.put(type2.tsym, type2);
            if (type3 != null && !this.types.containsTypeEquivalent(list2 = type3.allparams(), list = type2.allparams())) {
                this.log.error(n, "cant.inherit.diff.arg", type2.tsym, Type.toString(list2), Type.toString(list));
            }
            this.checkClassBounds(n, map, type2);
            object = ((List)object).tail;
        }
        object = this.types.supertype(type);
        if (object != null) {
            this.checkClassBounds(n, map, (Type)object);
        }
    }

    void checkNotRepeated(int n, Type type, Set<Type> set) {
        if (set.contains(type)) {
            this.log.error(n, "repeated.interface", new Object[0]);
        } else {
            set.add(type);
        }
    }

    void validateAnnotationType(Tree tree) {
        if (tree != null) {
            this.validateAnnotationType(tree.pos, tree.type);
        }
    }

    void validateAnnotationType(int n, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.lowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(n, this.types.elemtype(type));
            return;
        }
        this.log.error(n, "invalid.annotation.member.type", new Object[0]);
    }

    public void validateAnnotations(List<Tree.Annotation> list, Symbol symbol) {
        if (this.skipAnnotations) {
            return;
        }
        for (Tree.Annotation annotation : list) {
            this.validateAnnotation(annotation, symbol);
        }
    }

    public void validateAnnotation(Tree.Annotation annotation, Symbol symbol) {
        this.validateAnnotation(annotation);
        if (!this.annotationApplicable(annotation, symbol)) {
            this.log.error(annotation.pos, "annotation.type.not.applicable", new Object[0]);
        }
        if (annotation.annotationType.type.tsym == this.syms.overrideType.tsym && !this.isOverrider(symbol)) {
            this.log.error(annotation.pos, "method.does.not.override.superclass", new Object[0]);
        }
    }

    boolean isOverrider(Symbol symbol) {
        if (symbol.kind != 16) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)methodSymbol.owner;
        Type type = this.types.supertype(methodSymbol.owner.type);
        while (type.tag == 10) {
            Scope.Entry entry = type.tsym.members().lookup(methodSymbol.name);
            while (entry.scope != null) {
                if (methodSymbol.overrides(entry.sym, typeSymbol, this.types, true)) {
                    return true;
                }
                entry = entry.next();
            }
            type = this.types.supertype(type);
        }
        return false;
    }

    boolean annotationApplicable(Tree.Annotation annotation, Symbol symbol) {
        Attribute.Compound compound = annotation.annotationType.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (compound == null) {
            return true;
        }
        Attribute attribute = compound.member(this.names.value);
        if (!(attribute instanceof Attribute.Array)) {
            return true;
        }
        Attribute.Array array = (Attribute.Array)attribute;
        for (Attribute attribute2 : array.values) {
            if (!(attribute2 instanceof Attribute.Enum)) {
                return true;
            }
            Attribute.Enum enum_ = (Attribute.Enum)attribute2;
            if (enum_.value.name == this.names.TYPE) {
                if (symbol.kind != 2) continue;
                return true;
            }
            if (enum_.value.name == this.names.FIELD) {
                if (symbol.kind != 4 || symbol.owner.kind == 16) continue;
                return true;
            }
            if (enum_.value.name == this.names.METHOD) {
                if (symbol.kind != 16 || symbol.isConstructor()) continue;
                return true;
            }
            if (enum_.value.name == this.names.PARAMETER) {
                if (symbol.kind != 4 || symbol.owner.kind != 16 || (symbol.flags() & 0x200000000L) == 0L) continue;
                return true;
            }
            if (enum_.value.name == this.names.CONSTRUCTOR) {
                if (symbol.kind != 16 || !symbol.isConstructor()) continue;
                return true;
            }
            if (enum_.value.name == this.names.LOCAL_VARIABLE) {
                if (symbol.kind != 4 || symbol.owner.kind != 16 || (symbol.flags() & 0x200000000L) != 0L) continue;
                return true;
            }
            if (enum_.value.name == this.names.ANNOTATION_TYPE) {
                if (symbol.kind != 2 || (symbol.flags() & 0x2000L) == 0L) continue;
                return true;
            }
            if (enum_.value.name == this.names.PACKAGE) {
                if (symbol.kind != 1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void validateAnnotation(Tree.Annotation annotation) {
        Object object;
        Tree tree;
        if (annotation.type.isErroneous()) {
            return;
        }
        HashSet<Symbol.MethodSymbol> hashSet = new HashSet<Symbol.MethodSymbol>();
        Object object3 = annotation.annotationType.type.tsym.members().elems;
        while (object3 != null) {
            if (((Scope.Entry)object3).sym.kind == 16) {
                hashSet.add((Symbol.MethodSymbol)((Scope.Entry)object3).sym);
            }
            object3 = ((Scope.Entry)object3).sibling;
        }
        for (Tree object22 : annotation.args) {
            if (object22.tag != 30) continue;
            tree = (Tree.Assign)object22;
            object = TreeInfo.symbol(tree.lhs);
            if (object == null || ((Symbol)object).type.isErroneous()) continue;
            if (!hashSet.remove(object)) {
                this.log.error(object22.pos, "duplicate.annotation.member.value", ((Symbol)object).name, annotation.type);
            }
            if (tree.rhs.tag != 8192) continue;
            this.validateAnnotation((Tree.Annotation)tree.rhs);
        }
        for (Symbol.MethodSymbol methodSymbol : hashSet) {
            if (methodSymbol.defaultValue != null || methodSymbol.type.isErroneous()) continue;
            this.log.error(annotation.pos, "annotation.missing.default.value", annotation.type, methodSymbol.name);
        }
        if (annotation.annotationType.type.tsym != this.syms.annotationTargetType.tsym || annotation.args.tail == null) {
            return;
        }
        if (((Tree)annotation.args.head).tag != 30) {
            return;
        }
        object3 = (Tree.Assign)annotation.args.head;
        Symbol symbol = TreeInfo.symbol(((Tree.Assign)object3).lhs);
        if (symbol.name != this.names.value) {
            return;
        }
        tree = ((Tree.Assign)object3).rhs;
        if (tree.tag != 28) {
            return;
        }
        object = (Tree.NewArray)tree;
        HashSet<Symbol> hashSet2 = new HashSet<Symbol>();
        for (Tree tree2 : ((Tree.NewArray)object).elems) {
            if (hashSet2.add(TreeInfo.symbol(tree2))) continue;
            this.log.error(tree2.pos, "repeated.annotation.target", new Object[0]);
        }
    }

    void checkDeprecatedAnnotation(int n, Symbol symbol) {
        if (this.allowAnnotations && this.lint.isEnabled(Lint.LintCategory.DEP_ANN) && (symbol.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && symbol.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(n, "missing.deprecated.annotation", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(Tree.ClassDef classDef) {
        if ((classDef.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        assert ((classDef.sym.flags_field & 0x8000000L) == 0L);
        try {
            classDef.sym.flags_field |= 0x8000000L;
            for (Tree tree : classDef.defs) {
                if (tree.tag != 4) continue;
                Tree.MethodDef methodDef = (Tree.MethodDef)tree;
                this.checkAnnotationResType(methodDef.pos, methodDef.restype.type);
            }
            Object var6_5 = null;
            classDef.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            classDef.sym.flags_field |= 8L;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            classDef.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            classDef.sym.flags_field |= 8L;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(int n, Symbol.TypeSymbol typeSymbol) {
        if ((typeSymbol.flags_field & 8L) != 0L) {
            return;
        }
        if ((typeSymbol.flags_field & 0x8000000L) != 0L) {
            this.log.error(n, "cyclic.annotation.element", new Object[0]);
            return;
        }
        try {
            typeSymbol.flags_field |= 0x8000000L;
            Scope.Entry entry = typeSymbol.members().elems;
            while (entry != null) {
                Symbol symbol = entry.sym;
                if (symbol.kind == 16) {
                    this.checkAnnotationResType(n, ((Symbol.MethodSymbol)symbol).type.restype());
                }
                entry = entry.sibling;
            }
            Object var6_5 = null;
            typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            typeSymbol.flags_field |= 8L;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            typeSymbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            typeSymbol.flags_field |= 8L;
            throw throwable;
        }
    }

    void checkAnnotationResType(int n, Type type) {
        switch (type.tag) {
            case 10: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(n, type.tsym);
                break;
            }
            case 11: {
                this.checkAnnotationResType(n, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(Tree.ClassDef classDef) {
        HashMap<Symbol, Symbol> hashMap = new HashMap<Symbol, Symbol>();
        Object object = classDef.defs;
        while (object.nonEmpty()) {
            Symbol[] symbolArray = TreeInfo.firstConstructorCall((Tree)object.head);
            if (symbolArray != null) {
                Tree.MethodDef methodDef = (Tree.MethodDef)object.head;
                if (TreeInfo.name(symbolArray.meth) == this.names._this) {
                    hashMap.put(methodDef.sym, TreeInfo.symbol(symbolArray.meth));
                } else {
                    methodDef.sym.flags_field |= 0x40000000L;
                }
            }
            object = object.tail;
        }
        object = new Symbol[]{};
        for (Symbol symbol : object = hashMap.keySet().toArray((T[])object)) {
            this.checkCyclicConstructor(classDef, symbol, hashMap);
        }
    }

    private void checkCyclicConstructor(Tree.ClassDef classDef, Symbol symbol, Map<Symbol, Symbol> map) {
        if (symbol != null && (symbol.flags_field & 0x40000000L) == 0L) {
            if ((symbol.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.positionFor(symbol, classDef), "recursive.ctor.invocation", new Object[0]);
            } else {
                symbol.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(classDef, map.remove(symbol), map);
                symbol.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            symbol.flags_field |= 0x40000000L;
        }
    }

    boolean checkUnique(int n, Symbol symbol, Scope scope) {
        if (symbol.owner.name == this.names.any) {
            return false;
        }
        Scope.Entry entry = scope.lookup(symbol.name);
        while (entry.scope == scope) {
            if (symbol != entry.sym && symbol.kind == entry.sym.kind && symbol.name != this.names.error && (symbol.kind != 16 || this.types.hasSameArgs(this.types.erasure(symbol.type), this.types.erasure(entry.sym.type)))) {
                if (symbol.kind == 16 && !this.types.overrideEquivalent(symbol.type, entry.sym.type)) {
                    this.duplicateErasureError(n, symbol, entry.sym);
                } else {
                    this.duplicateError(n, entry.sym);
                }
                return false;
            }
            entry = entry.next();
        }
        return true;
    }

    boolean checkUniqueImport(int n, Symbol symbol, Scope scope) {
        Scope.Entry entry = scope.lookup(symbol.name);
        while (entry.scope != null) {
            boolean bl;
            boolean bl2 = bl = entry.scope == scope;
            if ((bl || symbol != entry.sym) && symbol.kind == entry.sym.kind && symbol.name != this.names.error) {
                if (!entry.sym.type.isErroneous()) {
                    String string = entry.sym.toString();
                    if (!bl) {
                        this.log.error(n, "already.defined.single.import", string);
                    } else if (symbol != entry.sym) {
                        this.log.error(n, "already.defined.this.unit", string);
                    }
                }
                return false;
            }
            entry = entry.next();
        }
        return true;
    }

    public void checkCanonical(Tree tree) {
        if (!this.isCanonical(tree)) {
            this.log.error(tree.pos, "import.requires.canonical", TreeInfo.symbol(tree));
        }
    }

    private boolean isCanonical(Tree tree) {
        while (tree.tag == 34) {
            Tree.Select select = (Tree.Select)tree;
            if (select.sym.owner != TreeInfo.symbol(select.selected)) {
                return false;
            }
            tree = select.selected;
        }
        return true;
    }

    public Warner castWarner(int n, Type type, Type type2) {
        return new ConversionWarner(n, "unchecked.cast.to.type", type, type2);
    }

    public Warner convertWarner(int n, Type type, Type type2) {
        return new ConversionWarner(n, "unchecked.assign", type, type2);
    }

    private class ConversionWarner
    extends Warner {
        final String key;
        final Type found;
        final Type expected;

        public ConversionWarner(int n, String string, Type type, Type type2) {
            super(n);
            this.key = string;
            this.found = type;
            this.expected = type2;
        }

        public void warnUnchecked() {
            boolean bl = this.warned;
            super.warnUnchecked();
            if (bl) {
                return;
            }
            Diagnostic diagnostic = new Diagnostic(this.key, new Object[0]);
            Check.this.warnUnchecked(this.pos(), "prob.found.req", diagnostic, this.found, this.expected);
        }
    }

    class Validator
    extends Tree.Visitor {
        Validator() {
        }

        public void visitTypeArray(Tree.TypeArray typeArray) {
            Check.this.validate(typeArray.elemtype);
        }

        public void visitTypeApply(Tree.TypeApply typeApply) {
            if (typeApply.type.tag == 10) {
                List<Type> list = typeApply.type.tsym.type.typarams();
                List<Type> list2 = typeApply.type.typarams();
                List<Tree> list3 = typeApply.arguments;
                List<Type> list4 = list;
                ListBuffer<Type.TypeVar> listBuffer = new ListBuffer<Type.TypeVar>();
                while (list3.nonEmpty() && list4.nonEmpty()) {
                    Check.this.validate((Tree)list3.head);
                    listBuffer.append(Check.this.types.substBound((Type.TypeVar)list4.head, list, Type.removeBounds(list2)));
                    list3 = list3.tail;
                    list4 = list4.tail;
                }
                list3 = typeApply.arguments;
                List list5 = listBuffer.toList();
                while (list3.nonEmpty() && list5.nonEmpty()) {
                    ((Tree)list3.head).type.withTypeVar((Type)list5.head);
                    list3 = list3.tail;
                    list5 = list5.tail;
                }
                list3 = typeApply.arguments;
                list5 = listBuffer.toList();
                while (list3.nonEmpty() && list5.nonEmpty()) {
                    Check.this.checkExtends(((Tree)list3.head).pos, ((Tree)list3.head).type, (Type.TypeVar)list5.head);
                    list3 = list3.tail;
                    list5 = list5.tail;
                }
                if (typeApply.type.outer().isRaw()) {
                    Check.this.log.error(typeApply.pos, "improperly.formed.type.inner.raw.param", new Object[0]);
                }
                if (typeApply.clazz.tag == 34) {
                    this.visitSelectInternal((Tree.Select)typeApply.clazz);
                }
            }
        }

        public void visitTypeParameter(Tree.TypeParameter typeParameter) {
            Check.this.validate(typeParameter.bounds);
            Check.this.checkClassBounds(typeParameter.pos, typeParameter.type);
        }

        public void visitSelect(Tree.Select select) {
            if (select.type.tag == 10) {
                this.visitSelectInternal(select);
                if (select.selected.type.isParameterized() && select.type.tsym.type.typarams().nonEmpty()) {
                    Check.this.log.error(select.pos, "improperly.formed.type.param.missing", new Object[0]);
                }
            }
        }

        public void visitSelectInternal(Tree.Select select) {
            if (select.type.outer().tag == 10) {
                Check.this.validate(select.selected);
            } else if (select.selected.type.isParameterized()) {
                Check.this.log.error(select.pos, "cant.select.static.class.from.param.type", new Object[0]);
            }
        }

        public void visitTree(Tree tree) {
        }
    }
}

