/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.InternalException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.ConnectorImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractLauncher
extends ConnectorImpl
implements LaunchingConnector {
    ThreadGroup grp = Thread.currentThread().getThreadGroup();

    @Override
    public abstract VirtualMachine launch(Map<String, ? extends Connector.Argument> var1) throws IOException, IllegalConnectorArgumentsException, VMStartException;

    @Override
    public abstract String name();

    @Override
    public abstract String description();

    AbstractLauncher() {
        ThreadGroup threadGroup = null;
        while ((threadGroup = this.grp.getParent()) != null) {
            this.grp = threadGroup;
        }
    }

    String[] tokenizeCommand(String string, char c) {
        String[] stringArray;
        String string2 = String.valueOf(c);
        StringTokenizer stringTokenizer = new StringTokenizer(string, c + " \t\r\n\f", true);
        Object object = null;
        String[] stringArray2 = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (object != null) {
                if (stringArray.equals(string2)) {
                    arrayList.add((String[])object);
                    object = null;
                    continue;
                }
                object = (String)object + (String)stringArray;
                continue;
            }
            if (stringArray2 != null) {
                if (stringArray.equals(string2)) {
                    object = stringArray2;
                } else if (stringArray.length() == 1 && Character.isWhitespace(stringArray.charAt(0))) {
                    arrayList.add(stringArray2);
                } else {
                    throw new InternalException("Unexpected token: " + (String)stringArray);
                }
                stringArray2 = null;
                continue;
            }
            if (stringArray.equals(string2)) {
                object = "";
                continue;
            }
            if (stringArray.length() == 1 && Character.isWhitespace(stringArray.charAt(0))) continue;
            stringArray2 = stringArray;
        }
        if (stringArray2 != null) {
            arrayList.add(stringArray2);
        }
        if (object != null) {
            arrayList.add((String[])object);
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    protected VirtualMachine launch(String[] stringArray, String string, TransportService.ListenKey listenKey, TransportService transportService) throws IOException, VMStartException {
        Helper helper = new Helper(stringArray, string, listenKey, transportService);
        helper.launchAndAccept();
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        return virtualMachineManager.createVirtualMachine(helper.connection(), helper.process());
    }

    private class Helper {
        private final String address;
        private TransportService.ListenKey listenKey;
        private TransportService ts;
        private final String[] commandArray;
        private Process process = null;
        private Connection connection = null;
        private IOException acceptException = null;
        private boolean exited = false;

        Helper(String[] stringArray, String string, TransportService.ListenKey listenKey, TransportService transportService) {
            this.commandArray = stringArray;
            this.address = string;
            this.listenKey = listenKey;
            this.ts = transportService;
        }

        String commandString() {
            String string = "";
            for (int i = 0; i < this.commandArray.length; ++i) {
                if (i > 0) {
                    string = string + " ";
                }
                string = string + this.commandArray[i];
            }
            return string;
        }

        synchronized void launchAndAccept() throws IOException, VMStartException {
            this.process = Runtime.getRuntime().exec(this.commandArray);
            Thread thread = this.acceptConnection();
            Thread thread2 = this.monitorTarget();
            try {
                while (this.connection == null && this.acceptException == null && !this.exited) {
                    this.wait();
                }
                if (this.exited) {
                    throw new VMStartException("VM initialization failed for: " + this.commandString(), this.process);
                }
                if (this.acceptException != null) {
                    throw this.acceptException;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException("Interrupted during accept");
            }
            finally {
                thread.interrupt();
                thread2.interrupt();
            }
        }

        Process process() {
            return this.process;
        }

        Connection connection() {
            return this.connection;
        }

        synchronized void notifyOfExit() {
            this.exited = true;
            this.notify();
        }

        synchronized void notifyOfConnection(Connection connection) {
            this.connection = connection;
            this.notify();
        }

        synchronized void notifyOfAcceptException(IOException iOException) {
            this.acceptException = iOException;
            this.notify();
        }

        Thread monitorTarget() {
            Thread thread = new Thread(AbstractLauncher.this.grp, "launched target monitor"){

                public void run() {
                    try {
                        Helper.this.process.waitFor();
                        Helper.this.notifyOfExit();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            return thread;
        }

        Thread acceptConnection() {
            Thread thread = new Thread(AbstractLauncher.this.grp, "connection acceptor"){

                public void run() {
                    try {
                        Connection connection = Helper.this.ts.accept(Helper.this.listenKey, 0L, 0L);
                        Helper.this.notifyOfConnection(connection);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    catch (IOException iOException) {
                        Helper.this.notifyOfAcceptException(iOException);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            return thread;
        }
    }
}

