/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.FeatureFrame;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.core.TimeStamp;

public class FeatureTrack
implements Serializable,
Iterable<FeatureFrame>,
SegmentListener {
    private static final long serialVersionUID = 1L;
    private SortedSet<FeatureFrame> frames = new TreeSet<FeatureFrame>();
    private Map<Integer, SortedSet<FeatureFrame>> framesInBlocks = new Hashtable<Integer, SortedSet<FeatureFrame>>();
    private int skipMS = 1000;
    private transient List<FeatureExtractor<?, ?>> extractors = new ArrayList();
    private int frameMemory = -1;

    public void add(FeatureFrame featureFrame) {
        if (this.frameMemory != 0) {
            this.frames.add(featureFrame);
            int n = (int)(featureFrame.getStartTimeMS() / (double)this.skipMS);
            int n2 = (int)(featureFrame.getEndTimeMS() / (double)this.skipMS);
            for (int i = n; i <= n2; ++i) {
                SortedSet<Object> sortedSet;
                if (this.framesInBlocks.containsKey(i)) {
                    sortedSet = this.framesInBlocks.get(i);
                } else {
                    sortedSet = new TreeSet();
                    this.framesInBlocks.put(i, sortedSet);
                }
                sortedSet.add(featureFrame);
            }
            this.frameMemoryCheck();
        }
    }

    public void remove(FeatureFrame featureFrame) {
        this.frames.remove(featureFrame);
        int n = (int)(featureFrame.getStartTimeMS() / (double)this.skipMS);
        int n2 = (int)(featureFrame.getEndTimeMS() / (double)this.skipMS);
        for (int i = n; i <= n2; ++i) {
            if (!this.framesInBlocks.containsKey(i)) continue;
            SortedSet<FeatureFrame> sortedSet = this.framesInBlocks.get(i);
            sortedSet.remove(featureFrame);
        }
    }

    public void removeRange(double d, double d2) {
        FeatureFrame featureFrame3;
        ArrayList<FeatureFrame> arrayList = new ArrayList<FeatureFrame>();
        FeatureFrame featureFrame2 = this.getFrameAt(d);
        if (featureFrame2 == null) {
            return;
        }
        arrayList.add(featureFrame2);
        Iterator iterator = this.frames.tailSet(featureFrame2).iterator();
        while (iterator.hasNext() && (featureFrame3 = (FeatureFrame)iterator.next()).getStartTimeMS() < d2) {
            arrayList.add(featureFrame3);
        }
        for (FeatureFrame featureFrame3 : arrayList) {
            this.remove(featureFrame3);
        }
    }

    public FeatureFrame get(int n) {
        if (n >= this.frames.size()) {
            return null;
        }
        int n2 = 0;
        FeatureFrame featureFrame = null;
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            FeatureFrame featureFrame2;
            featureFrame = featureFrame2 = (FeatureFrame)iterator.next();
            if (n2 == n) break;
            ++n2;
        }
        return featureFrame;
    }

    public FeatureFrame getFrameAt(double d) {
        int n = (int)(d / (double)this.skipMS);
        SortedSet<FeatureFrame> sortedSet = this.framesInBlocks.get(n);
        if (sortedSet != null) {
            for (FeatureFrame featureFrame : sortedSet) {
                if (!featureFrame.containsTime(d)) continue;
                return featureFrame;
            }
        }
        return null;
    }

    public FeatureFrame getFrameBefore(double d) {
        FeatureFrame featureFrame = this.getFrameAt(d);
        if (featureFrame == null) {
            featureFrame = this.frames.last();
        }
        return featureFrame;
    }

    public FeatureFrame getLastFrame() {
        if (this.frames.size() > 0) {
            return this.frames.last();
        }
        return null;
    }

    public void addFeatureExtractor(FeatureExtractor<?, ?> featureExtractor) {
        this.extractors.add(featureExtractor);
    }

    public void removeFeatureExtractor(FeatureExtractor<?, ?> featureExtractor) {
        this.extractors.remove(featureExtractor);
    }

    @Override
    public void newSegment(TimeStamp timeStamp, TimeStamp timeStamp2) {
        FeatureFrame featureFrame = new FeatureFrame(timeStamp.getTimeMS(), timeStamp2.getTimeMS());
        for (FeatureExtractor<?, ?> featureExtractor : this.extractors) {
            Object obj = featureExtractor.getFeatures();
            try {
                Method method = obj.getClass().getMethod("clone", new Class[0]);
                featureFrame.add(featureExtractor.getName(), method.invoke(obj, new Object[0]));
            }
            catch (Exception exception) {
                if (obj instanceof float[]) {
                    featureFrame.add(featureExtractor.getName(), ((float[])obj).clone());
                    continue;
                }
                if (obj instanceof int[]) {
                    featureFrame.add(featureExtractor.getName(), ((int[])obj).clone());
                    continue;
                }
                if (obj instanceof double[]) {
                    featureFrame.add(featureExtractor.getName(), ((double[])obj).clone());
                    continue;
                }
                if (obj instanceof byte[]) {
                    featureFrame.add(featureExtractor.getName(), ((byte[])obj).clone());
                    continue;
                }
                if (obj instanceof short[]) {
                    featureFrame.add(featureExtractor.getName(), ((short[])obj).clone());
                    continue;
                }
                if (obj instanceof long[]) {
                    featureFrame.add(featureExtractor.getName(), ((long[])obj).clone());
                    continue;
                }
                if (obj instanceof Object[]) {
                    featureFrame.add(featureExtractor.getName(), ((Object[])obj).clone());
                    continue;
                }
                if (obj instanceof boolean[]) {
                    featureFrame.add(featureExtractor.getName(), ((boolean[])obj).clone());
                    continue;
                }
                featureFrame.add(featureExtractor.getName(), obj);
            }
        }
        this.add(featureFrame);
    }

    @Override
    public Iterator<FeatureFrame> iterator() {
        return this.frames.iterator();
    }

    public int getFrameMemory() {
        return this.frameMemory;
    }

    public void setFrameMemory(int n) {
        this.frameMemory = n;
        this.frameMemoryCheck();
    }

    private void frameMemoryCheck() {
        if (this.frameMemory > 0) {
            while (this.frames.size() > this.frameMemory) {
                FeatureFrame featureFrame = this.frames.first();
                this.remove(featureFrame);
            }
        }
    }

    public int getNumberOfFrames() {
        return this.frames.size();
    }

    public void clear() {
        this.frames.clear();
        this.framesInBlocks.clear();
    }
}

