/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data.buffers;

import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.BufferFactory;

public class CurveBuffer
extends BufferFactory {
    private final float curviness;

    public CurveBuffer(float f) {
        this.curviness = Math.min(1.0f, Math.max(-1.0f, f));
    }

    @Override
    public Buffer generateBuffer(int n) {
        Buffer buffer = new Buffer(n);
        double d = Math.exp(-this.curviness);
        for (int i = 0; i < n; ++i) {
            buffer.buf[i] = (float)Math.pow((float)i / (float)n, d);
        }
        return buffer;
    }

    @Override
    public String getName() {
        return "Curve " + this.curviness;
    }
}

