/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.IIRFilter;
import net.beadsproject.beads.ugens.Static;

public class LPRezFilter
extends IIRFilter
implements DataBeadReceiver {
    protected float freq = 100.0f;
    protected float res = 0.5f;
    protected float _2pi_over_sr;
    protected float cosw = 0.0f;
    protected UGen freqUGen;
    protected UGen resUGen;
    protected float a1;
    protected float a2;
    protected float b0;
    private float y1 = 0.0f;
    private float y2 = 0.0f;
    private float[] y1m;
    private float[] y2m;
    private int channels;
    protected boolean isFreqStatic;
    protected boolean isResStatic;

    public LPRezFilter(AudioContext audioContext) {
        this(audioContext, 1);
    }

    public LPRezFilter(AudioContext audioContext, int n) {
        super(audioContext, n, n);
        this._2pi_over_sr = (float)(Math.PI * 2 / (double)audioContext.getSampleRate());
        this.channels = super.getOuts();
        this.y1m = new float[this.channels];
        this.y2m = new float[this.channels];
        this.setFrequency(this.freq).setRes(this.res);
    }

    public LPRezFilter(AudioContext audioContext, float f, float f2) {
        this(audioContext, 1, f, f2);
    }

    public LPRezFilter(AudioContext audioContext, UGen uGen, float f) {
        this(audioContext, 1, uGen, f);
    }

    public LPRezFilter(AudioContext audioContext, float f, UGen uGen) {
        this(audioContext, 1, f, uGen);
    }

    public LPRezFilter(AudioContext audioContext, UGen uGen, UGen uGen2) {
        this(audioContext, 1, uGen, uGen2);
    }

    public LPRezFilter(AudioContext audioContext, int n, float f, float f2) {
        this(audioContext, n);
        this.setFrequency(f).setRes(f2);
    }

    public LPRezFilter(AudioContext audioContext, int n, UGen uGen, float f) {
        this(audioContext, n);
        this.setFrequency(uGen).setRes(f);
    }

    public LPRezFilter(AudioContext audioContext, int n, float f, UGen uGen) {
        this(audioContext, n);
        this.setFrequency(f).setRes(uGen);
    }

    public LPRezFilter(AudioContext audioContext, int n, UGen uGen, UGen uGen2) {
        this(audioContext, n);
        this.setFrequency(uGen).setRes(uGen2);
    }

    protected void calcVals() {
        this.a1 = -2.0f * this.res * this.cosw;
        this.a2 = this.res * this.res;
        this.b0 = 1.0f + this.a1 + this.a2;
    }

    @Override
    public void calculateBuffer() {
        block32: {
            block31: {
                if (this.channels != 1) break block31;
                float[] fArray = this.bufIn[0];
                float[] fArray2 = this.bufOut[0];
                if (this.isFreqStatic && this.isResStatic) {
                    fArray2[0] = fArray[0] * this.b0 - this.a1 * this.y1 - this.a2 * this.y2;
                    fArray2[1] = fArray[1] * this.b0 - this.a1 * fArray2[0] - this.a2 * this.y1;
                    for (int i = 2; i < this.bufferSize; ++i) {
                        fArray2[i] = fArray[i] * this.b0 - this.a1 * fArray2[i - 1] - this.a2 * fArray2[i - 2];
                    }
                } else {
                    float f;
                    float f2;
                    this.freqUGen.update();
                    this.resUGen.update();
                    this.freq = this.freqUGen.getValue(0, 0);
                    this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                    this.res = this.resUGen.getValue(0, 0);
                    if (f2 > 0.999999f) {
                        this.res = 0.999999f;
                    } else if (this.res < 0.0f) {
                        this.res = 0.0f;
                    }
                    this.calcVals();
                    fArray2[0] = fArray[0] * this.b0 - this.a1 * this.y1 - this.a2 * this.y2;
                    this.freq = this.freqUGen.getValue(0, 1);
                    this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                    this.res = this.resUGen.getValue(0, 1);
                    if (f > 0.999999f) {
                        this.res = 0.999999f;
                    } else if (this.res < 0.0f) {
                        this.res = 0.0f;
                    }
                    this.calcVals();
                    fArray2[1] = fArray[1] * this.b0 - this.a1 * fArray2[0] - this.a2 * this.y1;
                    for (int i = 2; i < this.bufferSize; ++i) {
                        float f3;
                        this.freq = this.freqUGen.getValue(0, i);
                        this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                        this.res = this.resUGen.getValue(0, i);
                        if (f3 > 0.999999f) {
                            this.res = 0.999999f;
                        } else if (this.res < 0.0f) {
                            this.res = 0.0f;
                        }
                        this.calcVals();
                        fArray2[i] = fArray[i] * this.b0 - this.a1 * fArray2[i - 1] - this.a2 * fArray2[i - 2];
                    }
                }
                this.y2 = fArray2[this.bufferSize - 2];
                this.y1 = fArray2[this.bufferSize - 1];
                if (!Float.isNaN(this.y1)) break block32;
                this.reset();
                break block32;
            }
            if (this.isFreqStatic && this.isResStatic) {
                for (int i = 0; i < this.channels; ++i) {
                    float[] fArray = this.bufIn[i];
                    float[] fArray3 = this.bufOut[i];
                    fArray3[0] = fArray[0] * this.b0 - this.a1 * this.y1m[i] - this.a2 * this.y2m[i];
                    fArray3[1] = fArray[1] * this.b0 - this.a1 * fArray3[0] - this.a2 * this.y1m[i];
                    for (int j = 2; j < this.bufferSize; ++j) {
                        fArray3[j] = fArray[j] * this.b0 - this.a1 * fArray3[j - 1] - this.a2 * fArray3[j - 2];
                    }
                    this.y2m[i] = fArray3[this.bufferSize - 2];
                    this.y1m[i] = fArray3[this.bufferSize - 1];
                    if (!Float.isNaN(this.y1m[i])) continue;
                    this.reset();
                }
            } else {
                float f;
                int n;
                float f4;
                this.freqUGen.update();
                this.resUGen.update();
                this.freq = this.freqUGen.getValue(0, 0);
                this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                this.res = this.resUGen.getValue(0, 0);
                if (f4 > 0.999999f) {
                    this.res = 0.999999f;
                } else if (this.res < 0.0f) {
                    this.res = 0.0f;
                }
                this.calcVals();
                for (n = 0; n < this.channels; ++n) {
                    this.bufOut[n][0] = this.bufIn[n][0] * this.b0 - this.a1 * this.y1m[n] - this.a2 * this.y2m[n];
                }
                this.freq = this.freqUGen.getValue(0, 1);
                this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                this.res = this.resUGen.getValue(0, 1);
                if (f > 0.999999f) {
                    this.res = 0.999999f;
                } else if (this.res < 0.0f) {
                    this.res = 0.0f;
                }
                this.calcVals();
                for (n = 0; n < this.channels; ++n) {
                    this.bufOut[n][1] = this.bufIn[n][1] * this.b0 - this.a1 * this.bufOut[n][0] - this.a2 * this.y1m[n];
                }
                for (n = 2; n < this.bufferSize; ++n) {
                    float f5;
                    this.freq = this.freqUGen.getValue(0, n);
                    this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
                    this.res = this.resUGen.getValue(0, n);
                    if (f5 > 0.999999f) {
                        this.res = 0.999999f;
                    } else if (this.res < 0.0f) {
                        this.res = 0.0f;
                    }
                    this.calcVals();
                    for (int i = 0; i < this.channels; ++i) {
                        this.bufOut[i][n] = this.bufIn[i][n] * this.b0 - this.a1 * this.bufOut[i][n - 1] - this.a2 * this.bufOut[i][n - 2];
                    }
                }
                for (n = 0; n < this.channels; ++n) {
                    this.y2m[n] = this.bufOut[n][this.bufferSize - 2];
                    this.y1m[n] = this.bufOut[n][this.bufferSize - 1];
                    if (!Float.isNaN(this.y1m[n])) continue;
                    this.reset();
                }
            }
        }
    }

    public void reset() {
        this.y1 = 0.0f;
        this.y2 = 0.0f;
        for (int i = 0; i < this.channels; ++i) {
            this.y1m[i] = 0.0f;
            this.y2m[i] = 0.0f;
        }
    }

    public float getFrequency() {
        return this.freq;
    }

    public LPRezFilter setFrequency(float f) {
        this.freq = f;
        if (this.isFreqStatic) {
            this.freqUGen.setValue(f);
        } else {
            this.freqUGen = new Static(this.context, f);
            this.isFreqStatic = true;
        }
        this.cosw = (float)Math.cos(this._2pi_over_sr * this.freq);
        this.calcVals();
        return this;
    }

    public LPRezFilter setFrequency(UGen uGen) {
        if (uGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = uGen;
            uGen.update();
            this.freq = uGen.getValue();
            this.isFreqStatic = false;
        }
        return this;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public LPRezFilter setFreq(float f) {
        return this.setFrequency(f);
    }

    @Deprecated
    public LPRezFilter setFreq(UGen uGen) {
        return this.setFrequency(uGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public float getRes() {
        return this.res;
    }

    public LPRezFilter setRes(float f) {
        this.res = f > 0.999999f ? 0.999999f : (f < 0.0f ? 0.0f : f);
        if (this.isResStatic) {
            this.resUGen.setValue(this.res);
        } else {
            this.resUGen = new Static(this.context, this.res);
            this.isResStatic = true;
        }
        this.calcVals();
        return this;
    }

    public LPRezFilter setRes(UGen uGen) {
        if (uGen == null) {
            this.setRes(this.res);
        } else {
            this.resUGen = uGen;
            uGen.update();
            this.res = uGen.getValue();
            this.isResStatic = false;
        }
        return this;
    }

    public UGen getResUGen() {
        if (this.isResStatic) {
            return null;
        }
        return this.resUGen;
    }

    public LPRezFilter setParams(DataBead dataBead) {
        if (dataBead != null) {
            Object object = dataBead.get("frequency");
            if (object != null) {
                if (object instanceof UGen) {
                    this.setFrequency((UGen)object);
                } else {
                    this.setFrequency(dataBead.getFloat("frequency", this.freq));
                }
            }
            if ((object = dataBead.get("resonance")) != null) {
                if (object instanceof UGen) {
                    this.setRes((UGen)object);
                } else {
                    this.setRes(dataBead.getFloat("resonance", this.res));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.setParams((DataBead)bead);
        }
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isFreqStatic) {
            dataBead.put("frequency", (Object)Float.valueOf(this.freq));
        } else {
            dataBead.put("frequency", (Object)this.freqUGen);
        }
        if (this.isResStatic) {
            dataBead.put("resonance", (Object)Float.valueOf(this.res));
        } else {
            dataBead.put("resonance", (Object)this.resUGen);
        }
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("frequency", (Object)Float.valueOf(this.freq));
        dataBead.put("resonance", (Object)Float.valueOf(this.res));
        return dataBead;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        this.setParams(dataBead);
        return this;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float f) {
        return LPRezFilter.calculateFilterResponse(new float[]{this.b0}, new float[]{1.0f, this.a1, this.a2}, f, this.context.getSampleRate());
    }
}

