/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.core.UGenChain;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class MultiWrapper
extends UGenChain
implements DataBeadReceiver {
    private UGen[] ugens;
    private int channels;
    private int insPerChannel;
    private int outsPerChannel;

    public MultiWrapper(AudioContext audioContext, int n) {
        this(audioContext, n, 1, 1);
    }

    private MultiWrapper(AudioContext audioContext, int n, int n2) {
        super(audioContext, n, n2);
    }

    public MultiWrapper(AudioContext audioContext, int n, int n2, int n3) {
        this(audioContext, n * n2, n * n3);
        this.insPerChannel = n2;
        this.outsPerChannel = n3;
        this.channels = n;
        this.ugens = new UGen[n];
        for (int i = 0; i < n; ++i) {
            this.ugens[i] = this.buildUGens(i);
        }
        this.setupUGens();
    }

    public MultiWrapper(AudioContext audioContext, UGen[] uGenArray, int n, int n2) {
        this(audioContext, uGenArray.length * n, uGenArray.length * n2);
        this.insPerChannel = n;
        this.outsPerChannel = n2;
        this.channels = uGenArray.length;
        this.ugens = uGenArray;
        this.setupUGens();
    }

    private void setupUGens() {
        for (int i = 0; i < this.channels; ++i) {
            int n;
            for (n = 0; n < this.insPerChannel; ++n) {
                if (n >= this.ugens[i].getIns()) continue;
                this.drawFromChainInput(i * this.insPerChannel + n, this.ugens[i], n);
            }
            for (n = 0; n < this.outsPerChannel; ++n) {
                if (n >= this.ugens[i].getOuts()) continue;
                this.addToChainOutput(i * this.outsPerChannel + n, this.ugens[i], n);
            }
        }
    }

    public UGen buildUGens(int n) {
        return new UGen(this.context, 1, 0){

            @Override
            public void calculateBuffer() {
            }
        };
    }

    public void addInput(int n, int n2, UGen uGen, int n3) {
        this.addInput(n * this.insPerChannel + n2, uGen, n3);
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        for (int i = 0; i < this.channels; ++i) {
            if (this.ugens[i] instanceof DataBeadReceiver) {
                ((DataBeadReceiver)((Object)this.ugens[i])).sendData(dataBead);
                continue;
            }
            this.ugens[i].message(dataBead);
        }
        return this;
    }

    public DataBeadReceiver sendData(int n, DataBead dataBead) {
        for (int i = 0; i < this.channels; ++i) {
            if (this.ugens[i] instanceof DataBeadReceiver) {
                ((DataBeadReceiver)((Object)this.ugens[i])).sendData(dataBead);
                continue;
            }
            this.ugens[i].message(dataBead);
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.sendData((DataBead)bead);
        } else {
            for (int i = 0; i < this.channels; ++i) {
                this.ugens[i].message(bead);
            }
        }
    }

    public int getChannels() {
        return this.channels;
    }

    public int getInsPerChannel() {
        return this.insPerChannel;
    }

    public int getOutsPerChannel() {
        return this.outsPerChannel;
    }
}

