/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;

public class OscillatorBank
extends UGen {
    private float[] frequency;
    private float[] gains;
    private float[] point;
    private double[] increment;
    private Buffer buffer;
    private int numOscillators;
    private float gain;

    public OscillatorBank(AudioContext audioContext, Buffer buffer, int n) {
        super(audioContext, 1);
        this.buffer = buffer;
        this.setNumOscillators(n);
        this.gain = 1.0f / (float)n;
    }

    public void setNumOscillators(int n) {
        int n2;
        this.numOscillators = n;
        float[] fArray = this.frequency;
        this.frequency = new float[n];
        this.increment = new double[n];
        int n3 = 0;
        if (fArray != null) {
            n3 = Math.min(this.frequency.length, fArray.length);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.frequency[n2] = fArray[n2];
            this.increment[n2] = this.frequency[n2] / this.context.getSampleRate();
        }
        for (n2 = n3; n2 < this.frequency.length; ++n2) {
            this.frequency[n2] = 0.0f;
            this.increment[n2] = this.frequency[n2] / this.context.getSampleRate();
        }
        fArray = this.gains;
        this.gains = new float[n];
        for (n2 = 0; n2 < n3; ++n2) {
            this.gains[n2] = fArray[n2];
        }
        for (n2 = n3; n2 < this.gains.length; ++n2) {
            this.gains[n2] = 1.0f;
        }
        fArray = this.point;
        this.point = new float[n];
        for (n2 = 0; n2 < n3; ++n2) {
            this.point[n2] = fArray[n2];
        }
        for (n2 = n3; n2 < this.point.length; ++n2) {
            this.point[n2] = 0.0f;
        }
    }

    public void setFrequenciesAndGains(float[][] fArray) {
        for (int i = 0; i < this.numOscillators; ++i) {
            if (i < fArray.length) {
                this.frequency[i] = Math.abs(fArray[i][0]);
                this.gains[i] = fArray[i][1];
            } else {
                this.frequency[i] = 0.0f;
            }
            this.increment[i] = this.frequency[i] / this.context.getSampleRate();
        }
    }

    public void setFrequencies(float[] fArray) {
        for (int i = 0; i < this.numOscillators; ++i) {
            this.frequency[i] = i < fArray.length ? Math.abs(fArray[i]) : 0.0f;
            this.increment[i] = this.frequency[i] / this.context.getSampleRate();
        }
    }

    public float[] getFrequencies() {
        return this.frequency;
    }

    public void setGains(float[] fArray) {
        for (int i = 0; i < this.numOscillators; ++i) {
            this.gains[i] = i < fArray.length ? fArray[i] : 0.0f;
        }
    }

    public float[] getGains() {
        return this.gains;
    }

    @Override
    public void calculateBuffer() {
        this.zeroOuts();
        int n = 0;
        while (n < this.bufferSize) {
            for (int i = 0; i < this.numOscillators; ++i) {
                this.point[i] = (float)((double)this.point[i] + this.increment[i]) % 1.0f;
                float[] fArray = this.bufOut[0];
                int n2 = n;
                fArray[n2] = fArray[n2] + this.gains[i] * this.buffer.getValueFraction(this.point[i]);
            }
            float[] fArray = this.bufOut[0];
            int n3 = n++;
            fArray[n3] = fArray[n3] * this.gain;
        }
    }
}

