/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;

public class Panner
extends UGen
implements DataBeadReceiver {
    protected static int rootSize = 1024;
    public static float[] ROOTS = Panner.buildRoots(rootSize);
    protected float pos = 0.0f;
    protected float p1;
    protected float p2;
    protected UGen posUGen;
    protected boolean isPosStatic;

    public Panner(AudioContext audioContext) {
        this(audioContext, 0.0f);
    }

    public Panner(AudioContext audioContext, float f) {
        super(audioContext, 1, 2);
        this.setPos(f);
    }

    public Panner(AudioContext audioContext, UGen uGen) {
        super(audioContext, 1, 2);
        this.setPos(uGen);
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufIn[0];
        float[] fArray2 = this.bufOut[0];
        float[] fArray3 = this.bufOut[1];
        if (this.isPosStatic) {
            for (int i = 0; i < this.bufferSize; ++i) {
                fArray2[i] = this.p1 * fArray[i];
                fArray3[i] = this.p2 * fArray[i];
            }
        } else {
            this.posUGen.update();
            for (int i = 0; i < this.bufferSize; ++i) {
                float f;
                this.pos = this.posUGen.getValue(0, i);
                if (f >= 1.0f) {
                    this.p1 = 0.0f;
                    this.p2 = 1.0f;
                } else if (this.pos <= -1.0f) {
                    this.p1 = 1.0f;
                    this.p2 = 0.0f;
                } else {
                    float f2 = (this.pos + 1.0f) * 0.5f * (float)rootSize;
                    int n = (int)Math.floor(f2);
                    this.p2 = ROOTS[n] * (1.0f - (f2 -= (float)n)) + ROOTS[n + 1] * f2;
                    this.p1 = ROOTS[rootSize - n] * (1.0f - f2) + ROOTS[rootSize - (n + 1)] * f2;
                }
                fArray2[i] = this.p1 * fArray[i];
                fArray3[i] = this.p2 * fArray[i];
            }
        }
    }

    protected static float[] buildRoots(int n) {
        float[] fArray = new float[n + 2];
        for (int i = 0; i < n + 1; ++i) {
            fArray[i] = (float)Math.sqrt((float)i / (float)n);
        }
        fArray[n + 1] = 1.0f;
        return fArray;
    }

    public float getPos() {
        return this.pos;
    }

    public Panner setPos(float f) {
        float f2;
        this.pos = f;
        if (f2 >= 1.0f) {
            this.p1 = 0.0f;
            this.p2 = 1.0f;
        } else if (f <= -1.0f) {
            this.p1 = 1.0f;
            this.p2 = 0.0f;
        } else {
            float f3 = (f + 1.0f) * 0.5f * (float)rootSize;
            int n = (int)Math.floor(f3);
            this.p2 = ROOTS[n] * (1.0f - (f3 -= (float)n)) + ROOTS[n + 1] * f3;
            this.p1 = ROOTS[rootSize - n] * (1.0f - f3) + ROOTS[rootSize - (n + 1)] * f3;
        }
        this.isPosStatic = true;
        this.posUGen = null;
        return this;
    }

    public Panner setPos(UGen uGen) {
        if (uGen == null) {
            this.setPos(this.pos);
        } else {
            this.posUGen = uGen;
            uGen.update();
            this.pos = uGen.getValue();
            this.isPosStatic = false;
        }
        return this;
    }

    public UGen getPosUGen() {
        if (this.isPosStatic) {
            return null;
        }
        return this.posUGen;
    }

    public Panner setParams(DataBead dataBead) {
        Object object;
        if (dataBead != null && (object = dataBead.get("position")) != null) {
            if (object instanceof UGen) {
                this.setPos((UGen)object);
            } else {
                this.setPos(dataBead.getFloat("position", this.pos));
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead bead) {
        if (bead instanceof DataBead) {
            this.setParams((DataBead)bead);
        }
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isPosStatic) {
            dataBead.put("position", (Object)Float.valueOf(this.pos));
        } else {
            dataBead.put("position", (Object)this.posUGen);
        }
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("position", (Object)Float.valueOf(this.pos));
        return dataBead;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        this.setParams(dataBead);
        return this;
    }
}

