/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import java.util.Arrays;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class TapIn
extends UGen {
    private float[] mem;
    private int memLength;
    private int maxDelay;
    private int counter;
    private float sampsPerMS;

    public TapIn(AudioContext audioContext, float f) {
        super(audioContext, 1, 0);
        this.sampsPerMS = (float)audioContext.msToSamples(1.0);
        this.maxDelay = (int)audioContext.msToSamples(f) + 1;
        if (this.maxDelay < this.bufferSize) {
            this.maxDelay = this.bufferSize;
        }
        this.memLength = this.maxDelay + 1;
        this.mem = new float[this.memLength];
        Arrays.fill(this.mem, 0.0f);
        this.counter = 0;
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufIn[0];
        for (int i = 0; i < this.bufferSize; ++i) {
            this.mem[this.counter] = fArray[i];
            this.counter = (this.counter + 1) % this.memLength;
        }
    }

    public void fillBufferLinear(float[] fArray, UGen uGen) {
        int n = (this.counter - this.bufferSize + this.memLength) % this.memLength;
        for (int i = 0; i < fArray.length; ++i) {
            float f;
            float f2 = uGen.getValue(0, i) * this.sampsPerMS;
            if (f < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > (float)this.maxDelay) {
                f2 = this.maxDelay;
            }
            float f3 = f2 % 1.0f;
            int n2 = (n + i - (int)f2 - 1 + this.memLength) % this.memLength;
            int n3 = (n2 + 1) % this.memLength;
            fArray[i] = this.mem[n2] * f3 + this.mem[n3] * (1.0f - f3);
        }
    }

    public void fillBufferLinear(float[] fArray, float f) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > (float)this.maxDelay) {
            f = this.maxDelay;
        }
        float f2 = f % 1.0f;
        int n = this.counter - this.bufferSize - (int)f - 1 + this.memLength + this.memLength;
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = (n + i) % this.memLength;
            fArray[i] = this.mem[n2] * f2 + this.mem[(n2 + 1) % this.memLength] * (1.0f - f2);
        }
    }

    public void fillBufferNoInterp(float[] fArray, UGen uGen) {
        int n = this.counter - this.bufferSize + this.memLength + this.memLength;
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = (int)((double)(uGen.getValue(0, i) * this.sampsPerMS) + 0.5);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.maxDelay) {
                n2 = this.maxDelay;
            }
            fArray[i] = this.mem[(n + i - n2) % this.memLength];
        }
    }

    public void fillBufferNoInterp(float[] fArray, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.maxDelay) {
            n = this.maxDelay;
        }
        int n2 = this.counter - this.bufferSize - n + this.memLength + this.memLength;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.mem[(n2 + i) % this.memLength];
        }
    }

    public float fillBufferAllpass(float[] fArray, UGen uGen, float f) {
        int n = this.counter - this.bufferSize + this.memLength + this.memLength;
        for (int i = 0; i < fArray.length; ++i) {
            float f2;
            float f3 = uGen.getValue(0, i) * this.sampsPerMS;
            if (f2 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > (float)this.maxDelay) {
                f3 = this.maxDelay;
            }
            float f4 = f3 % 1.0f;
            float f5 = (1.0f - f4) / (1.0f + f4);
            int n2 = (n + i - (int)f3 - 1 + this.memLength) % this.memLength;
            fArray[i] = f = this.mem[n2] + f5 * (this.mem[(n2 + 1) % this.memLength] - f);
        }
        return f;
    }

    public float fillBufferAllpass(float[] fArray, int n, float f, float f2) {
        if (n < 0) {
            n = 0;
        } else if (n > this.maxDelay) {
            n = this.maxDelay;
        }
        int n2 = this.counter - this.bufferSize - n - 1 + this.memLength + this.memLength;
        for (int i = 0; i < fArray.length; ++i) {
            int n3 = (n2 + i) % this.memLength;
            fArray[i] = f2 = this.mem[n3] + f * (this.mem[(n3 + 1) % this.memLength] - f2);
        }
        return f2;
    }
}

