/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class TrapezoidWave
extends UGen {
    protected float index;
    protected float a;
    protected float b;
    protected float c;
    protected float abSlope;
    protected float cdSlope;
    protected float freq;
    protected float dutyCycle = 0.5f;
    protected float attack = 0.0f;
    protected float decay = 0.0f;
    protected float delta;
    protected float iSampleRate;
    protected UGen freqUGen;
    protected UGen dutyCycleUGen;
    protected UGen attackUGen;
    protected UGen decayUGen;

    public TrapezoidWave(AudioContext audioContext) {
        super(audioContext, 0, 1);
        this.iSampleRate = 1.0f / audioContext.getSampleRate();
        this.calcVals();
    }

    @Override
    public void calculateBuffer() {
        float[] fArray = this.bufOut[0];
        if (this.freqUGen != null) {
            this.freqUGen.update();
        }
        if (this.dutyCycleUGen != null) {
            this.dutyCycleUGen.update();
        }
        if (this.attackUGen != null) {
            this.attackUGen.update();
        }
        if (this.decayUGen != null) {
            this.decayUGen.update();
        }
        for (int i = 0; i < this.bufferSize; ++i) {
            boolean bl = false;
            if (this.dutyCycleUGen != null) {
                this.dutyCycle = this.dutyCycleUGen.getValue(0, i);
                if (this.dutyCycle < 0.0f) {
                    this.dutyCycle = 0.0f;
                } else if (this.dutyCycle > 1.0f) {
                    this.dutyCycle = 1.0f;
                }
                bl = true;
            }
            if (this.attackUGen != null) {
                this.attack = this.attackUGen.getValue(0, i);
                if (this.attack < 0.0f) {
                    this.attack = 0.0f;
                } else if (this.attack > 1.0f) {
                    this.attack = 1.0f;
                }
                bl = true;
            }
            if (this.decayUGen != null) {
                this.decay = this.decayUGen.getValue(0, i);
                if (this.decay < 0.0f) {
                    this.decay = 0.0f;
                } else if (this.decay > 1.0f) {
                    this.decay = 1.0f;
                }
                bl = true;
            }
            if (bl) {
                this.calcVals();
            }
            if (this.freqUGen != null) {
                this.freq = this.freqUGen.getValue(0, i);
                this.delta = this.freq * this.iSampleRate;
            }
            this.index = (this.index + this.delta) % 1.0f;
            if (this.index < 0.0f) {
                this.index = (this.index + 1.0f) % 1.0f;
            }
            fArray[i] = this.index > this.c ? 1.0f - this.cdSlope * (this.index - this.c) : (this.index > this.b ? 1.0f : (this.index > this.a ? -1.0f + this.abSlope * (this.index - this.a) : -1.0f));
        }
    }

    protected void calcVals() {
        this.a = 1.0f - this.dutyCycle;
        if (this.a >= 1.0f) {
            this.c = 1.0f;
            this.b = 1.0f;
            this.a = 1.0f;
            this.abSlope = 0.0f;
            this.cdSlope = 0.0f;
        } else {
            float f;
            float f2;
            float f3 = this.attack + this.decay;
            if (f3 > 0.0f) {
                f3 = (double)this.dutyCycle < 0.5 ? this.dutyCycle / f3 : (1.0f - this.dutyCycle) / f3;
                if ((double)f3 >= 0.5) {
                    f2 = this.attack;
                    f = this.decay;
                } else {
                    f2 = this.attack * 2.0f * f3;
                    f = this.decay * 2.0f * f3;
                }
            } else {
                f2 = 0.0f;
                f = 0.0f;
            }
            this.c = 1.0f - f;
            this.b = this.c - this.dutyCycle + (f2 + f) * 0.5f;
            this.a = this.b - f2;
            this.abSlope = this.a == this.b ? 0.0f : 2.0f / (this.b - this.a);
            this.cdSlope = this.c == 1.0f ? 0.0f : 2.0f / (1.0f - this.c);
        }
    }

    public TrapezoidWave setFrequency(float f) {
        this.freq = f;
        this.freqUGen = null;
        this.delta = f * this.iSampleRate;
        return this;
    }

    public TrapezoidWave setFrequency(UGen uGen) {
        if (uGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = uGen;
            uGen.update();
            this.freq = uGen.getValue();
        }
        return this;
    }

    public float getFrequency() {
        return this.freq;
    }

    public UGen getFrequencyUGen() {
        return this.freqUGen;
    }

    public TrapezoidWave setDutyCycle(UGen uGen) {
        if (uGen == null) {
            this.setDutyCycle(this.dutyCycle);
        } else {
            this.dutyCycleUGen = uGen;
            uGen.update();
            this.dutyCycle = uGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public TrapezoidWave setDutyCycle(float f) {
        this.dutyCycleUGen = null;
        this.dutyCycle = f;
        if (this.dutyCycle < 0.0f) {
            this.dutyCycle = 0.0f;
        } else if (this.dutyCycle > 1.0f) {
            this.dutyCycle = 1.0f;
        }
        this.calcVals();
        return this;
    }

    public float getDutyCycle() {
        return this.dutyCycle;
    }

    public UGen getDutyCycleUGen() {
        return this.dutyCycleUGen;
    }

    public TrapezoidWave setAttack(UGen uGen) {
        if (uGen == null) {
            this.setAttack(this.attack);
        } else {
            this.attackUGen = uGen;
            uGen.update();
            this.attack = uGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public TrapezoidWave setAttack(float f) {
        this.attackUGen = null;
        this.attack = f;
        if (this.attack < 0.0f) {
            this.attack = 0.0f;
        } else if (this.attack > 1.0f) {
            this.attack = 1.0f;
        }
        this.calcVals();
        return this;
    }

    public float getAttack() {
        return this.attack;
    }

    public UGen getAttackUGen() {
        return this.attackUGen;
    }

    public TrapezoidWave setDecay(UGen uGen) {
        if (uGen == null) {
            this.setDecay(this.decay);
        } else {
            this.decayUGen = uGen;
            uGen.update();
            this.decay = uGen.getValue();
            this.calcVals();
        }
        return this;
    }

    public TrapezoidWave setDecay(float f) {
        this.decayUGen = null;
        this.decay = f;
        if (f < 0.0f) {
            this.decay = 0.0f;
        } else if (f > 1.0f) {
            this.decay = 1.0f;
        }
        this.calcVals();
        return this;
    }

    public float getDecay() {
        return this.decay;
    }

    public UGen getDecayUGen() {
        return this.decayUGen;
    }
}

