/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.Static;

public class WaveShaper
extends UGen
implements DataBeadReceiver {
    protected float preGain = 2.0f;
    protected float postGain = 1.0f;
    protected float limit = 1.0f;
    protected float wetMix = 1.0f;
    protected UGen preGainUGen;
    protected UGen postGainUGen;
    protected UGen limitUGen;
    protected UGen wetMixUGen;
    protected boolean isPreGainStatic = false;
    protected boolean isPostGainStatic = false;
    protected boolean isLimitStatic = false;
    protected boolean isWetMixStatic = false;
    protected float[] shape;
    protected int shapeLen;
    protected int channels = 1;

    public WaveShaper(AudioContext audioContext) {
        this(audioContext, 1);
    }

    public WaveShaper(AudioContext audioContext, int n) {
        super(audioContext, n, n);
        this.channels = n;
        this.setPreGain(2.0f).setPostGain(1.0f).setLimit(1.0f).setWetMix(1.0f);
        this.setShape(WaveShaper.generateCosineShape(1025));
    }

    public WaveShaper(AudioContext audioContext, float[] fArray) {
        this(audioContext);
        this.setShape(fArray);
    }

    public WaveShaper(AudioContext audioContext, int n, float[] fArray) {
        this(audioContext, n);
        this.setShape(fArray);
    }

    public WaveShaper(AudioContext audioContext, Buffer buffer) {
        this(audioContext);
        this.setShape(buffer.buf);
    }

    public WaveShaper(AudioContext audioContext, int n, Buffer buffer) {
        this(audioContext, n);
        this.setShape(buffer.buf);
    }

    public static float[] generateCosineShape(int n) {
        float[] fArray = new float[n];
        int n2 = n - 1;
        for (int i = 1; i < n - 1; ++i) {
            fArray[i] = 0.0f - (float)Math.cos((double)i * Math.PI / (double)n2);
        }
        fArray[0] = -1.0f;
        fArray[n - 1] = 1.0f;
        if (n % 2 == 1) {
            fArray[n2 / 2] = 0.0f;
        }
        return fArray;
    }

    public static float[] generateExponentialShape(int n, float f) {
        float[] fArray = new float[n];
        int n2 = n - 1;
        for (int i = 1; i < n - 1; ++i) {
            float f2 = i / n2 * 2 - 1;
            fArray[i] = f2 < 0.0f ? (float)(-Math.pow(-f2, f)) : (f2 == 0.0f ? 0.0f : (float)Math.pow(f2, f));
        }
        fArray[0] = -1.0f;
        fArray[n - 1] = 1.0f;
        if (n % 2 == 1) {
            fArray[n2 / 2] = 0.0f;
        }
        return fArray;
    }

    @Override
    public void calculateBuffer() {
        this.preGainUGen.update();
        this.postGainUGen.update();
        this.limitUGen.update();
        this.wetMixUGen.update();
        if (this.channels == 1) {
            float[] fArray = this.bufIn[0];
            float[] fArray2 = this.bufOut[0];
            for (int i = 0; i < this.bufferSize; ++i) {
                float f;
                this.preGain = this.preGainUGen.getValue(0, i);
                this.postGain = this.postGainUGen.getValue(0, i);
                this.limit = this.limitUGen.getValue(0, i);
                if (this.limit < 0.0f) {
                    this.limit = 0.0f;
                }
                this.wetMix = this.wetMixUGen.getValue(0, i);
                float f2 = fArray[i];
                float f3 = (f2 * this.preGain * 0.5f + 0.5f) * (float)this.shapeLen;
                if (f3 <= 0.0f) {
                    f = this.shape[0] * this.postGain;
                } else if (f3 >= (float)this.shapeLen) {
                    f = this.shape[this.shapeLen] * this.postGain;
                } else {
                    int n = (int)f3;
                    float f4 = f3 - (float)n;
                    f = (this.shape[n] * (1.0f - f4) + this.shape[n + 1] * f4) * this.postGain;
                }
                if (f > this.limit) {
                    f = this.limit;
                } else if (f < -this.limit) {
                    f = -this.limit;
                }
                fArray2[i] = f2 * (1.0f - this.wetMix) + f * this.wetMix;
            }
        } else {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.preGain = this.preGainUGen.getValue(0, i);
                this.postGain = this.postGainUGen.getValue(0, i);
                this.limit = this.limitUGen.getValue(0, i);
                if (this.limit < 0.0f) {
                    this.limit = 0.0f;
                }
                this.wetMix = this.wetMixUGen.getValue(0, i);
                for (int j = 0; j < this.channels; ++j) {
                    float f;
                    float f5 = this.bufIn[j][i];
                    float f6 = (f5 * this.preGain * 0.5f + 0.5f) * (float)this.shapeLen;
                    if (f6 <= 0.0f) {
                        f = this.shape[0] * this.postGain;
                    } else if (f6 >= (float)this.shapeLen) {
                        f = this.shape[this.shapeLen] * this.postGain;
                    } else {
                        int n = (int)f6;
                        float f7 = f6 - (float)n;
                        f = (this.shape[n] * (1.0f - f7) + this.shape[n + 1] * f7) * this.postGain;
                    }
                    if (f > this.limit) {
                        f = this.limit;
                    } else if (f < -this.limit) {
                        f = -this.limit;
                    }
                    this.bufOut[j][i] = f5 * (1.0f - this.wetMix) + f * this.wetMix;
                }
            }
        }
    }

    public float getPreGain() {
        return this.preGain;
    }

    public WaveShaper setPreGain(float f) {
        this.preGain = f;
        if (this.isPreGainStatic) {
            this.preGainUGen.setValue(f);
        } else {
            this.preGainUGen = new Static(this.context, f);
            this.isPreGainStatic = true;
        }
        return this;
    }

    public WaveShaper setPreGain(UGen uGen) {
        if (uGen == null) {
            this.setPreGain(this.preGain);
        } else {
            this.preGainUGen = uGen;
            uGen.update();
            this.preGain = uGen.getValue();
            this.isPreGainStatic = false;
        }
        return this;
    }

    public UGen getPreGainUGen() {
        if (this.isPreGainStatic) {
            return null;
        }
        return this.preGainUGen;
    }

    public float getPostGain() {
        return this.postGain;
    }

    public WaveShaper setPostGain(float f) {
        this.postGain = f;
        if (this.isPostGainStatic) {
            this.postGainUGen.setValue(f);
        } else {
            this.postGainUGen = new Static(this.context, f);
            this.isPostGainStatic = true;
        }
        return this;
    }

    public WaveShaper setPostGain(UGen uGen) {
        if (uGen == null) {
            this.setPostGain(this.postGain);
        } else {
            this.postGainUGen = uGen;
            uGen.update();
            this.postGain = uGen.getValue();
            this.isPostGainStatic = false;
        }
        return this;
    }

    public UGen getPostGainUGen() {
        if (this.isPostGainStatic) {
            return null;
        }
        return this.postGainUGen;
    }

    public float getLimit() {
        return this.limit;
    }

    public WaveShaper setLimit(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.limit = f;
        if (this.isLimitStatic) {
            this.limitUGen.setValue(f);
        } else {
            this.limitUGen = new Static(this.context, f);
            this.isLimitStatic = true;
        }
        return this;
    }

    public WaveShaper setLimit(UGen uGen) {
        if (uGen == null) {
            this.setLimit(this.limit);
        } else {
            this.limitUGen = uGen;
            uGen.update();
            this.limit = uGen.getValue();
            this.isLimitStatic = false;
        }
        return this;
    }

    public UGen getLimitUGen() {
        if (this.isLimitStatic) {
            return null;
        }
        return this.limitUGen;
    }

    public float getWetMix() {
        return this.wetMix;
    }

    public WaveShaper setWetMix(float f) {
        this.wetMix = f;
        if (this.isWetMixStatic) {
            this.wetMixUGen.setValue(f);
        } else {
            this.wetMixUGen = new Static(this.context, f);
            this.isWetMixStatic = true;
        }
        return this;
    }

    public WaveShaper setWetMix(UGen uGen) {
        if (uGen == null) {
            this.setWetMix(this.wetMix);
        } else {
            this.wetMixUGen = uGen;
            uGen.update();
            this.wetMix = uGen.getValue();
            this.isWetMixStatic = false;
        }
        return this;
    }

    public UGen getWetMixUGen() {
        if (this.isWetMixStatic) {
            return null;
        }
        return this.wetMixUGen;
    }

    public float[] getShape() {
        return this.shape;
    }

    public WaveShaper setShape(float[] fArray) {
        if (fArray != null && fArray.length > 1) {
            this.shape = fArray;
            this.shapeLen = fArray.length - 1;
        }
        return this;
    }

    @Override
    public DataBeadReceiver sendData(DataBead dataBead) {
        if (dataBead != null) {
            UGen uGen = dataBead.getUGen("preGain");
            if (uGen != null) {
                this.setPreGain(uGen);
            } else {
                this.setPreGain(dataBead.getFloat("preGain", this.preGain));
            }
            uGen = dataBead.getUGen("postGain");
            if (uGen != null) {
                this.setPostGain(uGen);
            } else {
                this.setPostGain(dataBead.getFloat("postGain", this.postGain));
            }
            uGen = dataBead.getUGen("limit");
            if (uGen != null) {
                this.setLimit(uGen);
            } else {
                this.setLimit(dataBead.getFloat("limit", this.limit));
            }
            uGen = dataBead.getUGen("wetMix");
            if (uGen != null) {
                this.setWetMix(uGen);
            } else {
                this.setWetMix(dataBead.getFloat("wetMix", this.wetMix));
            }
            this.setShape(dataBead.getFloatArray("shape"));
        }
        return this;
    }

    public DataBead getParams() {
        DataBead dataBead = new DataBead();
        if (this.isPreGainStatic) {
            dataBead.put("preGain", (Object)Float.valueOf(this.preGain));
        } else {
            dataBead.put("preGain", (Object)this.preGainUGen);
        }
        if (this.isPostGainStatic) {
            dataBead.put("postGain", (Object)Float.valueOf(this.postGain));
        } else {
            dataBead.put("postGain", (Object)this.postGainUGen);
        }
        if (this.isLimitStatic) {
            dataBead.put("limit", (Object)Float.valueOf(this.limit));
        } else {
            dataBead.put("limit", (Object)this.limitUGen);
        }
        if (this.isWetMixStatic) {
            dataBead.put("wetMix", (Object)Float.valueOf(this.wetMix));
        } else {
            dataBead.put("wetMix", (Object)this.wetMixUGen);
        }
        dataBead.put("shape", (Object)this.shape);
        return dataBead;
    }

    public DataBead getStaticParams() {
        DataBead dataBead = new DataBead();
        dataBead.put("preGain", (Object)Float.valueOf(this.preGain));
        dataBead.put("postGain", (Object)Float.valueOf(this.postGain));
        dataBead.put("limit", (Object)Float.valueOf(this.limit));
        dataBead.put("wetMix", (Object)Float.valueOf(this.wetMix));
        dataBead.put("shape", (Object)this.shape);
        return dataBead;
    }
}

