/*
 * Decompiled with CFR 0.152.
 */
package net.musicalmetacreation.musebot.conductor;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.Pane;
import net.musicalmetacreation.musebot.conductor.Host;

public class ClientRep {
    final String name;
    final InetSocketAddress address;
    final Host host;
    long lastAlive;
    boolean isPlaying;
    Pane gui;
    List<StatusListener> listeners = new ArrayList<StatusListener>();

    public ClientRep(String name, Host host, int port) {
        this.address = new InetSocketAddress(host.hostname, port);
        this.host = host;
        this.name = name;
    }

    public String longName() {
        return String.valueOf(this.name) + "@" + this.host.hostname;
    }

    public void touch() {
        this.lastAlive = System.currentTimeMillis();
    }

    public void setAlive() {
        this.touch();
        if (!this.isPlaying) {
            this.updateStatus("Playing");
        }
        this.isPlaying = true;
    }

    public boolean isOutOfDate() {
        return System.currentTimeMillis() - this.lastAlive > 5000L;
    }

    public String toString() {
        return "Musebot ClientRep [name=" + this.name + ", hostname=" + this.address.getHostName() + ", port=" + this.address.getPort() + "]";
    }

    public Pane getGui() {
        return this.gui;
    }

    public void setGui(Pane gui) {
        this.gui = gui;
    }

    void updateStatus(String status) {
        for (StatusListener listener : this.listeners) {
            listener.setStatus(status);
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setDead() {
        this.isPlaying = false;
        this.updateStatus("Not Playing");
    }

    public static interface StatusListener {
        public void setStatus(String var1);
    }
}

