/*
 * Decompiled with CFR 0.152.
 */
package net.musicalmetacreation.musebot.conductor;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.Slider;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import net.musicalmetacreation.musebot.conductor.ClientRep;
import net.musicalmetacreation.musebot.conductor.Conductor;

public class ClientRepGUICell
extends ListCell<ClientRep> {
    int count = 0;
    final Conductor conductor;

    public ClientRepGUICell(Conductor conductor) {
        this.conductor = conductor;
    }

    public void updateItem(final ClientRep item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setGraphic(null);
        if (item != null) {
            if (item.getGui() == null) {
                HBox gui = new HBox();
                Text text1 = new Text(item.name);
                text1.setFill((Paint)Color.BLACK);
                Text text2 = new Text(" (" + item.host.hostname + ")");
                text2.setFill((Paint)Color.GREY);
                TextFlow textFlow = new TextFlow(new Node[]{text1, text2});
                HBox txthbox = new HBox();
                txthbox.setMinWidth(300.0);
                txthbox.getChildren().add((Object)textFlow);
                gui.getChildren().add((Object)txthbox);
                final Button startStopBotton = new Button("Start");
                startStopBotton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e) {
                        if (!item.isPlaying()) {
                            ClientRepGUICell.this.conductor.startClient(item);
                            item.updateStatus("Starting....");
                        } else {
                            ClientRepGUICell.this.conductor.killClient(item);
                            item.updateStatus("Stopping....");
                        }
                    }
                });
                HBox buttonhbox = new HBox();
                buttonhbox.setMinWidth(75.0);
                buttonhbox.getChildren().add((Object)startStopBotton);
                gui.getChildren().add((Object)buttonhbox);
                Slider levelSlider = new Slider(0.0, 1.0, 1.0);
                levelSlider.setOrientation(Orientation.HORIZONTAL);
                levelSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> obs, Number oldval, Number newval) {
                        ClientRepGUICell.this.conductor.setClientLevel(item, newval.doubleValue(), 50.0);
                    }
                });
                HBox sliderhbox = new HBox();
                sliderhbox.setMinWidth(150.0);
                sliderhbox.getChildren().add((Object)levelSlider);
                gui.getChildren().add((Object)sliderhbox);
                final Text statusBox = new Text("Not Playing");
                HBox statushbox = new HBox();
                statushbox.setMinWidth(200.0);
                statushbox.getChildren().add((Object)statusBox);
                gui.getChildren().add((Object)statushbox);
                item.setGui((Pane)gui);
                item.listeners.add(new ClientRep.StatusListener(){

                    @Override
                    public void setStatus(final String status) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                statusBox.setText(status);
                                if (status.equals("Playing")) {
                                    startStopBotton.setText("Stop");
                                } else if (status.equals("Not Playing")) {
                                    startStopBotton.setText("Start");
                                }
                            }
                        });
                    }
                });
            }
            this.setGraphic((Node)item.getGui());
        }
    }
}

